/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.filter;

import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.filter.CCFFilter;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.basic.ChromosomeBox;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Map;

public class GTBFilter
extends CCFFilter {
    final CCFIntIndexer<Chromosome> indexer;

    public GTBFilter(GTBReaderOption option) throws IOException {
        super(option);
        this.indexer = option.getGTBManager().getIndexer();
    }

    public GTBFilter(GTBManager manager) throws IOException {
        super(new ReaderOption(manager.getTable(), "CHROM", "POS"));
        this.indexer = manager.getIndexer();
    }

    @Override
    public GTBFilter limit(long start, long end) {
        super.limit(start, end);
        return this;
    }

    @Override
    public GTBFilter limit(LongInterval interval) {
        super.limit(interval);
        return this;
    }

    @Override
    public GTBFilter addPointerFilter(ILongFilter filter) {
        super.addPointerFilter(filter);
        return this;
    }

    @Override
    public GTBFilter addRecordFilter(IFilter<BoxRecord> filter) {
        super.addRecordFilter(filter);
        return this;
    }

    @Override
    public <V extends Box<?, ?>> GTBFilter addValueFilter(String field, IFilter<V> filter) {
        super.addValueFilter(field, filter);
        return this;
    }

    @Override
    public <V extends Box<?, ?>> GTBFilter addValueFilter(FieldMeta field, IFilter<V> filter) {
        super.addValueFilter(field, filter);
        return this;
    }

    @Override
    public GTBFilter seek(long pointer) throws IOException {
        super.seek(pointer);
        return this;
    }

    @Override
    public GTBFilter reset() {
        super.reset();
        return this;
    }

    @Override
    public GTBFilter close() throws IOException {
        super.close();
        return this;
    }

    public boolean find(Coordinate coordinate) throws IOException {
        return this.find(coordinate.getChromosome(), coordinate.getPosition());
    }

    public boolean find(Chromosome chromosome, int position) throws IOException {
        if (!this.reader.hasNext()) {
            return false;
        }
        ChromosomeBox chromosomeBox = (ChromosomeBox)this.record.getBox(null, "CHROM");
        VarInt32Box posBox = (VarInt32Box)this.record.getBox(null, "POS");
        if (this.indexer == null) {
            while (this.reader.read(this.record)) {
                if (chromosomeBox.get() != chromosome || posBox.intValue() != position) continue;
                this.reader.seek(this.reader.tell() - 1L);
                return true;
            }
            return false;
        }
        RefinedIntBuckets buckets = this.indexer.getTag(chromosome);
        if (buckets == null) {
            return false;
        }
        if (buckets.getMaxValue() < position) {
            if (this.reader.tell() < buckets.getMaxPointer()) {
                this.reader.seek(buckets.getMaxPointer() + 1L);
            }
            return false;
        }
        if (buckets.getMinValue() > position) {
            if (this.reader.tell() < buckets.getMinPointer()) {
                this.reader.seek(buckets.getMinPointer());
            }
            return false;
        }
        List<IntBucket> containsBuckets = buckets.getContains(position);
        block1: for (IntBucket bucket : containsBuckets) {
            long pointer;
            if (bucket.getMaxPointer() < this.reader.tell()) continue;
            if (bucket.getMinPointer() > this.reader.tell()) {
                this.reader.seek(bucket.getMinPointer());
                if (this.reader.tell() != bucket.getMinPointer()) {
                    return false;
                }
            }
            if (bucket.isOrdered()) {
                while (true) {
                    pointer = this.reader.tell();
                    if (bucket.getMinPointer() > pointer || bucket.getMaxPointer() < pointer || !this.reader.read(this.record)) continue block1;
                    if (chromosomeBox.get() != chromosome) continue;
                    if (posBox.intValue() == position) {
                        this.reader.seek(pointer);
                        return true;
                    }
                    if (posBox.intValue() > position) break;
                }
                this.reader.seek(pointer - 1L);
                if (!buckets.isOrdered()) continue;
                return false;
            }
            do {
                pointer = this.reader.tell();
                if (bucket.getMinPointer() > pointer || bucket.getMaxPointer() < pointer || !this.reader.read(this.record)) continue block1;
            } while (chromosomeBox.get() != chromosome || posBox.intValue() != position);
            this.reader.seek(pointer);
            return true;
        }
        return false;
    }

    public GTBFilter addCoordinateFilter(Map<Chromosome, List<IntInterval>> poses) {
        if (poses != null) {
            if (poses.size() == 0) {
                return this.addPointerFilter(pointer -> false);
            }
            THashMap coordinateTrees = new THashMap(poses.size());
            if (this.indexer == null) {
                for (Chromosome chromosome : poses.keySet()) {
                    List<IntInterval> intervals = poses.get(chromosome);
                    if (intervals == null) {
                        coordinateTrees.put(chromosome, null);
                        continue;
                    }
                    if (intervals.size() <= 0) continue;
                    IntIntervalTree.Builder coordinateTreeBuilder = new IntIntervalTree.Builder();
                    for (IntInterval interval : intervals) {
                        if (interval.end() < 1) continue;
                        coordinateTreeBuilder.add(interval, null);
                    }
                    IntIntervalTree coordinateTree = coordinateTreeBuilder.build();
                    if (coordinateTree.size() <= 0) continue;
                    coordinateTrees.put(chromosome, coordinateTree);
                }
            } else {
                LongIntervalTree.Builder pointerTreeBuilder = new LongIntervalTree.Builder();
                for (Chromosome chromosome : poses.keySet()) {
                    RefinedIntBuckets buckets = this.indexer.getTag(chromosome);
                    if (buckets == null) continue;
                    List<IntInterval> intervals = poses.get(chromosome);
                    if (intervals == null) {
                        coordinateTrees.put(chromosome, null);
                        pointerTreeBuilder.add(buckets.getMinPointer(), buckets.getMaxPointer(), null);
                        continue;
                    }
                    if (intervals.size() <= 0) continue;
                    IntIntervalTree.Builder coordinateTreeBuilder = new IntIntervalTree.Builder();
                    for (IntInterval interval : intervals) {
                        if (interval.end() < 1) continue;
                        boolean hasOverlaps = false;
                        for (IntBucket bucket : buckets.getOverlaps(interval.start(), interval.end())) {
                            hasOverlaps = true;
                            pointerTreeBuilder.add(bucket.getMinPointer(), bucket.getMaxPointer(), null);
                        }
                        if (!hasOverlaps) continue;
                        coordinateTreeBuilder.add(interval, null);
                    }
                    IntIntervalTree coordinateTree = coordinateTreeBuilder.build();
                    if (coordinateTree.size() <= 0) continue;
                    coordinateTrees.put(chromosome, coordinateTree);
                }
                LongIntervalTree pointerTree = pointerTreeBuilder.build();
                if (pointerTree.size() > 0) {
                    this.addPointerFilter(pointerTree::contains);
                }
            }
            if (coordinateTrees.size() == 0) {
                return this.addPointerFilter(pointer -> false);
            }
            return this.addRecordFilter(record -> {
                Chromosome chromosome = (Chromosome)record.get(null, "CHROM");
                if (coordinateTrees.containsKey(chromosome)) {
                    IntIntervalTree tree = (IntIntervalTree)coordinateTrees.get(chromosome);
                    if (tree == null) {
                        return true;
                    }
                    VarInt32Box pos = (VarInt32Box)record.getBox(null, "POS");
                    if (tree.contains(pos.intValue())) {
                        return true;
                    }
                }
                return false;
            });
        }
        return this;
    }
}

