/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.container.entry.TEntry;
import edu.sysu.pmglab.container.indexable.ConcurrentLinkedSet;
import edu.sysu.pmglab.container.indexable.DynamicIndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.PositionType;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.Genotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LargeGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LiteGenotypes;
import java.util.AbstractCollection;
import java.util.Map;
import java.util.function.BiFunction;

public class Variant
implements Comparable<Variant> {
    private static final IndexableSet<String> FIELDS = new ConcurrentLinkedSet<String>();
    private final Coordinate coordinate;
    private IGenotypes genotypes = CacheGenotypes.EMPTY;
    private IndexableSet<String> alleles;
    private Map<String, Object> property;

    public Variant(String chromosome, int position) {
        this.coordinate = new Coordinate(chromosome, position);
    }

    public Variant(Chromosome chromosome, int position) {
        this.coordinate = new Coordinate(chromosome, position);
    }

    public Variant(Coordinate coordinate) {
        if (coordinate == null) {
            throw new NullPointerException("Invalid genome coordinate");
        }
        this.coordinate = coordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyKey(String key) {
        IndexableSet<String> indexableSet = FIELDS;
        synchronized (indexableSet) {
            FIELDS.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyKeys(Iterable<String> keys2) {
        IndexableSet<String> indexableSet = FIELDS;
        synchronized (indexableSet) {
            for (String key : keys2) {
                FIELDS.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyKeys(IFieldCollection keys2) {
        IndexableSet<String> indexableSet = FIELDS;
        synchronized (indexableSet) {
            for (FieldMeta field : keys2) {
                FIELDS.add(field.fullName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyKeys(String[] key) {
        IndexableSet<String> indexableSet = FIELDS;
        synchronized (indexableSet) {
            FIELDS.addAll((String[])key);
        }
    }

    public static IndexableSet<String> propertyKeys() {
        return FIELDS.asUnmodifiable();
    }

    public static boolean isStandardAllele(String allele) {
        if (allele == null || allele.length() == 0) {
            return false;
        }
        allele = allele.toUpperCase();
        for (int i = 0; i < allele.length(); ++i) {
            char base = allele.charAt(i);
            if (base == 'A' || base == 'T' || base == 'C' || base == 'G') continue;
            return false;
        }
        return true;
    }

    private static String isValidAllele(Coordinate coordinate, String allele) {
        if (allele == null || allele.length() == 0) {
            throw new GTBComponentException("Illegal reference/alternative allele of variant " + coordinate + ": the length of the allele must be >= 1");
        }
        for (int i = 0; i < allele.length(); ++i) {
            char base = allele.charAt(i);
            if (Character.isWhitespace(base)) {
                throw new GTBComponentException("Illegal alternative allele of variant " + coordinate + ": contains non-visible characters (ascii code: " + base + ")");
            }
            if (base == ',') {
                throw new GTBComponentException("Illegal alternative allele of variant" + coordinate + ": contains comma (i.e., ,)");
            }
            if (base == ';') {
                throw new GTBComponentException("Illegal alternative allele of variant" + coordinate + ": contains semicolon (i.e., ;)");
            }
            if (base <= '\u007f') continue;
            throw new GTBComponentException("Illegal alternative allele of variant " + coordinate + ": contains non-ascii characters (char code: " + base + ")");
        }
        return allele.toUpperCase();
    }

    public static IRecord calculate(Variant variant1, Variant variant2, BiFunction<Variant, Variant, IRecord> model) {
        if (model == null) {
            return null;
        }
        return model.apply(variant1, variant2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Variant> join(Iterable<Variant> variants) {
        Coordinate coordinate = null;
        int numOfIndividuals = -1;
        for (Variant variant : variants) {
            if (coordinate == null) {
                coordinate = variant.getCoordinate();
            } else if (!coordinate.equals(variant.getCoordinate())) {
                throw new UnsupportedOperationException("Cannot join variants: inconsistent coordinates. Expected: " + coordinate + ", but found: " + variant.getCoordinate());
            }
            if (numOfIndividuals == -1) {
                numOfIndividuals = variant.getGenotypes().size();
                continue;
            }
            if (numOfIndividuals == variant.getGenotypes().size()) continue;
            throw new UnsupportedOperationException("Cannot join variants: inconsistent number of individuals. Expected: " + numOfIndividuals + ", but found: " + variant.getGenotypes().size() + " at coordinate " + variant.getCoordinate());
        }
        if (numOfIndividuals == 0 || coordinate == null) {
            return List.EMPTY();
        }
        List<Variant> results = new List<Variant>();
        List candidateVariants = new List();
        for (Variant variant : variants) {
            void var6_10;
            IGenotypes genotypes;
            int[] ACs;
            if (variant.numOfAlleles() < 1 || (ACs = (genotypes = variant.getGenotypes()).counter().getACs()).length == 0) continue;
            int[] alleleIndexes = new int[ACs.length + 1];
            alleleIndexes[0] = -1;
            int index = 1;
            for (int i2 = 1; i2 < ACs.length; ++i2) {
                alleleIndexes[i2 + 1] = ACs[i2] > 0 ? index++ : -1;
            }
            if (index != variant.numOfAlleles()) {
                genotypes = variant.getGenotypes().map(alleleIndexes);
                LinkedSet<String> alleles = new LinkedSet<String>(index);
                ((AbstractCollection)alleles).add(variant.alleleOfIndex(0));
                for (int i3 = 1; i3 < ACs.length; ++i3) {
                    if (alleleIndexes[i3 + 1] == -1) continue;
                    ((AbstractCollection)alleles).add(variant.alleleOfIndex(i3));
                }
                Variant variant2 = new Variant(variant.getCoordinate());
                variant2.alleles = alleles;
            } else {
                Variant variant3 = new Variant(variant.getCoordinate()).addAlleles(variant.getAlleles());
            }
            if (var6_10.isStandardAllele() && var6_10.alleleOfIndex(0).length() > 1) {
                void var13_28;
                String ref = var6_10.alleleOfIndex(0);
                int offset = 0;
                boolean bl = false;
                block4: while (var13_28 < ref.length() - 1) {
                    char lastChar = ref.charAt(ref.length() - var13_28 - 1);
                    for (int j = 1; j < var6_10.numOfAlleles(); ++j) {
                        String alt = var6_10.alleles.valueOf(j);
                        if (alt.length() <= var13_28 + true || alt.charAt(alt.length() - var13_28 - 1) != lastChar) break block4;
                    }
                    ++offset;
                    ++var13_28;
                }
                if (offset > 0) {
                    LinkedSet<String> linkedSet = new LinkedSet<String>(var6_10.numOfAlleles());
                    for (String allele : var6_10.alleles) {
                        ((AbstractCollection)linkedSet).add(allele.substring(0, allele.length() - offset));
                    }
                    var6_10.alleles = linkedSet;
                }
            }
            var6_10.genotypes = genotypes.clone();
            boolean merge = false;
            for (TEntry tEntry : candidateVariants) {
                if (!((Variant)tEntry.getKey()).alleleOfIndex(0).equals(var6_10.alleleOfIndex(0))) continue;
                ((List)tEntry.getValue()).add(var6_10);
                merge = true;
                break;
            }
            if (merge) continue;
            candidateVariants.add(new TEntry(var6_10, new List()));
        }
        for (TEntry tEntry : candidateVariants) {
            Genotype genotype;
            int n;
            Object variant22;
            Variant majorVariant = (Variant)tEntry.getKey();
            List minorVariants = (List)tEntry.getValue();
            if (minorVariants.size() == 0) {
                results.add(majorVariant);
                continue;
            }
            boolean phased = majorVariant.getGenotypes().isPhased();
            if (phased) {
                for (Object variant22 : minorVariants) {
                    if (((Variant)variant22).getGenotypes().isPhased()) continue;
                    phased = false;
                    break;
                }
            }
            Variant variant3 = new Variant(majorVariant.getCoordinate()).addAlleles(majorVariant.alleles);
            variant22 = minorVariants.iterator();
            while (variant22.hasNext()) {
                Variant minorVariant = (Variant)variant22.next();
                variant3.addAlleles(minorVariant.alleles);
            }
            IGenotypes genotypes = variant3.numOfAlleles() <= 15 ? new LiteGenotypes(numOfIndividuals, phased) : (variant3.numOfAlleles() <= 255 ? new Genotypes(numOfIndividuals, phased) : new LargeGenotypes(numOfIndividuals, phased));
            variant3.setGenotypes(genotypes);
            IGenotypes[] remapGenotypes = new IGenotypes[minorVariants.size() + 1];
            remapGenotypes[0] = majorVariant.getGenotypes().setPhased(phased);
            for (n = 0; n < minorVariants.size(); ++n) {
                Variant minorVariant = (Variant)minorVariants.get(n);
                int[] alleleIndexes = new int[minorVariant.numOfAlleles() + 1];
                alleleIndexes[0] = -1;
                for (int j = 0; j < minorVariant.numOfAlleles(); ++j) {
                    alleleIndexes[j + 1] = variant3.indexOfAllele(minorVariant.alleleOfIndex(j));
                }
                remapGenotypes[n + 1] = minorVariant.getGenotypes().setPhased(phased).map(alleleIndexes);
            }
            if (phased) {
                for (n = 0; n < numOfIndividuals; ++n) {
                    int left = -1;
                    int right = -1;
                    for (IGenotypes remapGenotype : remapGenotypes) {
                        genotype = remapGenotype.get(n);
                        if (genotype.left() != -1 && left <= 0) {
                            left = genotype.left();
                        }
                        if (genotype.right() == -1 || right > 0) continue;
                        right = genotype.right();
                    }
                    genotypes.set(n, Genotype.of(left, right));
                }
            } else {
                for (n = 0; n < numOfIndividuals; ++n) {
                    int allele1 = -1;
                    int allele2 = -1;
                    for (IGenotypes remapGenotype : remapGenotypes) {
                        genotype = remapGenotype.get(n);
                        if (genotype.getAN() == 1) {
                            if (allele2 == -1) {
                                allele2 = genotype.right();
                            } else if (allele1 == -1) {
                                if (allele2 != genotype.right()) {
                                    allele1 = genotype.right();
                                }
                            } else if (allele1 != genotype.right() && allele2 != genotype.right()) {
                                if (allele1 == 0) {
                                    allele1 = genotype.right();
                                } else if (allele2 == 0) {
                                    allele2 = genotype.right();
                                }
                            }
                        } else if (genotype.getAN() == 2) {
                            if (allele1 == -1 && allele2 == -1) {
                                allele1 = genotype.left();
                                allele2 = genotype.right();
                            } else if (allele1 == -1) {
                                if (allele2 == genotype.left() || allele2 == genotype.right() || allele2 == 0) {
                                    allele1 = genotype.left();
                                    allele2 = genotype.right();
                                } else if (genotype.left() == 0) {
                                    allele1 = genotype.right();
                                } else if (genotype.right() == 0) {
                                    allele1 = 0;
                                } else {
                                    allele1 = genotype.left();
                                    allele2 = genotype.right();
                                }
                            } else if (allele1 == 0 && allele2 == 0) {
                                allele1 = genotype.left();
                                allele2 = genotype.right();
                            } else if (allele1 == 0) {
                                if (allele2 == genotype.left()) {
                                    allele1 = genotype.right();
                                } else if (allele2 == genotype.right()) {
                                    allele1 = genotype.left();
                                } else if (genotype.left() == 0) {
                                    allele1 = genotype.right();
                                }
                            }
                        }
                        if (allele1 <= allele2) continue;
                        int temp = allele1;
                        allele1 = allele2;
                        allele2 = temp;
                    }
                    genotypes.set(n, Genotype.of(allele1, allele2));
                }
            }
            results.add(variant3);
        }
        return results;
    }

    public PositionType getPositionType() {
        return this.coordinate.getPositionType();
    }

    public Strand getStrand() {
        return this.coordinate.getStrand();
    }

    public Chromosome getChromosome() {
        return this.coordinate.getChromosome();
    }

    public int getPosition() {
        return this.coordinate.getPosition();
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Variant setCoordinate(Coordinate coordinate) {
        Variant returns = new Variant(coordinate);
        returns.alleles = this.alleles;
        returns.genotypes = this.genotypes;
        returns.property = this.property;
        return returns;
    }

    public Variant clearProperty() {
        if (this.property != null) {
            this.property.clear();
        }
        return this;
    }

    public Variant clearAlleles() {
        this.alleles.clear();
        return this;
    }

    public boolean prune() {
        boolean status;
        if (this.numOfAlleles() >= 3 && this.genotypes.size() > 0) {
            int[] ACs = this.genotypes.counter().getACs();
            int[] alleleIndexes = new int[ACs.length + 1];
            alleleIndexes[0] = -1;
            int index = 1;
            for (int i = 1; i < ACs.length; ++i) {
                alleleIndexes[i + 1] = ACs[i] > 0 ? index++ : -1;
            }
            if (index != this.numOfAlleles()) {
                this.genotypes = this.genotypes.map(alleleIndexes);
                LinkedSet<String> alleles = new LinkedSet<String>(index);
                ((AbstractCollection)alleles).add(this.alleleOfIndex(0));
                for (int i = 1; i < ACs.length; ++i) {
                    if (ACs[i] <= 0) continue;
                    ((AbstractCollection)alleles).add(this.alleleOfIndex(i));
                }
                if (((AbstractCollection)alleles).size() == 1) {
                    ((AbstractCollection)alleles).add(this.alleleOfIndex(1));
                }
                this.alleles = alleles;
                status = true;
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        if (this.isStandardAllele() && this.alleleOfIndex(0).length() > 1) {
            String ref = this.alleleOfIndex(0);
            int offset = 0;
            block2: for (int i = 0; i < ref.length() - 1; ++i) {
                for (int j = 1; j < this.numOfAlleles(); ++j) {
                    String alt = this.alleles.valueOf(j);
                    if (alt.length() <= i + 1 || alt.charAt(alt.length() - i - 1) != ref.charAt(ref.length() - i - 1)) break block2;
                }
                ++offset;
            }
            if (offset > 0) {
                LinkedSet<String> alleles = new LinkedSet<String>(this.numOfAlleles());
                for (String allele : this.alleles) {
                    ((AbstractCollection)alleles).add(allele.substring(0, allele.length() - offset));
                }
                this.alleles = alleles;
            }
        }
        return status;
    }

    public Variant setProperty(String key, Object value) {
        if (this.property == null) {
            if (value == null) {
                return this;
            }
            this.property = new DynamicIndexableMap<String, Object>(FIELDS);
        }
        if (value == null && !this.property.containsKey(key)) {
            return this;
        }
        this.property.put(key, value);
        return this;
    }

    public Variant setProperty(Map<String, Object> property) {
        this.property = property;
        return this;
    }

    public Variant setPropertyFrom(Map<String, Object> property) {
        if (property == null || property.size() == 0) {
            return this;
        }
        if (this.property == null) {
            this.property = new DynamicIndexableMap<String, Object>(FIELDS);
        }
        for (String key : property.keySet()) {
            Object value = property.get(key);
            if (value == null) continue;
            this.property.put(key, value);
        }
        return this;
    }

    public <T> T getProperty(String key) {
        if (this.property == null) {
            return null;
        }
        return (T)this.property.get(key);
    }

    public String getPropertyAsString(String key) {
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public int getPosition(PositionType positionType) {
        return this.coordinate.getPosition(positionType);
    }

    public IGenotypes getGenotypes() {
        return this.genotypes;
    }

    public Variant setGenotypes(IGenotypes genotypes) {
        this.genotypes = genotypes == null ? CacheGenotypes.EMPTY : genotypes;
        return this;
    }

    public boolean isStandardAllele() {
        if (this.alleles == null || this.alleles.size() == 0) {
            return false;
        }
        for (String allele : this.alleles) {
            if (Variant.isStandardAllele(allele)) continue;
            return false;
        }
        return true;
    }

    public Variant addAllele(String allele) {
        if (allele != null) {
            if (this.alleles == null) {
                this.alleles = new LinkedSet<String>(2);
            }
            this.alleles.add(Variant.isValidAllele(this.coordinate, allele));
        }
        return this;
    }

    public Variant addAlleles(String[] alleles) {
        if (alleles != null) {
            if (this.alleles == null) {
                this.alleles = new LinkedSet<String>(2);
            }
            for (String allele : alleles) {
                this.alleles.add(Variant.isValidAllele(this.coordinate, allele));
            }
        }
        return this;
    }

    public Variant addAlleles(Iterable<String> alleles) {
        if (alleles != null) {
            if (this.alleles == null) {
                this.alleles = new LinkedSet<String>(2);
            }
            for (String allele : alleles) {
                this.alleles.add(Variant.isValidAllele(this.coordinate, allele));
            }
        }
        return this;
    }

    public IndexableSet<String> getAlleles() {
        if (this.alleles == null) {
            return LinkedSet.EMPTY();
        }
        return this.alleles.asUnmodifiable();
    }

    public String alleleOfIndex(int index) {
        if (this.alleles == null) {
            return null;
        }
        return this.alleles.valueOf(index);
    }

    public int indexOfAllele(String allele) {
        if (this.alleles == null) {
            return -1;
        }
        return this.alleles.indexOf(allele);
    }

    public int numOfAlleles() {
        if (this.alleles == null) {
            return 0;
        }
        return this.alleles.size();
    }

    public String toString() {
        return this.coordinate + (this.alleles == null || this.alleles.size() == 0 ? "" : ", alleles=" + this.alleles) + (this.property == null || this.property.size() == 0 ? "" : ", property=" + this.property) + (this.genotypes == null || this.genotypes.size() == 0 ? "" : ", genotypes=" + this.genotypes);
    }

    @Override
    public int compareTo(Variant o) {
        return this.coordinate.compareTo(o.coordinate);
    }

    public List<Variant> biallelic(BiallelicMode mode) {
        List<Variant> variants = new List<Variant>();
        IGenotypes genotypes = this.genotypes;
        if (this.alleles.size() == 0) {
            variants.add(this);
        } else if (this.alleles.size() == 1) {
            if (Variant.isStandardAllele(this.alleleOfIndex(0)) && this.alleleOfIndex(0).length() > 1) {
                Variant variant = new Variant(this.coordinate).setPropertyFrom(this.property);
                variant.addAllele(this.alleleOfIndex(0).substring(0, 1));
                variant.setGenotypes(genotypes);
                variants.add(variant);
            } else {
                variants.add(this);
            }
        } else if (this.alleles.size() == 2) {
            String refAllele = this.alleleOfIndex(0);
            String altAllele = this.alleleOfIndex(1);
            if (refAllele.length() == 1 || altAllele.length() == 1 || !Variant.isStandardAllele(refAllele) || !Variant.isStandardAllele(altAllele)) {
                variants.add(this);
            } else {
                int offsetBase = 0;
                int l = Math.min(refAllele.length(), altAllele.length());
                for (int i = 1; i < l && refAllele.charAt(refAllele.length() - i) == altAllele.charAt(altAllele.length() - i); ++i) {
                    ++offsetBase;
                }
                if (offsetBase == 0) {
                    variants.add(this);
                } else {
                    Variant variant = new Variant(this.coordinate).setPropertyFrom(this.property);
                    variant.setGenotypes(genotypes);
                    for (String allele : this.alleles) {
                        variant.addAllele(allele.substring(0, allele.length() - offsetBase));
                    }
                }
            }
        } else {
            String refAllele = this.alleleOfIndex(0);
            if (refAllele.length() == 1 || !Variant.isStandardAllele(refAllele)) {
                for (int altAlleleIndex = 1; altAlleleIndex < this.alleles.size(); ++altAlleleIndex) {
                    Variant variant = new Variant(this.coordinate).setPropertyFrom(this.property);
                    variant.addAllele(refAllele);
                    variant.addAllele(this.alleleOfIndex(altAlleleIndex));
                    if (mode == null || mode == BiallelicMode.SET_TO_MISSING) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, -1));
                    } else if (mode == BiallelicMode.SET_TO_REF) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, 0));
                    } else if (mode == BiallelicMode.DISCARD_GENOTYPE) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, -1).map(genotype -> {
                            if (genotype.left() == -1 || genotype.right() == -1) {
                                return Genotype.MISSING;
                            }
                            return genotype;
                        }));
                    } else {
                        throw new GTBComponentException(mode.toString());
                    }
                    variants.add(variant);
                }
            } else {
                for (int altAlleleIndex = 1; altAlleleIndex < this.alleles.size(); ++altAlleleIndex) {
                    String altAllele = this.alleleOfIndex(altAlleleIndex);
                    Variant variant = new Variant(this.coordinate).setPropertyFrom(this.property);
                    if (altAllele.length() >= 2 && Variant.isStandardAllele(altAllele)) {
                        int offsetBase = 0;
                        int l = Math.min(refAllele.length(), altAllele.length());
                        for (int i = 1; i < l && refAllele.charAt(refAllele.length() - i) == altAllele.charAt(altAllele.length() - i); ++i) {
                            ++offsetBase;
                        }
                        if (offsetBase == 0) {
                            variant.addAllele(refAllele);
                            variant.addAllele(altAllele);
                        } else {
                            variant.addAllele(refAllele.substring(0, refAllele.length() - offsetBase));
                            variant.addAllele(altAllele.substring(0, altAllele.length() - offsetBase));
                        }
                    } else {
                        variant.addAllele(refAllele);
                        variant.addAllele(altAllele);
                    }
                    if (mode == null || mode == BiallelicMode.SET_TO_MISSING) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, -1));
                    } else if (mode == BiallelicMode.SET_TO_REF) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, 0));
                    } else if (mode == BiallelicMode.DISCARD_GENOTYPE) {
                        variant.setGenotypes(this.genotypes.toBiallelic(0, altAlleleIndex, -1).map(genotype -> {
                            if (genotype.left() == -1 || genotype.right() == -1) {
                                return Genotype.MISSING;
                            }
                            return genotype;
                        }));
                    } else {
                        throw new GTBComponentException(mode.toString());
                    }
                    variants.add(variant);
                }
            }
        }
        return variants;
    }

    public static enum BiallelicMode {
        SET_TO_MISSING,
        SET_TO_REF,
        DISCARD_GENOTYPE;

    }
}

