/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.commandParser.annotation.option.CustomOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.container.indexable.NamedSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class Chromosome
implements Comparable<Chromosome> {
    @CustomOption(names={"--set-chrom"}, arity={1, -1}, converter=ImportChromosomeConverter.class, repeated=true, bind=false)
    @OptionUsage(description={"Override the default chromosome labels. <main> is the primary chromosome name, followed by one or more <alias> values. This option clears existing labels and replaces them with the specified ones. Can be repeated for multiple chromosomes."}, format="--set-chrom <main> <alias> ...", group="Runtime Support Options")
    public static final String INDIVIDUAL_META_KEY = "$GTB_CHROMOSOME";
    public static final Chromosome UNKNOWN = new Chromosome("unknown");
    private static final NamedSet<Chromosome> CHROMOSOMES = new NamedSet();
    private final String name;
    private final Bytes bytecode;

    private Chromosome(String name) {
        if (name == null || name.length() == 0) {
            throw new CCFComponentException("Illegal chromosome: name is null");
        }
        this.name = name;
        this.bytecode = new Bytes(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        NamedSet<Chromosome> namedSet = CHROMOSOMES;
        synchronized (namedSet) {
            CHROMOSOMES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        NamedSet<Chromosome> namedSet = CHROMOSOMES;
        synchronized (namedSet) {
            CHROMOSOMES.clear();
            CHROMOSOMES.adds(new Chromosome("1"), "1", "chr1", "CM000663.1", "CM000663.2", "NC_000001.10", "NC_000001.11", "NC_060925.1").adds(new Chromosome("2"), "chr2", "CM000664.1", "CM000664.2", "NC_000002.11", "NC_000002.12", "NC_060926.1").adds(new Chromosome("3"), "chr3", "CM000665.1", "CM000665.2", "NC_000003.11", "NC_000003.12", "NC_060927.1").adds(new Chromosome("4"), "chr4", "CM000666.1", "CM000666.2", "NC_000004.11", "NC_000004.12", "NC_060928.1").adds(new Chromosome("5"), "chr5", "CM000667.1", "CM000667.2", "NC_000005.9", "NC_000005.10", "NC_060929.1").adds(new Chromosome("6"), "chr6", "CM000668.1", "CM000668.2", "NC_000006.11", "NC_000006.12", "NC_060930.1").adds(new Chromosome("7"), "chr7", "CM000669.1", "CM000669.2", "NC_000007.13", "NC_000007.14", "NC_060931.1").adds(new Chromosome("8"), "chr8", "CM000670.1", "CM000670.2", "NC_000008.10", "NC_000008.11", "NC_060932.1").adds(new Chromosome("9"), "chr9", "CM000671.1", "CM000671.2", "NC_000009.11", "NC_000009.12", "NC_060933.1").adds(new Chromosome("10"), "chr10", "CM000672.1", "CM000672.2", "NC_000010.10", "NC_000010.11", "NC_060934.1").adds(new Chromosome("11"), "chr11", "CM000673.1", "CM000673.2", "NC_000011.9", "NC_000011.10", "NC_060935.1").adds(new Chromosome("12"), "chr12", "CM000674.1", "CM000674.2", "NC_000012.11", "NC_000012.12", "NC_060936.1").adds(new Chromosome("13"), "chr13", "CM000675.1", "CM000675.2", "NC_000013.10", "NC_000013.11", "NC_060937.1").adds(new Chromosome("14"), "chr14", "CM000676.1", "CM000676.2", "NC_000014.8", "NC_000014.9", "NC_060938.1").adds(new Chromosome("15"), "chr15", "CM000677.1", "CM000677.2", "NC_000015.9", "NC_000015.10", "NC_060939.1").adds(new Chromosome("16"), "chr16", "CM000678.1", "CM000678.2", "NC_000016.9", "NC_000016.10", "NC_060940.1").adds(new Chromosome("17"), "chr17", "CM000679.1", "CM000679.2", "NC_000017.10", "NC_000017.11", "NC_060941.1").adds(new Chromosome("18"), "chr18", "CM000680.1", "CM000680.2", "NC_000018.9", "NC_000018.10", "NC_060942.1").adds(new Chromosome("19"), "chr19", "CM000681.1", "CM000681.2", "NC_000019.9", "NC_000019.10", "NC_060943.1").adds(new Chromosome("20"), "chr20", "CM000682.1", "CM000682.2", "NC_000020.10", "NC_000020.11", "NC_060944.1").adds(new Chromosome("21"), "chr21", "CM000683.1", "CM000683.2", "NC_000021.8", "NC_000021.9", "NC_060945.1").adds(new Chromosome("22"), "chr22", "CM000684.1", "CM000684.2", "NC_000022.10", "NC_000022.11", "NC_060946.1").adds(new Chromosome("X"), "chrX", "23", "chr23", "CM000685.1", "CM000685.2", "NC_000023.10", "NC_000023.11", "NC_060947.1").adds(new Chromosome("Y"), "chrY", "24", "chr24", "CM000686.1", "CM000686.2", "NC_000024.9", "NC_000024.10", "NC_060948.1").adds(new Chromosome("M"), "chrM", "25", "chr25", "MT", "chrMT", "NC_012920.1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chromosome get(String name) {
        if (name == null || name.length() == 0 || name.equalsIgnoreCase("unknown")) {
            return UNKNOWN;
        }
        int index = CHROMOSOMES.indexOf(name);
        if (index == -1) {
            NamedSet<Chromosome> namedSet = CHROMOSOMES;
            synchronized (namedSet) {
                index = CHROMOSOMES.indexOf(name);
                if (index == -1) {
                    CHROMOSOMES.add(new Chromosome(name), name);
                    index = CHROMOSOMES.indexOf(name);
                }
            }
        }
        return CHROMOSOMES.valueOf((Chromosome)index);
    }

    public static Chromosome get(int chromosomeIndex) {
        if (chromosomeIndex == -1) {
            return UNKNOWN;
        }
        return CHROMOSOMES.valueOf((Chromosome)chromosomeIndex);
    }

    public static int indexOf(Chromosome chromosome) {
        if (chromosome == null || chromosome == UNKNOWN) {
            return -1;
        }
        return CHROMOSOMES.indexOf(chromosome);
    }

    public static int indexOf(String chromosome) {
        return CHROMOSOMES.indexOf(chromosome);
    }

    public static Set<Chromosome> values() {
        return CHROMOSOMES;
    }

    public static CCFMetaItem save() {
        LinkedHashMap<String, Set<String>> chromosomes = new LinkedHashMap<String, Set<String>>();
        CCFMetaItem meta = new CCFMetaItem(INDIVIDUAL_META_KEY, FieldType.stringSetMap, chromosomes);
        for (Chromosome chromosome : Chromosome.values()) {
            chromosomes.put(chromosome.getName(), CHROMOSOMES.aliasesOf(chromosome));
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(CCFMetaItem meta) {
        NamedSet<Chromosome> namedSet = CHROMOSOMES;
        synchronized (namedSet) {
            CHROMOSOMES.clear();
            Map chromosomes = (Map)meta.getValue();
            for (String chromosome : chromosomes.keySet()) {
                Chromosome.get(chromosome).addAlias((Iterable)chromosomes.get(chromosome));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chromosome addAlias(String ... names) {
        NamedSet<Chromosome> namedSet = CHROMOSOMES;
        synchronized (namedSet) {
            CHROMOSOMES.adds(this, names);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chromosome addAlias(Iterable<String> names) {
        NamedSet<Chromosome> namedSet = CHROMOSOMES;
        synchronized (namedSet) {
            CHROMOSOMES.adds(this, names);
        }
        return this;
    }

    public int getIndex() {
        if (this == UNKNOWN) {
            return -1;
        }
        return CHROMOSOMES.indexOf(this);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o.getClass() != Chromosome.class) {
            return false;
        }
        return this.name.equals(((Chromosome)o).name);
    }

    public String toString() {
        return this.name;
    }

    public Bytes toBytes() {
        return this.bytecode;
    }

    @Override
    public int compareTo(Chromosome o) {
        return Integer.compare(CHROMOSOMES.indexOf(this), CHROMOSOMES.indexOf(o));
    }

    static {
        Chromosome.init();
    }

    private static enum ImportChromosomeConverter implements IConverter<Void>
    {
        INSTANCE;

        private final AtomicBoolean init = new AtomicBoolean(false);

        @Override
        public Void convert(String name, String ... values2) {
            if (!this.init.get()) {
                CHROMOSOMES.clear();
                this.init.set(true);
            }
            Chromosome.get(values2[0]).addAlias(values2);
            return null;
        }
    }
}

