/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate;

import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.PositionType;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;
import java.util.Objects;

public final class Coordinate
implements Comparable<Coordinate> {
    private static final PositionType positionType = PositionType.ONE_BASED;
    private static final Strand strand = Strand.FWD;
    final Chromosome chromosome;
    final int position;

    public Coordinate(String chromosome, int position) {
        this(Chromosome.get(chromosome), position, PositionType.ONE_BASED);
    }

    public Coordinate(Chromosome chromosome, int position) {
        this(chromosome, position, PositionType.ONE_BASED);
    }

    public Coordinate(Chromosome chromosome, int position, PositionType positionType) {
        this.chromosome = chromosome == null ? Chromosome.UNKNOWN : chromosome;
        int n = this.position = positionType == PositionType.ONE_BASED || positionType == null ? position : position + 1;
        if (positionType == null || positionType == PositionType.ONE_BASED) {
            if (position <= 0) {
                throw new GTBComponentException("Illegal position of variant: one-based position requests (i.e., position >= 1)");
            }
        } else if (position < 0) {
            throw new GTBComponentException("Illegal position of variant: zero-based position requests (i.e., position >= 0)");
        }
    }

    public Chromosome getChromosome() {
        return this.chromosome;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPosition(PositionType positionType) {
        if (positionType == null || positionType == PositionType.ONE_BASED) {
            return this.position;
        }
        return this.position - 1;
    }

    public PositionType getPositionType() {
        return positionType;
    }

    public Strand getStrand() {
        return strand;
    }

    @Override
    public int compareTo(Coordinate o) {
        int status = Integer.compare(Chromosome.indexOf(this.getChromosome()), Chromosome.indexOf(o.getChromosome()));
        if (status != 0) {
            return status;
        }
        return Integer.compare(this.getPosition(), o.getPosition());
    }

    public int hashCode() {
        return Objects.hash(this.getChromosome(), this.getPosition());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Objects.equals(this.getPosition(), that.getPosition()) && this.getChromosome() == that.getChromosome();
    }

    public String toString() {
        return this.chromosome + ":" + this.position;
    }

    public Coordinate offset(int length) {
        return new Coordinate(this.chromosome, this.getPosition() + length);
    }
}

