/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate;

import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.PositionType;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;

public class CoordinateInterval
implements Comparable<CoordinateInterval> {
    private static final Strand strand = Strand.FWD;
    private final Chromosome chromosome;
    private final Coordinate start;
    private final Coordinate end;

    public CoordinateInterval(Chromosome chromosome, IntInterval interval) {
        this(chromosome, interval.start() + 1, interval.end());
    }

    public CoordinateInterval(Chromosome chromosome, int start, int end) {
        if (start <= 0 || end <= 0) {
            throw new GTBComponentException("Illegal position of variant: one-based position requests (i.e., position >= 1)");
        }
        if (start > end) {
            throw new IllegalArgumentException("Illegal positional interval: length < 0");
        }
        this.start = new Coordinate(chromosome, start);
        this.end = new Coordinate(chromosome, end);
        this.chromosome = this.start.getChromosome();
    }

    public CoordinateInterval(Coordinate start, Coordinate end) {
        if (start.getChromosome() != end.getChromosome()) {
            throw new IllegalArgumentException("Illegal positional interval: inconsistent chromosome");
        }
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Illegal positional interval: length < 0");
        }
        this.chromosome = start.getChromosome();
        this.start = start;
        this.end = end;
    }

    public Chromosome getChromosome() {
        return this.chromosome;
    }

    public Interval<Integer> getPositionInterval(PositionType positionType) {
        if (positionType == null || positionType == PositionType.ZERO_BASED) {
            return new Interval<Integer>(this.start.position - 1, this.end.position);
        }
        return new Interval<Integer>(this.start.position, this.end.position);
    }

    public Coordinate getStartPosition() {
        return this.start;
    }

    public Coordinate getEndPosition() {
        return this.end;
    }

    public int length() {
        return this.end.position - this.start.position + 1;
    }

    public Strand getStrand() {
        return strand;
    }

    public boolean contains(Coordinate coordinate) {
        if (coordinate.getChromosome() != this.chromosome) {
            return false;
        }
        return coordinate.position >= this.start.position && coordinate.position <= this.end.position;
    }

    public boolean contains(int pos) {
        return pos >= this.start.position && pos <= this.end.position;
    }

    @Override
    public int compareTo(CoordinateInterval o) {
        int status = Integer.compare(Chromosome.indexOf(this.chromosome), Chromosome.indexOf(o.chromosome));
        if (status != 0) {
            return status;
        }
        status = Integer.compare(this.start.position, o.start.position);
        if (status == 0) {
            status = Integer.compare(this.end.position, o.end.position);
        }
        return status;
    }

    public String toString() {
        return this.chromosome + ":" + this.start.position + "-" + this.end.position;
    }
}

