/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate;

import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum RefGenomeVersion {
    hg18("hg18", "ncbi36"),
    hg19("hg19", "grch37"),
    hg38("hg38", "grch38"),
    hs1("hs1", "T2T");

    final Set<String> names;

    private RefGenomeVersion(String ... names) {
        this.names = new HashSet<String>(Arrays.asList(names));
    }

    public static RefGenomeVersion of(String genomeVersion) {
        if (genomeVersion == null) {
            return null;
        }
        for (RefGenomeVersion refGenomeVersion : RefGenomeVersion.values()) {
            if (!refGenomeVersion.names.contains(genomeVersion.toLowerCase())) continue;
            return refGenomeVersion;
        }
        return null;
    }

    public LiftOver to(RefGenomeVersion target) {
        if (this == hg18) {
            if (target == hg18) {
                return LiftOver.ITSELF;
            }
            if (target == hg19) {
                return LiftOver.hg18ToHg19;
            }
            if (target == hg38) {
                return LiftOver.hg18ToHg38;
            }
        } else if (this == hg19) {
            if (target == hg19) {
                return LiftOver.ITSELF;
            }
            if (target == hg38) {
                return LiftOver.hg19ToHg38;
            }
            if (target == hs1) {
                return LiftOver.hg19ToHs1;
            }
        } else if (this == hg38) {
            if (target == hg19) {
                return LiftOver.hg38ToHg19;
            }
            if (target == hg38) {
                return LiftOver.ITSELF;
            }
            if (target == hs1) {
                return LiftOver.hg38ToHs1;
            }
        } else if (this == hs1) {
            if (target == hg19) {
                return LiftOver.hs1ToHg19;
            }
            if (target == hg38) {
                return LiftOver.hs1ToHg38;
            }
            if (target == hs1) {
                return LiftOver.ITSELF;
            }
        }
        throw new IllegalArgumentException("UCSC liftover resource not found: form " + (Object)((Object)this) + " to " + (Object)((Object)target));
    }
}

