/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate.liftover;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.container.entry.TIntObjectEntry;
import edu.sysu.pmglab.container.entry.TObjectLongEntry;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalObject;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.CoordinateInterval;
import edu.sysu.pmglab.gtb.genome.coordinate.PositionType;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.Chain;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachedLiftOver
implements LiftOver {
    private final Map<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>> chainIndexes = new THashMap<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>>();
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final String website;
    private final LiveFile file;

    public CachedLiftOver(String website, LiveFile file) {
        this.website = website;
        this.file = file;
    }

    @Override
    public synchronized void init() {
        try {
            if (!this.init.get()) {
                if (this.file == null) {
                    String name = new File(new URL(this.website).getFile()).getName();
                    LiveFile path = Channel.get(name, name);
                    if (path == null) {
                        File tempFile = RuntimeProperty.createFile(name);
                        path = tempFile.exists() ? new LocalFile(tempFile) : Chain.download(LiveFile.of(this.website), tempFile);
                    }
                    this.chainIndexes.putAll(Chain.loadChainsFromFile(path));
                } else {
                    this.chainIndexes.putAll(Chain.loadChainsFromFile(this.file));
                }
                this.init.set(true);
            }
        }
        catch (IOException e) {
            throw new DatabaseException("Failed to load: " + this.website);
        }
    }

    @Override
    public Coordinate convert(Coordinate coordinate) {
        if (!this.init.get()) {
            this.init();
        }
        if (coordinate == null || !this.chainIndexes.containsKey(coordinate.getChromosome())) {
            return null;
        }
        List<IntIntervalObject<TIntObjectEntry<Chain>>> queryResults = this.chainIndexes.get(coordinate.getChromosome()).getIntervalContains(coordinate.getPosition(PositionType.ONE_BASED));
        if (queryResults.size() == 0) {
            return null;
        }
        List<TObjectLongEntry<Coordinate>> results = new List<TObjectLongEntry<Coordinate>>(queryResults.size());
        for (IntIntervalObject<TIntObjectEntry<Chain>> result : queryResults) {
            int targetStart = result.data().getKey();
            Chain chain = result.data().getValue();
            int resultPosition = targetStart + (coordinate.getPosition(PositionType.ONE_BASED) - result.start());
            if (chain.targetStrand == Strand.REV) {
                resultPosition = chain.targetSize - 1 - resultPosition;
            }
            results.add(new TObjectLongEntry<Coordinate>(new Coordinate(chain.targetName, resultPosition, PositionType.ZERO_BASED), chain.score));
        }
        results.sort((o1, o2) -> -Long.compare(o1.getValue(), o2.getValue()));
        return (Coordinate)((TObjectLongEntry)results.get(0)).getKey();
    }

    @Override
    public CoordinateInterval convert(CoordinateInterval coordinateInterval) {
        if (!this.init.get()) {
            this.init();
        }
        if (coordinateInterval == null || !this.chainIndexes.containsKey(coordinateInterval.getChromosome())) {
            return null;
        }
        List<IntIntervalObject<TIntObjectEntry<Chain>>> queryResults = this.chainIndexes.get(coordinateInterval.getChromosome()).getIntervalContains(coordinateInterval.getStartPosition().getPosition(PositionType.ONE_BASED), coordinateInterval.getEndPosition().getPosition(PositionType.ONE_BASED));
        if (queryResults.size() == 0) {
            Coordinate start = this.convert(coordinateInterval.getStartPosition());
            Coordinate end = this.convert(coordinateInterval.getEndPosition());
            if (start == null || end == null || !start.getChromosome().equals(end.getChromosome()) || Math.abs(start.getPosition() - end.getPosition()) + 1 != coordinateInterval.length()) {
                return null;
            }
            if (start.getPosition() < end.getPosition()) {
                return new CoordinateInterval(start, end);
            }
            return new CoordinateInterval(end, start);
        }
        List<TObjectLongEntry<CoordinateInterval>> results = new List<TObjectLongEntry<CoordinateInterval>>(queryResults.size());
        for (IntIntervalObject<TIntObjectEntry<Chain>> result : queryResults) {
            int targetStart = result.data().getKey();
            Chain chain = result.data().getValue();
            int resultStartPosition = targetStart + (coordinateInterval.getStartPosition().getPosition(PositionType.ONE_BASED) - result.start());
            if (chain.targetStrand == Strand.REV) {
                resultStartPosition = chain.targetSize - 1 - resultStartPosition;
            }
            int resultEndPosition = targetStart + (coordinateInterval.getEndPosition().getPosition(PositionType.ONE_BASED) - result.start());
            if (chain.targetStrand == Strand.REV) {
                resultEndPosition = chain.targetSize - 1 - resultEndPosition;
            }
            Coordinate startPosition = new Coordinate(chain.targetName, Math.min(resultStartPosition, resultEndPosition), PositionType.ZERO_BASED);
            Coordinate endPosition = new Coordinate(chain.targetName, Math.max(resultStartPosition, resultEndPosition), PositionType.ZERO_BASED);
            results.add(new TObjectLongEntry<CoordinateInterval>(new CoordinateInterval(startPosition, endPosition), chain.score));
        }
        results.sort((o1, o2) -> -Long.compare(o1.getValue(), o2.getValue()));
        return (CoordinateInterval)((TObjectLongEntry)results.get(0)).getKey();
    }
}

