/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate.liftover;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.entry.TIntObjectEntry;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.utils.Downloader;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;

class Chain {
    private static final byte[] MARKER = new byte[]{99, 104, 97, 105, 110};
    final long score;
    final String id;
    final Chromosome sourceName;
    final int sourceSize;
    final Strand sourceStrand;
    final int sourceStart;
    final int sourceEnd;
    final Chromosome targetName;
    final int targetSize;
    final Strand targetStrand;
    final int targetStart;
    final int targetEnd;
    final List<int[]> blocks;

    public Chain(long score, String id, Chromosome sourceName, int sourceSize, Strand sourceStrand, int sourceStart, int sourceEnd, Chromosome targetName, int targetSize, Strand targetStrand, int targetStart, int targetEnd) {
        this.score = score;
        this.id = id;
        this.sourceName = sourceName;
        this.sourceSize = sourceSize;
        this.sourceStrand = sourceStrand;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.targetName = targetName;
        this.targetSize = targetSize;
        this.targetStrand = targetStrand;
        this.targetStart = targetStart;
        this.targetEnd = targetEnd;
        if (this.sourceStrand.isReverse()) {
            throw new UnsupportedOperationException("Source strand in an .over.chain file must be +");
        }
        if (this.targetStrand == null) {
            throw new UnsupportedOperationException("Target strand must be - or +");
        }
        this.blocks = new List(16);
    }

    static LocalFile download(LiveFile remoteFile, File file) throws IOException {
        if (file == null || !file.exists()) {
            return new Downloader(remoteFile, file).resume(true).silent(true).setThreads(1).download();
        }
        return new LocalFile(file);
    }

    static Map<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>> loadChainsFromFile(LiveFile file) throws IOException {
        Bytes originLine;
        ReaderStream reader = file.openAsText();
        List<Chain> chains = new List<Chain>(16);
        while ((originLine = reader.readline()) != null) {
            int size;
            Bytes line = originLine;
            if (line.length() == 0 || line.fastByteAt(0) == 35) continue;
            List<Bytes> values2 = new List<Bytes>();
            if (!line.startsWith(MARKER)) continue;
            values2.clear();
            line.splitTo((byte)32, values2);
            Chain chain = new Chain(values2.get(1).toLong(), values2.size() >= 13 ? values2.get(12).toString() : null, Chromosome.get(values2.get(2).toString()), values2.get(3).toInt(), Strand.get(values2.get(4).toString()), values2.get(5).toInt(), values2.get(6).toInt(), Chromosome.get(values2.get(7).toString()), values2.get(8).toInt(), Strand.get(values2.get(9).toString()), values2.get(10).toInt(), values2.get(11).toInt());
            int sfrom = chain.sourceStart;
            int tfrom = chain.targetStart;
            while (true) {
                if ((originLine = reader.readline()) == null) {
                    throw new UnsupportedOperationException("Expecting three number on the inner line of alignments block");
                }
                values2.clear();
                originLine.splitTo((byte)9, values2);
                if (values2.size() != 3) break;
                size = values2.get(0).toInt();
                int sgap = values2.get(1).toInt();
                int tgap = values2.get(2).toInt();
                chain.addBlock(new int[]{sfrom, sfrom + size, tfrom});
                sfrom += size + sgap;
                tfrom += size + tgap;
            }
            if (values2.size() == 1) {
                size = values2.get(0).toInt();
                chain.addBlock(new int[]{sfrom, sfrom + size, tfrom});
                if (sfrom + size != chain.sourceEnd || tfrom + size != chain.targetEnd) {
                    throw new UnsupportedOperationException("alignment blocks do not match specified block sizes");
                }
                chains.add(chain);
                continue;
            }
            throw new UnsupportedOperationException("Expecting three number on the inner line or one number on the last line of alignments block");
        }
        reader.close();
        return Chain.loadChains(chains);
    }

    static Map<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>> loadChains(List<Chain> chains) {
        if (chains == null || chains.size() == 0) {
            return new THashMap<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>>(0);
        }
        THashMap chainIndexBuilder = new THashMap();
        THashMap<Chromosome, Integer> sourceSizes = new THashMap<Chromosome, Integer>();
        THashMap<Chromosome, Integer> targetSizes = new THashMap<Chromosome, Integer>();
        for (Chain chain : chains) {
            if (chain.sourceName == Chromosome.UNKNOWN || chain.targetName == Chromosome.UNKNOWN) continue;
            sourceSizes.putIfAbsent(chain.sourceName, chain.sourceSize);
            if ((Integer)sourceSizes.get(chain.sourceName) != chain.sourceSize) {
                throw new UnsupportedOperationException("chains have inconsistent specification of source chromosome size for " + chain.sourceName.getName() + " (" + sourceSizes.get(chain.sourceName) + " vs " + chain.sourceSize + ")");
            }
            targetSizes.putIfAbsent(chain.targetName, chain.targetSize);
            if ((Integer)targetSizes.get(chain.targetName) != chain.targetSize) {
                throw new UnsupportedOperationException("chains have inconsistent specification of target chromosome size for " + chain.targetName.getName() + " (" + targetSizes.get(chain.targetName) + " vs " + chain.targetSize + ")");
            }
            if (!chainIndexBuilder.containsKey(chain.sourceName)) {
                chainIndexBuilder.put(chain.sourceName, new IntIntervalTree.Builder());
            }
            IntIntervalTree.Builder tree = (IntIntervalTree.Builder)chainIndexBuilder.get(chain.sourceName);
            for (int[] block : chain.blocks) {
                tree.add(block[0] + 1, block[1], new TIntObjectEntry<Chain>(block[2], chain));
            }
        }
        THashMap<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>> chainIndex = new THashMap<Chromosome, IntIntervalTree<TIntObjectEntry<Chain>>>();
        for (Chromosome chromosome : chainIndexBuilder.keySet()) {
            chainIndex.put(chromosome, ((IntIntervalTree.Builder)chainIndexBuilder.get(chromosome)).build());
        }
        return chainIndex;
    }

    public Chain addBlock(int[] block) {
        if (block == null || block.length != 3) {
            throw new UnsupportedOperationException("alignments block requires 3 fields");
        }
        this.blocks.add(block);
        return this;
    }
}

