/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.coordinate.liftover;

import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.CoordinateInterval;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.CachedLiftOver;
import java.io.IOException;

public interface LiftOver {
    public static final LiftOver ITSELF = new LiftOver(){

        @Override
        public Variant convert(Variant variant) {
            return variant;
        }

        @Override
        public Coordinate convert(Coordinate coordinate) {
            return coordinate;
        }

        @Override
        public CoordinateInterval convert(CoordinateInterval coordinateInterval) {
            return coordinateInterval;
        }
    };
    public static final LiftOver NULL = new LiftOver(){

        @Override
        public Variant convert(Variant variant) {
            return null;
        }

        @Override
        public Coordinate convert(Coordinate coordinate) {
            return null;
        }

        @Override
        public CoordinateInterval convert(CoordinateInterval coordinateInterval) {
            return null;
        }
    };
    public static final LiftOver hg18ToHg19 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg18/liftOver/hg18ToHg19.over.chain.gz", null);
    public static final LiftOver hg18ToHg38 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg18/liftOver/hg18ToHg38.over.chain.gz", null);
    public static final LiftOver hg19ToHg18 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg19/liftOver/hg19ToHg18.over.chain.gz", null);
    public static final LiftOver hg19ToHg38 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg19/liftOver/hg19ToHg38.over.chain.gz", null);
    public static final LiftOver hg19ToHs1 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg19/liftOver/hg19ToHs1.over.chain.gz", null);
    public static final LiftOver hg38ToHg19 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg38/liftOver/hg38ToHg19.over.chain.gz", null);
    public static final LiftOver hg38ToHs1 = new CachedLiftOver("http://hgdownload.cse.ucsc.edu/goldenPath/hg38/liftOver/hg38ToHs1.over.chain.gz", null);
    public static final LiftOver hs1ToHg19 = new CachedLiftOver("https://hgdownload.soe.ucsc.edu/goldenPath/hs1/liftOver/hs1ToHg19.over.chain.gz", null);
    public static final LiftOver hs1ToHg38 = new CachedLiftOver("https://hgdownload.soe.ucsc.edu/goldenPath/hs1/liftOver/hs1ToHg38.over.chain.gz", null);

    default public Variant convert(Variant variant) {
        Coordinate newCoordinate = this.convert(variant.getCoordinate());
        if (newCoordinate == null) {
            return null;
        }
        if (newCoordinate.equals(variant.getCoordinate())) {
            return variant;
        }
        return variant.setCoordinate(newCoordinate);
    }

    default public void init() throws IOException {
    }

    public Coordinate convert(Coordinate var1);

    public CoordinateInterval convert(CoordinateInterval var1);
}

