/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.container.bits.LongBits;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypeCodingException;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ArrayCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.IBitCounter;
import edu.sysu.pmglab.utils.Assert;
import java.util.function.Function;

public class BitwiseGenotypes {
    public static final Function<Genotype, Genotype> NULL = genotype -> genotype;
    public static final Function<Genotype, Genotype> BIALLELIC = genotype -> {
        if (genotype.getAN() != 2) {
            return Genotype.MISSING;
        }
        int left = genotype.left();
        int right = genotype.right();
        if (left <= 1 && right <= 1) {
            return genotype;
        }
        if (left >= 2) {
            left = 1;
        }
        if (right >= 2) {
            right = 1;
        }
        return Genotype.of(left, right);
    };
    public static final Function<Genotype, Genotype> DISCARD_HALF_CALL = genotype -> {
        if (genotype.getAN() != 2) {
            return Genotype.MISSING;
        }
        return genotype;
    };
    private final IGenotypes genotypes;
    private final LongBits[] lefts;
    private final LongBits[] rights;
    private final LongBits[] valids;
    private final ICounter counter;
    private final Function<Genotype, Genotype> mapper;

    public BitwiseGenotypes(IGenotypes genotypes, int alleleNum, Function<Genotype, Genotype> mapping) {
        if (mapping == null) {
            mapping = NULL;
        }
        Assert.that(alleleNum >= 0);
        if (alleleNum > 4095) {
            throw new GenotypeCodingException("Invalid genotype: allele number exceed the maximum SWI coding limit of 4095 (<= 4095)");
        }
        this.genotypes = genotypes;
        this.lefts = new LongBits[alleleNum];
        this.rights = new LongBits[alleleNum];
        this.valids = new LongBits[]{new LongBits(genotypes.size()), new LongBits(genotypes.size())};
        IntArray GTs = new IntArray((alleleNum + 1) * (alleleNum + 1));
        for (int i = 0; i < alleleNum; ++i) {
            this.lefts[i] = new LongBits(genotypes.size());
            this.rights[i] = new LongBits(genotypes.size());
        }
        int gtIndex = 0;
        this.mapper = mapping;
        for (Genotype genotype : genotypes) {
            if ((genotype = this.mapper.apply(genotype)) == null || genotype.getAN() == 0) {
                GTs.offset(0, 1);
            } else {
                if (genotype.left() >= alleleNum || genotype.right() >= alleleNum) {
                    genotype = Genotype.MISSING;
                }
                GTs.offset(genotype.intcode(), 1);
                if (genotype.left() != -1) {
                    this.valids[0].set(gtIndex);
                    int leftIndex = genotype.left();
                    this.lefts[leftIndex].set(gtIndex);
                }
                if (genotype.right() != -1) {
                    this.valids[1].set(gtIndex);
                    int rightIndex = genotype.right();
                    this.rights[rightIndex].set(gtIndex);
                }
            }
            ++gtIndex;
        }
        this.counter = new ArrayCounter(GTs, genotypes.size());
    }

    public BitwiseGenotypes(int size, int alleleNum, Function<Genotype, Genotype> mapping) {
        if (mapping == null) {
            mapping = NULL;
        }
        Assert.that(alleleNum >= 0);
        if (alleleNum >= 4095) {
            throw new GenotypeCodingException("Invalid genotype: allele number exceed the maximum SWI coding limit of 4095 (<= 4095)");
        }
        this.genotypes = new ConstantGenotypes(size);
        this.lefts = new LongBits[alleleNum];
        this.rights = new LongBits[alleleNum];
        this.valids = new LongBits[]{new LongBits(size), new LongBits(size)};
        for (int i = 0; i < alleleNum; ++i) {
            this.lefts[i] = new LongBits(size);
            this.rights[i] = new LongBits(size);
        }
        this.mapper = mapping;
        this.counter = this.genotypes.counter();
    }

    private BitwiseGenotypes(IGenotypes genotypes, LongBits[] lefts, LongBits[] rights, LongBits[] valids, ICounter counter, Function<Genotype, Genotype> mapper) {
        this.genotypes = genotypes;
        this.lefts = lefts;
        this.rights = rights;
        this.valids = valids;
        this.counter = counter;
        this.mapper = mapper;
    }

    public BitwiseGenotypes reload(IGenotypes genotypes) {
        for (LongBits valid : this.valids) {
            valid.clear();
        }
        for (LongBits left : this.lefts) {
            left.clear();
        }
        for (LongBits right : this.rights) {
            right.clear();
        }
        int gtIndex = 0;
        IntArray GTs = new IntArray((this.lefts.length + 1) * (this.rights.length + 1));
        for (Genotype genotype : genotypes) {
            if ((genotype = this.mapper.apply(genotype)) == null || genotype.getAN() == 0) {
                GTs.offset(0, 1);
            } else {
                if (genotype.left() >= this.lefts.length || genotype.right() >= this.rights.length) {
                    genotype = Genotype.MISSING;
                }
                GTs.offset(genotype.intcode(), 1);
                if (genotype.left() != -1) {
                    this.valids[0].set(gtIndex);
                    int leftIndex = genotype.left();
                    this.lefts[leftIndex].set(gtIndex);
                }
                if (genotype.right() != -1) {
                    this.valids[1].set(gtIndex);
                    int rightIndex = genotype.right();
                    this.rights[rightIndex].set(gtIndex);
                }
            }
            ++gtIndex;
        }
        return new BitwiseGenotypes(genotypes, this.lefts, this.rights, this.valids, new ArrayCounter(GTs, genotypes.size()), this.mapper);
    }

    public IGenotypes source() {
        return this.genotypes;
    }

    public LongBits getBits(int ploidyIndex, int alleleIndex) {
        if (ploidyIndex == 0) {
            if (alleleIndex == -1) {
                return this.valids[0];
            }
            if (alleleIndex < this.lefts.length) {
                return this.lefts[alleleIndex];
            }
            return null;
        }
        if (alleleIndex == -1) {
            return this.valids[1];
        }
        if (alleleIndex < this.rights.length) {
            return this.rights[alleleIndex];
        }
        return null;
    }

    public Genotype get(int index) {
        Genotype genotype = this.genotypes.get(index);
        if (genotype == null) {
            genotype = Genotype.MISSING;
        }
        if ((genotype = this.mapper.apply(genotype)) == null) {
            genotype = Genotype.MISSING;
        }
        if (genotype.left() >= this.lefts.length || genotype.right() >= this.rights.length) {
            genotype = Genotype.MISSING;
        }
        return genotype;
    }

    public int numOfAllele() {
        return this.lefts.length;
    }

    public int size() {
        return this.genotypes.size();
    }

    public int count(IBitCounter counter) {
        return counter.count(this.valids, this.lefts, this.rights);
    }

    public int getAC() {
        return this.counter.getAC();
    }

    public int getAN() {
        return this.counter.getAN();
    }

    public float getAF() {
        return this.counter.getAF();
    }

    public int getAC(int alleleIndex) {
        return this.counter.getAC(alleleIndex);
    }

    public int[] getACs() {
        return this.counter.getACs();
    }

    public int numOfAlleles() {
        return this.lefts.length;
    }

    public Genotype argmax() {
        return this.counter.argmax();
    }

    public int count(IFilter<Genotype> filter) {
        return this.counter.count(filter);
    }

    public int count(Genotype genotype) {
        return this.counter.count(genotype);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("VL:" + this.valids[0]);
        builder.append("\nVR:" + this.valids[1]);
        for (i = 0; i < this.lefts.length; ++i) {
            builder.append("\nL" + i + ": " + this.lefts[i]);
        }
        for (i = 0; i < this.rights.length; ++i) {
            builder.append("\nR" + i + ": " + this.rights[i]);
        }
        return builder.toString();
    }
}

