/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypeCodingException;

public final class Genotype {
    public static final int MIN_ALLELE_INDEX = -1;
    public static final int MAX_ALLELE_INDEX = 4094;
    public static final int MAX_ALLELE_NUM = 4095;
    public static final int MAX_SWI_CODE = 0xFFFFFF;
    public static final Genotype MISSING = new Genotype(-1, -1);
    static final Bytes[][] PHASED_GENOTYPE_ASCII = new Bytes[4096][];
    static final Bytes[][] UNPHASED_GENOTYPE_ASCII = new Bytes[4096][];
    static final Genotype[] denseG1 = new Genotype[256];
    static final Genotype[][] denseG2 = new Genotype[16][16];
    static final Genotype[][] sparseG1 = new Genotype[4096][];
    static final Genotype[][] sparseG2 = new Genotype[4096][];
    private final int left;
    private final int right;
    private final int AC;
    private final int AN;
    private final byte bytecode;
    private final short shortcode;
    private final int intcode;

    private Genotype(int left, int right) {
        this.left = left;
        this.right = right;
        this.AC = (this.left > 0 ? 1 : 0) + (this.right > 0 ? 1 : 0);
        this.AN = (this.left >= 0 ? 1 : 0) + (this.right >= 0 ? 1 : 0);
        this.intcode = Genotype.encode(left, right);
        this.bytecode = (byte)(this.intcode <= 255 ? this.intcode : 0);
        this.shortcode = (short)(this.intcode <= 65535 ? this.intcode : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Genotype of(int left, int right) {
        Genotype genotype;
        Genotype.checkAlleleIndex(left, right, true);
        if (left <= 14 && right <= 14) {
            return denseG2[left + 1][right + 1];
        }
        Genotype[] lefts = sparseG2[left + 1];
        if (lefts == null) {
            Genotype genotype2 = MISSING;
            synchronized (genotype2) {
                lefts = sparseG2[left + 1];
                if (lefts == null) {
                    Genotype[] genotypeArray = new Genotype[4096];
                    Genotype.sparseG2[left + 1] = genotypeArray;
                    lefts = genotypeArray;
                }
            }
        }
        if ((genotype = lefts[right + 1]) == null) {
            Genotype genotype3 = MISSING;
            synchronized (genotype3) {
                genotype = lefts[right + 1];
                if (genotype == null) {
                    lefts[right + 1] = new Genotype(left, right);
                    genotype = lefts[right + 1];
                    int bucketIndex = genotype.intcode() >> 12;
                    Genotype[] values2 = sparseG1[bucketIndex];
                    if (values2 == null) {
                        Genotype.sparseG1[bucketIndex] = new Genotype[4096];
                        values2 = Genotype.sparseG1[bucketIndex];
                    }
                    values2[genotype.intcode() & 0xFFF] = genotype;
                }
            }
        }
        return genotype;
    }

    public static Genotype of(int left, int right, boolean phased) {
        if (!phased && left > right) {
            return Genotype.of(right, left);
        }
        return Genotype.of(left, right);
    }

    public static Genotype of(byte code) {
        return denseG1[code & 0xFF];
    }

    public static Genotype of(byte code, boolean phased) {
        if (phased) {
            return denseG1[code & 0xFF];
        }
        return denseG1[code & 0xFF].toUnPhased();
    }

    public static Genotype of(short code) {
        return Genotype.of(code, true);
    }

    public static Genotype of(short shortcode, boolean phased) {
        int code = shortcode & 0xFFFF;
        if (code <= 255) {
            if (phased) {
                return denseG1[code];
            }
            return denseG1[code].toUnPhased();
        }
        return Genotype.of0(code, phased);
    }

    public static Genotype of(int code) {
        return Genotype.of(code, true);
    }

    public static Genotype of(int code, boolean phased) {
        Genotype.checkSWI(code, true);
        if (code <= 255) {
            if (phased) {
                return denseG1[code];
            }
            return denseG1[code].toUnPhased();
        }
        return Genotype.of0(code, phased);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Genotype of0(int code, boolean phased) {
        int bucketIndex = code >> 12;
        int valueIndex = code & 0xFFF;
        Genotype[] values2 = sparseG1[bucketIndex];
        if (values2 == null || values2[valueIndex] == null) {
            Genotype genotype = MISSING;
            synchronized (genotype) {
                if (values2 == null || values2[valueIndex] == null) {
                    int maxOfAorB = (int)(Math.sqrt(code) - 1.0);
                    int m2 = (maxOfAorB + 1) * (maxOfAorB + 1);
                    int middle = m2 + maxOfAorB + 1;
                    if (middle == code) {
                        return Genotype.of(maxOfAorB, maxOfAorB);
                    }
                    if (middle > code) {
                        return Genotype.of(maxOfAorB - (middle - code), maxOfAorB);
                    }
                    if (phased) {
                        return Genotype.of(maxOfAorB, maxOfAorB - (code - middle));
                    }
                    return Genotype.of(maxOfAorB - (code - middle), maxOfAorB);
                }
                values2 = sparseG1[bucketIndex];
            }
        }
        if (phased) {
            return values2[valueIndex];
        }
        return values2[valueIndex].toUnPhased();
    }

    private static int encode(int left, int right) {
        Genotype.checkAlleleIndex(left, right, true);
        if (left >= right) {
            return (left + 2) * (left + 2) - (right + 2);
        }
        return (right + 1) * (right + 1) + (left + 1);
    }

    public static boolean checkAlleleIndex(int index, boolean throwException) {
        if (index < -1) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: index of allele must be >= -1, where -1 represents a missing genotype");
            }
            return false;
        }
        if (index >= 4095) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: index of allele exceed the maximum SWI coding limit of 4094 (<= 4094)");
            }
            return false;
        }
        return true;
    }

    public static boolean checkAlleleIndex(int left, int right, boolean throwException) {
        if (left < -1 || right < -1) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: index of allele must be >= -1, where -1 represents a missing genotype");
            }
            return false;
        }
        if (left >= 4095 || right >= 4095) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: index of allele exceed the maximum SWI coding limit of 4094 (<= 4094)");
            }
            return false;
        }
        return true;
    }

    public static boolean checkSWI(int code, boolean throwException) {
        if (code < 0) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: SWI of genotype must be >= 0, where 0 represents a missing genotype ./.");
            }
            return false;
        }
        if (code > 0xFFFFFF) {
            if (throwException) {
                throw new GenotypeCodingException("Invalid genotype: SWI exceed the maximum SWI coding limit of 16777215 (<= 16777215)");
            }
            return false;
        }
        return true;
    }

    public int getAC() {
        return this.AC;
    }

    public int getAC(int alleleIndex) {
        int count = 0;
        if (alleleIndex == this.left) {
            ++count;
        }
        if (alleleIndex == this.right) {
            ++count;
        }
        return count;
    }

    public int getAN() {
        return this.AN;
    }

    public int left() {
        return this.left;
    }

    public int right() {
        return this.right;
    }

    public boolean isHomozygous() {
        return this.left == this.right && this.getAN() == 2;
    }

    public boolean isHeterozygous() {
        return this.left != this.right && this.getAN() == 2;
    }

    public Genotype toUnPhased() {
        return this.left > this.right ? Genotype.of(this.right, this.left) : this;
    }

    public Genotype reverse() {
        return Genotype.of(this.right, this.left);
    }

    public byte bytecode() {
        return this.bytecode;
    }

    public short shortcode() {
        return this.shortcode;
    }

    public int intcode() {
        return this.intcode;
    }

    public int hashCode() {
        return this.intcode;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return this.toASCII(true).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bytes toASCII(boolean phased) {
        Bytes genotype;
        if (phased) {
            Bytes genotype2;
            Bytes[] lefts = PHASED_GENOTYPE_ASCII[this.left + 1];
            if (lefts == null) {
                Genotype genotype3 = MISSING;
                synchronized (genotype3) {
                    lefts = PHASED_GENOTYPE_ASCII[this.left + 1];
                    if (lefts == null) {
                        Bytes[] bytesArray = new Bytes[4096];
                        Genotype.PHASED_GENOTYPE_ASCII[this.left + 1] = bytesArray;
                        lefts = bytesArray;
                    }
                }
            }
            if ((genotype2 = lefts[this.right + 1]) == null) {
                Genotype genotype4 = MISSING;
                synchronized (genotype4) {
                    genotype2 = lefts[this.right + 1];
                    if (genotype2 == null) {
                        if (this.left == -1 && this.right == -1) {
                            Bytes bytes = new Bytes(".|.");
                            lefts[this.right + 1] = bytes;
                            genotype2 = bytes;
                        } else if (this.left == -1) {
                            Bytes bytes = new Bytes(".|" + this.right);
                            lefts[this.right + 1] = bytes;
                            genotype2 = bytes;
                        } else if (this.right == -1) {
                            Bytes bytes = new Bytes(this.left + "|.");
                            lefts[this.right + 1] = bytes;
                            genotype2 = bytes;
                        } else {
                            Bytes bytes = new Bytes(this.left + "|" + this.right);
                            lefts[this.right + 1] = bytes;
                            genotype2 = bytes;
                        }
                    }
                }
            }
            return genotype2;
        }
        Genotype g = this.toUnPhased();
        int left = g.left;
        int right = g.right;
        Bytes[] lefts = UNPHASED_GENOTYPE_ASCII[left + 1];
        if (lefts == null) {
            Genotype genotype5 = MISSING;
            synchronized (genotype5) {
                lefts = UNPHASED_GENOTYPE_ASCII[left + 1];
                if (lefts == null) {
                    Bytes[] bytesArray = new Bytes[4096];
                    Genotype.UNPHASED_GENOTYPE_ASCII[left + 1] = bytesArray;
                    lefts = bytesArray;
                }
            }
        }
        if ((genotype = lefts[right + 1]) == null) {
            Genotype genotype6 = MISSING;
            synchronized (genotype6) {
                genotype = lefts[right + 1];
                if (genotype == null) {
                    if (left == -1 && right == -1) {
                        Bytes bytes = new Bytes("./.");
                        lefts[right + 1] = bytes;
                        genotype = bytes;
                    } else if (left == -1) {
                        Bytes bytes = new Bytes("./" + right);
                        lefts[right + 1] = bytes;
                        genotype = bytes;
                    } else if (right == -1) {
                        Bytes bytes = new Bytes("./" + left);
                        lefts[right + 1] = bytes;
                        genotype = bytes;
                    } else {
                        Bytes bytes = new Bytes(left + "/" + right);
                        lefts[right + 1] = bytes;
                        genotype = bytes;
                    }
                }
            }
        }
        return genotype;
    }

    public String toString(boolean phased) {
        return this.toASCII(phased).toString();
    }

    public Genotype map(boolean phased, int refAlleleIndex, int altAlleleIndex, int otherwise) {
        int left = this.left == refAlleleIndex ? 0 : (this.left == altAlleleIndex ? 1 : otherwise);
        int right = this.right == refAlleleIndex ? 0 : (this.right == altAlleleIndex ? 1 : otherwise);
        if (left == -1 && right == -1) {
            return MISSING;
        }
        if (phased || left <= right) {
            return Genotype.of(left, right);
        }
        return Genotype.of(right, left);
    }

    public Genotype map(boolean phased, int[] alleleIndexes) {
        int left = this.left + 1;
        left = left < alleleIndexes.length ? alleleIndexes[left] : -1;
        int right = this.right + 1;
        right = right < alleleIndexes.length ? alleleIndexes[right] : -1;
        if (left == -1 && right == -1) {
            return MISSING;
        }
        if (phased || left <= right) {
            return Genotype.of(left, right);
        }
        return Genotype.of(right, left);
    }

    static {
        for (int i = -1; i <= 14; ++i) {
            for (int j = -1; j <= 14; ++j) {
                Genotype genotype = MISSING;
                if (i != -1 || j != -1) {
                    genotype = new Genotype(i, j);
                }
                Genotype.denseG1[genotype.intcode()] = genotype;
                Genotype.denseG2[i + 1][j + 1] = genotype;
            }
        }
    }
}

