/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.container.bits.LongBits;
import edu.sysu.pmglab.container.iterator.IndexIterator;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.gtb.genome.genotype.BitwiseGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.Genotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LargeGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LiteGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.SparseGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import java.util.Iterator;
import java.util.function.Function;

public abstract class IGenotypes
implements Iterable<Genotype> {
    private static final float SPARSE_THRESHOLD = 0.95f;

    public static IGenotypes load(Bytes codec) {
        return CacheGenotypes.load(codec);
    }

    public boolean isModifiable() {
        return false;
    }

    public abstract boolean isAssignableFromModifiableContainer();

    public abstract boolean isPhased();

    public final boolean isSparse() {
        int size = this.size();
        if (size >= 20) {
            ICounter counter = this.counter();
            return counter.count(counter.argmax()) >= (int)(0.95f * (float)this.size());
        }
        return false;
    }

    public final IGenotypes clone() {
        ICounter counter;
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (!this.isAssignableFromModifiableContainer()) {
            return this;
        }
        IGenotypes genotypes = this.isSparse() ? new SparseGenotypes(this.size(), this.isPhased(), this.counter().argmax()) : ((counter = this.counter()).maxAlleleIndex() <= 14 ? new LiteGenotypes(this.size(), this.isPhased()) : (counter.maxAlleleIndex() <= 254 ? new Genotypes(this.size(), this.isPhased()) : new LargeGenotypes(this.size(), this.isPhased())));
        int l = genotypes.size();
        for (int i = 0; i < l; ++i) {
            genotypes.set(i, this.get(i));
        }
        return genotypes;
    }

    public final String toString() {
        ByteStream container = new ByteStream();
        if (this.isPhased()) {
            for (Genotype genotype : this) {
                container.write(genotype.toASCII(true));
                container.write(32);
            }
        } else {
            for (Genotype genotype : this) {
                container.write(genotype.toASCII(false));
                container.write(32);
            }
        }
        if (container.length() > 0) {
            container.wSeek(container.wTell() - 1);
        }
        return container.toBytes().toString();
    }

    public abstract int size();

    public abstract Genotype get(int var1);

    public abstract ICounter counter();

    public IGenotypes set(int index, int genotype) {
        throw new UnsupportedOperationException();
    }

    public IGenotypes set(int index, Genotype genotype) {
        throw new UnsupportedOperationException();
    }

    public final int[][] getGenotypeCodes() {
        int[][] returns = new int[2][this.size()];
        int count = this.size() - this.counter().count(Genotype.of(0, 0));
        if (count > 0) {
            for (int i = 0; i < this.size(); ++i) {
                Genotype genotype = this.get(i);
                if (genotype.intcode() == 2) continue;
                returns[0][i] = genotype.left();
                returns[1][i] = genotype.right();
                if (--count == 0) break;
            }
        }
        return returns;
    }

    public final BitwiseGenotypes toBitGV() {
        return new BitwiseGenotypes(this, this.counter().maxAlleleIndex() + 1, BitwiseGenotypes.NULL);
    }

    public final IGenotypes subGenotypes(final IntList subLists) {
        if (subLists == null) {
            return this;
        }
        if (subLists.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (this.size() == 0) {
            return new ConstantGenotypes(subLists.size(), this.isPhased(), Genotype.MISSING);
        }
        return new IGenotypes(){
            ICounter counter;

            @Override
            public boolean isAssignableFromModifiableContainer() {
                return IGenotypes.this.isAssignableFromModifiableContainer();
            }

            @Override
            public boolean isPhased() {
                return IGenotypes.this.isPhased();
            }

            @Override
            public int size() {
                return subLists.size();
            }

            @Override
            public Genotype get(int index) {
                if ((index = subLists.get(index)) < 0 || index >= IGenotypes.this.size()) {
                    return Genotype.MISSING;
                }
                return IGenotypes.this.get(index);
            }

            @Override
            public synchronized ICounter counter() {
                if (this.isAssignableFromModifiableContainer()) {
                    return ICounter.instanceOf(this);
                }
                if (this.counter == null) {
                    this.counter = ICounter.instanceOf(this);
                }
                return this.counter;
            }
        };
    }

    public final IGenotypes subGenotypes(IntList subLists, byte[] cache) {
        if (subLists == null) {
            return this;
        }
        if (subLists.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (this.size() == 0) {
            return new ConstantGenotypes(subLists.size(), this.isPhased(), Genotype.MISSING);
        }
        if (cache == null || cache.length != subLists.size()) {
            cache = new byte[subLists.size()];
        }
        IntArray GTs = new IntArray(9);
        int l = subLists.size();
        for (int i = 0; i < l; ++i) {
            int index = subLists.get(i);
            if (index < 0 || index >= this.size()) {
                GTs.offset(0, 1);
                cache[i] = 0;
                continue;
            }
            Genotype genotype = this.get(index);
            if (genotype.intcode() >= 256) {
                GTs.offset(0, 1);
                cache[i] = 0;
                continue;
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[i] = genotype.bytecode();
        }
        return new LiteGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes subGenotypes(IntList subLists, short[] cache) {
        if (subLists == null) {
            return this;
        }
        if (subLists.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (this.size() == 0) {
            return new ConstantGenotypes(subLists.size(), this.isPhased(), Genotype.MISSING);
        }
        if (cache == null || cache.length != subLists.size()) {
            cache = new short[subLists.size()];
        }
        IntArray GTs = new IntArray(9);
        int l = subLists.size();
        for (int i = 0; i < l; ++i) {
            int index = subLists.get(i);
            if (index < 0 || index >= this.size()) {
                GTs.offset(0, 1);
                cache[i] = 0;
                continue;
            }
            Genotype genotype = this.get(index);
            if (genotype.intcode() >= 65536) {
                GTs.offset(0, 1);
                cache[i] = 0;
                continue;
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[i] = genotype.shortcode();
        }
        return new Genotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes subGenotypes(IntList subLists, int[] cache) {
        if (subLists == null) {
            return this;
        }
        if (subLists.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (this.size() == 0) {
            return new ConstantGenotypes(subLists.size(), this.isPhased(), Genotype.MISSING);
        }
        if (cache == null || cache.length != subLists.size()) {
            cache = new int[subLists.size()];
        }
        IntArray GTs = new IntArray(9);
        int l = subLists.size();
        for (int i = 0; i < l; ++i) {
            int index = subLists.get(i);
            if (index < 0 || index >= this.size()) {
                GTs.offset(0, 1);
                cache[i] = 0;
                continue;
            }
            Genotype genotype = this.get(index);
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[i] = genotype.intcode();
        }
        return new LargeGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes toBiallelic(final int refAlleleIndex, final int altAlleleIndex, final int otherwise) {
        Genotype.checkAlleleIndex(otherwise, true);
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        return new IGenotypes(){
            ICounter counter;

            @Override
            public boolean isAssignableFromModifiableContainer() {
                return IGenotypes.this.isAssignableFromModifiableContainer();
            }

            @Override
            public boolean isPhased() {
                return IGenotypes.this.isPhased();
            }

            @Override
            public int size() {
                return IGenotypes.this.size();
            }

            @Override
            public Genotype get(int index) {
                return IGenotypes.this.get(index).map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise);
            }

            @Override
            public synchronized ICounter counter() {
                if (this.isAssignableFromModifiableContainer()) {
                    return IGenotypes.this.counter().map(genotype -> genotype.map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise));
                }
                if (this.counter == null) {
                    this.counter = IGenotypes.this.counter().map(genotype -> genotype.map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise));
                }
                return this.counter;
            }
        };
    }

    public final IGenotypes toBiallelic(int refAlleleIndex, int altAlleleIndex, int otherwise, byte[] cache) {
        if (otherwise > 14) {
            otherwise = -1;
        }
        Genotype.checkAlleleIndex(otherwise, true);
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new byte[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise);
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.bytecode();
        }
        return new LiteGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes toBiallelic(int refAlleleIndex, int altAlleleIndex, int otherwise, short[] cache) {
        if (otherwise > 254) {
            otherwise = -1;
        }
        Genotype.checkAlleleIndex(otherwise, true);
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new short[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise);
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.shortcode();
        }
        return new Genotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes toBiallelic(int refAlleleIndex, int altAlleleIndex, int otherwise, int[] cache) {
        Genotype.checkAlleleIndex(otherwise, true);
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new int[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), refAlleleIndex, altAlleleIndex, otherwise);
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.intcode();
        }
        return new LargeGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(final Function<Genotype, Genotype> mapper) {
        if (mapper == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        return new IGenotypes(){
            ICounter counter;

            @Override
            public boolean isAssignableFromModifiableContainer() {
                return IGenotypes.this.isAssignableFromModifiableContainer();
            }

            @Override
            public boolean isPhased() {
                return IGenotypes.this.isPhased();
            }

            @Override
            public int size() {
                return IGenotypes.this.size();
            }

            @Override
            public Genotype get(int index) {
                Genotype genotype = (Genotype)mapper.apply(IGenotypes.this.get(index));
                if (genotype == null) {
                    genotype = Genotype.MISSING;
                }
                if (!this.isPhased()) {
                    genotype = genotype.toUnPhased();
                }
                return genotype;
            }

            @Override
            public synchronized ICounter counter() {
                if (this.isAssignableFromModifiableContainer()) {
                    return IGenotypes.this.counter().map(mapper);
                }
                if (this.counter == null) {
                    this.counter = IGenotypes.this.counter().map(mapper);
                }
                return this.counter;
            }
        };
    }

    public final IGenotypes map(Function<Genotype, Genotype> mapper, byte[] cache) {
        if (mapper == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new byte[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = mapper.apply(this.get(index));
            if (genotype == null || genotype.intcode() >= 256) {
                genotype = Genotype.MISSING;
            }
            if (!this.isPhased()) {
                genotype = genotype.toUnPhased();
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.bytecode();
        }
        return new LiteGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(Function<Genotype, Genotype> mapper, short[] cache) {
        if (mapper == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new short[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = mapper.apply(this.get(index));
            if (genotype == null || genotype.intcode() >= 65536) {
                genotype = Genotype.MISSING;
            }
            if (!this.isPhased()) {
                genotype = genotype.toUnPhased();
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.shortcode();
        }
        return new Genotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(Function<Genotype, Genotype> mapper, int[] cache) {
        if (mapper == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new int[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = mapper.apply(this.get(index));
            if (genotype == null) {
                genotype = Genotype.MISSING;
            }
            if (!this.isPhased()) {
                genotype = genotype.toUnPhased();
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.intcode();
        }
        return new LargeGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(final int[] alleleIndexes) {
        if (alleleIndexes == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        return new IGenotypes(){
            ICounter counter;

            @Override
            public boolean isModifiable() {
                return false;
            }

            @Override
            public boolean isAssignableFromModifiableContainer() {
                return IGenotypes.this.isAssignableFromModifiableContainer();
            }

            @Override
            public boolean isPhased() {
                return IGenotypes.this.isPhased();
            }

            @Override
            public int size() {
                return IGenotypes.this.size();
            }

            @Override
            public Genotype get(int index) {
                Genotype genotype = IGenotypes.this.get(index);
                if (genotype == null) {
                    genotype = Genotype.MISSING;
                }
                return genotype.map(this.isPhased(), alleleIndexes);
            }

            @Override
            public synchronized ICounter counter() {
                if (this.isAssignableFromModifiableContainer()) {
                    return IGenotypes.this.counter().map(genotype -> genotype.map(this.isPhased(), alleleIndexes));
                }
                if (this.counter == null) {
                    this.counter = IGenotypes.this.counter().map(genotype -> genotype.map(this.isPhased(), alleleIndexes));
                }
                return this.counter;
            }
        };
    }

    public final IGenotypes map(int[] alleleIndexes, byte[] cache) {
        if (alleleIndexes == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new byte[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), alleleIndexes);
            if (genotype == null || genotype.intcode() >= 256) {
                genotype = Genotype.MISSING;
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.bytecode();
        }
        return new LiteGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(int[] alleleIndexes, short[] cache) {
        if (alleleIndexes == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new short[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), alleleIndexes);
            if (genotype == null || genotype.intcode() >= 65536) {
                genotype = Genotype.MISSING;
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.shortcode();
        }
        return new Genotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes map(int[] alleleIndexes, int[] cache) {
        if (alleleIndexes == null) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (cache == null || cache.length != this.size()) {
            cache = new int[this.size()];
        }
        IntArray GTs = new IntArray(9);
        for (int index = 0; index < this.size(); ++index) {
            Genotype genotype = this.get(index).map(this.isPhased(), alleleIndexes);
            if (genotype == null) {
                genotype = Genotype.MISSING;
            }
            GTs.ensureIndex(genotype.intcode());
            GTs.offset(genotype.intcode(), 1);
            cache[index] = genotype.intcode();
        }
        return new LargeGenotypes(this.isPhased(), cache, GTs);
    }

    public final IGenotypes setPhased(boolean phased) {
        if (phased == this.isPhased()) {
            return this;
        }
        if (this.size() == 0) {
            return CacheGenotypes.EMPTY;
        }
        if (phased) {
            return new IGenotypes(){

                @Override
                public boolean isModifiable() {
                    return IGenotypes.this.isModifiable();
                }

                @Override
                public boolean isAssignableFromModifiableContainer() {
                    return IGenotypes.this.isAssignableFromModifiableContainer();
                }

                @Override
                public boolean isPhased() {
                    return true;
                }

                @Override
                public int size() {
                    return IGenotypes.this.size();
                }

                @Override
                public Genotype get(int index) {
                    return IGenotypes.this.get(index);
                }

                @Override
                public ICounter counter() {
                    return IGenotypes.this.counter();
                }

                @Override
                public IGenotypes set(int index, int genotype) {
                    IGenotypes.this.set(index, Genotype.of(genotype));
                    return this;
                }

                @Override
                public IGenotypes set(int index, Genotype genotype) {
                    IGenotypes.this.set(index, genotype);
                    return this;
                }
            };
        }
        return new IGenotypes(){

            @Override
            public boolean isModifiable() {
                return IGenotypes.this.isModifiable();
            }

            @Override
            public boolean isAssignableFromModifiableContainer() {
                return IGenotypes.this.isAssignableFromModifiableContainer();
            }

            @Override
            public boolean isPhased() {
                return false;
            }

            @Override
            public int size() {
                return IGenotypes.this.size();
            }

            @Override
            public Genotype get(int index) {
                return IGenotypes.this.get(index).toUnPhased();
            }

            @Override
            public ICounter counter() {
                return IGenotypes.this.counter().map(Genotype::toUnPhased);
            }

            @Override
            public IGenotypes set(int index, int genotype) {
                IGenotypes.this.set(index, Genotype.of(genotype).toUnPhased());
                return this;
            }

            @Override
            public IGenotypes set(int index, Genotype genotype) {
                IGenotypes.this.set(index, genotype.toUnPhased());
                return this;
            }
        };
    }

    public final void fill(byte[] hashes, LongBits diff) {
        if (diff == null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                hashes[i] = this.get(i).bytecode();
            }
        } else {
            diff.clear();
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                Genotype genotype = this.get(i);
                if (genotype.bytecode() == hashes[i]) continue;
                hashes[i] = genotype.bytecode();
                diff.set(i);
            }
        }
    }

    public final void fill(short[] hashes, LongBits diff) {
        if (diff == null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                hashes[i] = this.get(i).shortcode();
            }
        } else {
            diff.clear();
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                Genotype genotype = this.get(i);
                if (genotype.shortcode() == hashes[i]) continue;
                hashes[i] = genotype.shortcode();
                diff.set(i);
            }
        }
    }

    public final void fill(int[] hashes, LongBits diff) {
        if (diff == null) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                hashes[i] = this.get(i).intcode();
            }
        } else {
            diff.clear();
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                Genotype genotype = this.get(i);
                if (genotype.intcode() == hashes[i]) continue;
                hashes[i] = genotype.intcode();
                diff.set(i);
            }
        }
    }

    @Override
    public final Iterator<Genotype> iterator() {
        return new Iterator<Genotype>(){
            int pointer = 0;

            @Override
            public boolean hasNext() {
                return this.pointer < IGenotypes.this.size();
            }

            @Override
            public Genotype next() {
                return IGenotypes.this.get(this.pointer++);
            }
        };
    }

    public final IndexIterator where(IFilter<Genotype> filter) {
        return new IndexIterator(this.size(), filter == null ? null : index -> filter.filter(this.get(index)));
    }

    public final boolean equals(IGenotypes genotypes) {
        if (genotypes == null) {
            return false;
        }
        if (genotypes == this) {
            return true;
        }
        if (this.size() != genotypes.size() || this.isPhased() != genotypes.isPhased()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == genotypes.get(i)) continue;
            return false;
        }
        return true;
    }
}

