/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.cache;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.DBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.EBEG2CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.EBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.HBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.MBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.SBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.TBEGCacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.BEDGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

public abstract class CacheGenotypes
extends IGenotypes {
    public static CacheGenotypes EMPTY = new CacheGenotypes(false, EmptyCounter.INSTANCE(), Bytes.EMPTY){

        @Override
        public Genotype get(int index) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
    };
    protected final Bytes codec;
    protected final ICounter counter;
    protected final boolean phased;
    protected final int size;

    public CacheGenotypes(boolean phased, ICounter counter, Bytes codec) {
        this.phased = phased;
        this.counter = counter;
        this.codec = codec;
        this.size = counter.count();
    }

    public static IGenotypes load(Bytes codec) {
        if (codec == null || codec.length() == 0) {
            return EMPTY;
        }
        ByteStream reader = codec.toByteStream();
        ICounter counter = ICounter.decode(reader.getBytes());
        byte firstByte = reader.getByte();
        GenotypesType type = GenotypesType.getType(firstByte);
        boolean phased = GenotypesType.isPhased(firstByte);
        int offset = reader.rTell();
        reader.close();
        switch (type) {
            case CBEG: {
                return new CBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case EBEG_1: {
                return new EBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case MBEG: {
                return new MBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case HBEG: {
                return new HBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case SBEG: {
                return new SBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case DBEG: {
                return new DBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case TBEG: {
                return new TBEGCacheGenotypes(phased, counter, offset, codec);
            }
            case PLINK_BED: {
                return new BEDGenotypes(phased, counter, offset, codec);
            }
            case EBEG_2: {
                return new EBEG2CacheGenotypes(phased, counter, offset, codec);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)type));
    }

    public final Bytes encode() {
        return this.codec;
    }

    @Override
    public final boolean isModifiable() {
        return false;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return false;
    }

    @Override
    public final boolean isPhased() {
        return this.phased;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final ICounter counter() {
        return this.counter;
    }

    @Override
    public final IGenotypes set(int index, int genotype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final IGenotypes set(int index, Genotype genotype) {
        throw new UnsupportedOperationException();
    }
}

