/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.cache;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.sparsearray.SparseByteArray;
import edu.sysu.pmglab.container.sparsearray.SparseIntArray;
import edu.sysu.pmglab.container.sparsearray.SparseShortArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

class EBEGCacheGenotypes
extends CacheGenotypes {
    final int offset;
    Viewer viewer = null;

    EBEGCacheGenotypes(boolean phased, ICounter counter, int offset, Bytes codec) {
        super(phased, counter, codec);
        this.offset = offset;
    }

    synchronized void init() {
        if (this.viewer == null) {
            int maxAlleleNum = this.counter.maxAlleleIndex() + 1;
            this.viewer = maxAlleleNum <= 15 ? new ByteViewer(this, this.offset, this.codec) : (maxAlleleNum <= 255 ? new ShortViewer(this, this.offset, this.codec) : new IntViewer(this, this.offset, this.codec));
        }
    }

    @Override
    public Genotype get(int index) {
        if (this.viewer == null) {
            this.init();
        }
        return this.viewer.get(index);
    }

    static class IntViewer
    implements Viewer {
        final SparseIntArray minors;

        public IntViewer(EBEGCacheGenotypes parent, int offset, Bytes codec) {
            ByteStream reader = codec.toByteStream();
            reader.rSkip(offset);
            SparseIntArray minors = new SparseIntArray(parent.size(), Genotype.of(reader.getVarInt32()).intcode(), 6);
            while (reader.rRemaining() > 0) {
                int index;
                int lastIndex = 0;
                int minorGenotype = reader.getVarInt32();
                while ((index = reader.getVarInt32()) != -1) {
                    minors.set(index += lastIndex, minorGenotype);
                    lastIndex = index;
                }
            }
            reader.close();
            this.minors = minors;
        }

        @Override
        public Genotype get(int index) {
            return Genotype.of(this.minors.get(index));
        }
    }

    static class ShortViewer
    implements Viewer {
        final SparseShortArray minors;

        public ShortViewer(EBEGCacheGenotypes parent, int offset, Bytes codec) {
            ByteStream reader = codec.toByteStream();
            reader.rSkip(offset);
            SparseShortArray minors = new SparseShortArray(parent.size(), Genotype.of(reader.getVarInt32()).shortcode(), 6);
            while (reader.rRemaining() > 0) {
                int index;
                int lastIndex = 0;
                int minorGenotype = reader.getVarInt32();
                while ((index = reader.getVarInt32()) != -1) {
                    minors.set(index += lastIndex, (short)minorGenotype);
                    lastIndex = index;
                }
            }
            reader.close();
            this.minors = minors;
        }

        @Override
        public Genotype get(int index) {
            return Genotype.of(this.minors.get(index));
        }
    }

    static class ByteViewer
    implements Viewer {
        final SparseByteArray minors;

        public ByteViewer(EBEGCacheGenotypes parent, int offset, Bytes codec) {
            ByteStream reader = codec.toByteStream();
            reader.rSkip(offset);
            SparseByteArray minors = new SparseByteArray(parent.size(), Genotype.of(reader.getVarInt32()).bytecode(), 6);
            while (reader.rRemaining() > 0) {
                int index;
                int lastIndex = 0;
                int minorGenotype = reader.getVarInt32();
                while ((index = reader.getVarInt32()) != -1) {
                    minors.set(index += lastIndex, (byte)minorGenotype);
                    lastIndex = index;
                }
            }
            reader.close();
            this.minors = minors;
        }

        @Override
        public Genotype get(int index) {
            return Genotype.of(this.minors.get(index));
        }
    }

    static interface Viewer {
        public Genotype get(int var1);
    }
}

