/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.cache;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

class HBEGCacheGenotypes
extends CacheGenotypes {
    final int offset;

    HBEGCacheGenotypes(boolean phased, ICounter counter, int offset, Bytes codec) {
        super(phased, counter, codec);
        this.offset = offset;
    }

    @Override
    public Genotype get(int keyIndex) {
        if (keyIndex < 0 || keyIndex >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(keyIndex));
        }
        int byteIndex = keyIndex >> 1;
        int codeIndex = keyIndex & 1;
        if (codeIndex == 0) {
            return Genotype.of(this.codec.fastByteAt(byteIndex + this.offset) & 0xF);
        }
        return Genotype.of(this.codec.fastByteAt(byteIndex + this.offset) >> 4 & 0xF);
    }
}

