/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.cache;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypeCodingException;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

class MBEGCacheGenotypes
extends CacheGenotypes {
    final int offset;
    Viewer viewer = null;

    MBEGCacheGenotypes(boolean phased, ICounter counter, int offset, Bytes codec) {
        super(phased, counter, codec);
        this.offset = offset;
    }

    synchronized void init() {
        if (this.viewer == null) {
            this.viewer = new Viewer(this.size - this.counter.count(this.counter().argmax()), this.offset, this.codec);
        }
    }

    @Override
    public Genotype get(int index) {
        if (this.viewer == null) {
            this.init();
        }
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.viewer.get(index) ? this.viewer.ONE : this.viewer.ZERO;
    }

    static class Viewer {
        static int[] MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        final Genotype ZERO;
        final Genotype ONE;
        final int bitStart;
        final int bitEnd;
        final int wordStart;
        final int offset;
        final byte[] bytes;
        final boolean isContinue;

        public Viewer(int size, int offset, Bytes cache) {
            ByteStream reader = cache.toByteStream();
            reader.rSeek(offset);
            this.ZERO = Genotype.of(reader.getVarInt32());
            this.ONE = Genotype.of(reader.getVarInt32());
            if (this.ZERO == this.ONE) {
                this.bitStart = -1;
                this.bitEnd = -1;
                this.wordStart = -1;
                this.offset = -1;
                this.bytes = null;
                this.isContinue = true;
            } else {
                this.bitStart = reader.getVarInt32();
                this.bitEnd = reader.getVarInt32() + this.bitStart;
                this.isContinue = this.bitEnd - this.bitStart + 1 == size;
                this.wordStart = this.bitStart >> 3;
                int wordEnd = this.bitEnd >> 3;
                if (reader.length() != reader.rTell() + wordEnd - this.wordStart + 1) {
                    throw new GenotypeCodingException("Invalid input length");
                }
                this.offset = reader.rTell() - this.wordStart;
                this.bytes = cache.bytes();
            }
            reader.close();
        }

        public boolean get(int bitIndex) {
            if (this.bytes == null) {
                return false;
            }
            if (this.bitStart <= bitIndex && this.bitEnd >= bitIndex) {
                if (this.isContinue) {
                    return true;
                }
                int wordIndex = bitIndex >> 3;
                int bitPosition = bitIndex & 7;
                byte b = this.bytes[this.offset + wordIndex];
                if (b == 0) {
                    return false;
                }
                return (b & MASKS[bitPosition]) != 0;
            }
            return false;
        }
    }
}

