/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.cache.CacheGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import java.util.function.Function;

public class BEDGenotypes
extends CacheGenotypes {
    private static final Genotype[] BED_DECODER = new Genotype[]{Genotype.of(0, 0), Genotype.of(-1, -1), Genotype.of(0, 1), Genotype.of(1, 1)};
    private static final Function<Genotype, Genotype> MAPPER = genotype -> {
        if (genotype.left() == -1 || genotype.right() == -1 || genotype.left() >= 2 || genotype.right() >= 2) {
            return Genotype.MISSING;
        }
        return genotype.toUnPhased();
    };
    final int offset;

    public BEDGenotypes(boolean phased, ICounter counter, int offset, Bytes codec) {
        super(phased, counter, codec);
        this.offset = offset;
    }

    private static byte encode(Genotype genotype) {
        switch (genotype.intcode()) {
            case 2: {
                return 0;
            }
            case 5: 
            case 7: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 1;
    }

    public static BEDGenotypes load(IGenotypes genotypes) {
        Genotype genotype2;
        if (genotypes.size() == 0) {
            throw new UnsupportedOperationException("The BED genotype array requires at least 1 genotype");
        }
        if (genotypes instanceof BEDGenotypes) {
            return (BEDGenotypes)genotypes;
        }
        ICounter counter = genotypes.counter().map(MAPPER);
        ByteStream cache = ByteStream.getThreadInstance();
        counter.encodeTo(cache);
        cache.write(GenotypesType.PLINK_BED.getMagicCode(false));
        int offset = cache.length();
        int groupLength = genotypes.size() / 4;
        int resLength = genotypes.size() % 4;
        cache.wRequire(groupLength + 1);
        for (int i = 0; i < groupLength; ++i) {
            Genotype genotype1 = genotypes.get(i << 2);
            Genotype genotype22 = genotypes.get((i << 2) + 1);
            Genotype genotype3 = genotypes.get((i << 2) + 2);
            Genotype genotype4 = genotypes.get((i << 2) + 3);
            cache.write((byte)(BEDGenotypes.encode(genotype1) | BEDGenotypes.encode(genotype22) << 2 | BEDGenotypes.encode(genotype3) << 4 | BEDGenotypes.encode(genotype4) << 6));
        }
        if (resLength == 1) {
            Genotype genotype1 = genotypes.get(groupLength << 2);
            cache.write(BEDGenotypes.encode(genotype1));
        } else if (resLength == 2) {
            Genotype genotype1 = genotypes.get(groupLength << 2);
            genotype2 = genotypes.get((groupLength << 2) + 1);
            cache.write((byte)(BEDGenotypes.encode(genotype1) | BEDGenotypes.encode(genotype2) << 2));
        } else if (resLength == 3) {
            Genotype genotype1 = genotypes.get(groupLength << 2);
            genotype2 = genotypes.get((groupLength << 2) + 1);
            Genotype genotype3 = genotypes.get((groupLength << 2) + 2);
            cache.write((byte)(BEDGenotypes.encode(genotype1) | BEDGenotypes.encode(genotype2) << 2 | BEDGenotypes.encode(genotype3) << 4));
        }
        return new BEDGenotypes(false, counter, offset, cache.toBytes(true));
    }

    public Bytes toBED() {
        return this.codec.subBytes(this.offset);
    }

    @Override
    public Genotype get(int genotypeIndex) {
        int byteIndex = genotypeIndex >> 2;
        int individualIndex = genotypeIndex & 3;
        byte bits = this.codec.fastByteAt(this.offset + byteIndex);
        if (individualIndex == 0) {
            return BED_DECODER[bits & 3];
        }
        if (individualIndex == 1) {
            return BED_DECODER[(bits & 0xC) >> 2];
        }
        if (individualIndex == 2) {
            return BED_DECODER[(bits & 0x30) >> 4];
        }
        return BED_DECODER[(bits & 0xC0) >> 6];
    }
}

