/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.LiteCounter;

public final class ConstantGenotypes
extends IGenotypes {
    final Genotype genotype;
    final boolean phased;
    final int size;
    final ICounter counter;

    public ConstantGenotypes(int size) {
        this(size, null);
    }

    public ConstantGenotypes(int size, Genotype genotype) {
        this(size, false, genotype);
    }

    public ConstantGenotypes(int size, boolean phased, Genotype genotype) {
        if (size < 0) {
            throw new IllegalArgumentException("count of genotypes equals to a negative value " + size + " (< 0)");
        }
        if (genotype == null) {
            genotype = Genotype.MISSING;
        } else if (!phased) {
            genotype = genotype.toUnPhased();
        }
        this.phased = phased;
        this.size = size;
        if (this.size == 0) {
            this.genotype = Genotype.MISSING;
            this.counter = EmptyCounter.INSTANCE();
        } else {
            this.genotype = genotype;
            this.counter = new LiteCounter(size, genotype);
        }
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return false;
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Genotype get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.genotype;
    }

    @Override
    public ICounter counter() {
        return this.counter;
    }
}

