/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ArrayCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import java.util.Arrays;

public class Genotypes
extends IGenotypes {
    final short[] genotypes;
    final IntArray GTs;
    final boolean phased;
    final ICounter counter;

    public Genotypes(int size) {
        this(size, false);
    }

    public Genotypes(int size, boolean phased) {
        this.phased = phased;
        if (size <= 0) {
            this.genotypes = EmptyArray.SHORT;
            this.GTs = null;
            this.counter = EmptyCounter.INSTANCE();
        } else {
            this.genotypes = new short[size];
            this.GTs = new IntArray(1);
            this.GTs.set(0, size);
            this.counter = new ArrayCounter(this.GTs, size);
        }
    }

    public Genotypes(boolean phased, short[] genotypes, IntArray GTs) {
        this.phased = phased;
        if (genotypes == null || genotypes.length == 0) {
            this.genotypes = EmptyArray.SHORT;
            this.GTs = null;
            this.counter = EmptyCounter.INSTANCE();
        } else {
            this.genotypes = genotypes;
            if (GTs == null) {
                this.GTs = new IntArray(1);
                for (short genotype : this.genotypes) {
                    int code = genotype & 0xFFFF;
                    this.GTs.ensureIndex(code);
                    this.GTs.offset(code, 1);
                }
            } else {
                this.GTs = GTs;
            }
            this.counter = new ArrayCounter(this.GTs, genotypes.length);
        }
    }

    public Genotypes clear() {
        int i;
        int count;
        if (this.genotypes.length == 0 || this.GTs.get(0) == this.genotypes.length) {
            return this;
        }
        if (this.GTs.get(0) == 0) {
            Arrays.fill(this.genotypes, (short)0);
        } else {
            count = this.genotypes.length - this.GTs.get(0);
            for (i = 0; i < this.genotypes.length; ++i) {
                if (this.genotypes[i] == 0) continue;
                this.genotypes[i] = 0;
                if (--count == 0) break;
            }
        }
        count = this.genotypes.length;
        for (i = 0; i < this.GTs.length(); ++i) {
            if (this.GTs.get(i) <= 0) continue;
            this.GTs.set(i, 0);
            if ((count -= this.GTs.get(i)) == 0) break;
        }
        this.GTs.set(0, this.genotypes.length);
        return this;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return true;
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    @Override
    public int size() {
        return this.genotypes.length;
    }

    @Override
    public Genotype get(int index) {
        return Genotype.of(this.genotypes[index]);
    }

    @Override
    public ICounter counter() {
        return this.counter;
    }

    @Override
    public Genotypes set(int index, int genotype) {
        int originCode;
        if (genotype <= 0 || genotype >= 65536) {
            genotype = 0;
        }
        if (!this.phased && genotype != 0) {
            genotype = Genotype.of(genotype, false).intcode();
        }
        if (genotype != (originCode = this.genotypes[index] & 0xFFFF)) {
            this.GTs.ensureIndex(genotype);
            this.GTs.offset(originCode, -1);
            this.GTs.offset(genotype, 1);
            this.genotypes[index] = (short)genotype;
        }
        return this;
    }

    @Override
    public Genotypes set(int index, Genotype g) {
        int originCode;
        int genotype;
        if (g == null) {
            g = Genotype.MISSING;
        }
        if (!this.phased) {
            g = g.toUnPhased();
        }
        if ((genotype = g.shortcode() & 0xFFFF) != (originCode = this.genotypes[index] & 0xFFFF)) {
            this.GTs.ensureIndex(genotype);
            this.GTs.offset(originCode, -1);
            this.GTs.offset(genotype, 1);
            this.genotypes[index] = g.shortcode();
        }
        return this;
    }

    public short[] getCache() {
        return this.genotypes;
    }
}

