/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

public class LitePGENGenotypes
extends IGenotypes {
    final byte[] genotypes;
    ICounter counter;

    public LitePGENGenotypes(byte[] genotypes) {
        this.genotypes = genotypes;
    }

    public LitePGENGenotypes(byte[] genotypes, ICounter counter) {
        this.genotypes = genotypes;
        if (counter != null) {
            this.counter = counter;
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return true;
    }

    @Override
    public boolean isPhased() {
        return false;
    }

    @Override
    public int size() {
        return this.genotypes.length;
    }

    @Override
    public Genotype get(int index) {
        byte code = this.genotypes[index];
        if (code == 0) {
            return Genotype.of(0, 0);
        }
        if (code == 1) {
            return Genotype.of(0, 1);
        }
        if (code == 2) {
            return Genotype.of(1, 1);
        }
        return Genotype.MISSING;
    }

    @Override
    public synchronized ICounter counter() {
        if (this.counter == null) {
            this.counter = ICounter.instanceOf(this);
        }
        return this.counter;
    }

    @Override
    public IGenotypes set(int index, int genotype) {
        byte code = this.genotypes[index];
        if (genotype == 2) {
            if (code != 0) {
                this.genotypes[index] = 0;
                this.counter = null;
            }
        } else if (genotype == 5 || genotype == 7) {
            if (code != 1) {
                this.genotypes[index] = 1;
                this.counter = null;
            }
        } else if (genotype == 6) {
            if (code != 2) {
                this.genotypes[index] = 2;
                this.counter = null;
            }
        } else if (code != -9) {
            this.genotypes[index] = -9;
            this.counter = null;
        }
        return this;
    }

    @Override
    public IGenotypes set(int index, Genotype genotype) {
        byte code = this.genotypes[index];
        if (genotype.intcode() == 2) {
            if (code != 0) {
                this.genotypes[index] = 0;
                this.counter = null;
            }
        } else if (genotype.intcode() == 5 || genotype.intcode() == 7) {
            if (code != 1) {
                this.genotypes[index] = 1;
                this.counter = null;
            }
        } else if (genotype.intcode() == 6) {
            if (code != 2) {
                this.genotypes[index] = 2;
                this.counter = null;
            }
        } else if (code != -9) {
            this.genotypes[index] = -9;
            this.counter = null;
        }
        return this;
    }
}

