/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.utils.Assert;

public class PGENGenotypes
extends IGenotypes {
    static final int MAX_ALLELE_INDEX = 254;
    static final int MAX_ALLELE_NUM = 255;
    final int[] genotypes;
    final int size;
    final boolean phased;
    ICounter counter;

    public PGENGenotypes(boolean phased, int[] genotypes, ICounter counter) {
        Assert.that(genotypes.length % 2 == 0);
        this.size = genotypes.length >> 1;
        this.genotypes = genotypes;
        this.phased = phased;
        if (counter != null) {
            this.counter = counter;
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return true;
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Genotype get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        int relIndex = index << 1;
        int left = this.genotypes[relIndex];
        int right = this.genotypes[relIndex | 1];
        if (left == -9 || right == -9) {
            return Genotype.MISSING;
        }
        if (this.phased) {
            return Genotype.of(left, right);
        }
        return Genotype.of(left, right).toUnPhased();
    }

    @Override
    public synchronized ICounter counter() {
        if (this.counter == null) {
            this.counter = ICounter.instanceOf(this);
        }
        return this.counter;
    }

    @Override
    public IGenotypes set(int index, int genotype) {
        if (genotype < 0 || genotype > 0xFFFFFF) {
            genotype = 0;
        }
        return this.set(index, Genotype.of(genotype, true));
    }

    @Override
    public IGenotypes set(int index, Genotype genotype) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        int relIndex = index << 1;
        int left = this.genotypes[relIndex];
        int right = this.genotypes[relIndex | 1];
        if (left == -9 || right == -9) {
            left = -9;
            right = -9;
        }
        if (genotype.left() == -1 || genotype.right() == -1) {
            genotype = Genotype.MISSING;
        } else {
            Genotype genotype2 = genotype = this.isPhased() ? genotype : genotype.toUnPhased();
        }
        if (genotype.left() != left || genotype.right() != right) {
            this.genotypes[relIndex] = genotype.left() == -1 ? -9 : genotype.left();
            this.genotypes[relIndex | 1] = genotype.right() == -1 ? -9 : genotype.right();
            this.counter = null;
        }
        return this;
    }
}

