/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.LiteCounter;
import java.util.Arrays;

public class PLTypedGenotypes
extends IGenotypes {
    private static final Genotype[] DECODER;
    private static final int[][] ENCODER;
    final int[] genotypes;
    ICounter counter;

    public PLTypedGenotypes(int size) {
        this.genotypes = new int[size];
        Arrays.fill(this.genotypes, -1);
        this.counter = new LiteCounter(size, Genotype.MISSING);
    }

    public PLTypedGenotypes(int[] genotypes) {
        this.genotypes = genotypes == null ? EmptyArray.INT : genotypes;
    }

    public static Genotype toGenotype(int code) {
        if (code < 0 || code >= DECODER.length) {
            return Genotype.MISSING;
        }
        return DECODER[code];
    }

    public static int toPLCode(Genotype genotype) {
        if (genotype == null) {
            genotype = Genotype.MISSING;
        }
        if (genotype == Genotype.MISSING) {
            return -1;
        }
        if (genotype.left() <= -1 || genotype.right() <= -1 || genotype.left() > 4094 || genotype.right() > 4094 || genotype.left() > genotype.right()) {
            return -2;
        }
        return ENCODER[genotype.left()][genotype.right() - genotype.left()];
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return true;
    }

    @Override
    public boolean isPhased() {
        return false;
    }

    @Override
    public int size() {
        return this.genotypes.length;
    }

    @Override
    public Genotype get(int index) {
        int code = this.genotypes[index];
        if (code < 0 || code >= DECODER.length) {
            return Genotype.MISSING;
        }
        return DECODER[this.genotypes[index]];
    }

    @Override
    public synchronized ICounter counter() {
        if (this.counter == null) {
            this.counter = ICounter.instanceOf(this);
        }
        return this.counter;
    }

    @Override
    public IGenotypes set(int index, int genotype) {
        if (genotype < 0 || genotype > 0xFFFFFF) {
            genotype = 0;
        }
        return this.set(index, Genotype.of(genotype, false));
    }

    @Override
    public IGenotypes set(int index, Genotype genotype) {
        if ((genotype = genotype.toUnPhased()) != this.get(index)) {
            this.genotypes[index] = PLTypedGenotypes.toPLCode(genotype);
            this.counter = null;
        }
        return this;
    }

    static {
        int j;
        int i;
        DECODER = new Genotype[8386560];
        ENCODER = new int[4095][];
        int index = 0;
        for (i = 0; i <= 4094; ++i) {
            for (j = 0; j <= i; ++j) {
                PLTypedGenotypes.DECODER[index++] = Genotype.of(j, i);
            }
        }
        for (i = 0; i <= 4094; ++i) {
            PLTypedGenotypes.ENCODER[i] = new int[4094 - i + 1];
            for (j = i; j <= 4094; ++j) {
                PLTypedGenotypes.ENCODER[i][j - i] = j * (j + 1) / 2 + i;
            }
        }
    }
}

