/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.container;

import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.container.sparsearray.SparseIntArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ArrayCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;

public final class SparseGenotypes
extends IGenotypes {
    final SparseIntArray genotypes;
    final IntArray GTs;
    final boolean phased;
    final ICounter counter;

    public SparseGenotypes(int size) {
        this(size, Genotype.MISSING);
    }

    public SparseGenotypes(int size, Genotype major) {
        this(size, false, major);
    }

    public SparseGenotypes(int size, boolean phased, Genotype major) {
        this.phased = phased;
        if (major == null) {
            major = Genotype.MISSING;
        } else if (!this.phased) {
            major = major.toUnPhased();
        }
        if (size <= 0) {
            this.genotypes = new SparseIntArray(0);
            this.GTs = null;
            this.counter = EmptyCounter.INSTANCE();
        } else {
            this.genotypes = new SparseIntArray(size, major.intcode(), 6);
            this.GTs = new IntArray(major.intcode() + 1);
            this.GTs.set(major.intcode(), size);
            this.counter = new ArrayCounter(this.GTs, size);
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public boolean isAssignableFromModifiableContainer() {
        return true;
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    @Override
    public int size() {
        return this.genotypes.size();
    }

    @Override
    public Genotype get(int index) {
        return Genotype.of(this.genotypes.get(index));
    }

    @Override
    public ICounter counter() {
        return this.counter;
    }

    @Override
    public SparseGenotypes set(int index, int genotype) {
        int originCode;
        if (genotype < 0 || genotype > 0xFFFFFF) {
            genotype = 0;
        }
        if (!this.phased && genotype != 0) {
            genotype = Genotype.of(genotype, false).intcode();
        }
        if (genotype != (originCode = this.genotypes.get(index))) {
            this.GTs.ensureIndex(genotype);
            this.GTs.offset(originCode, -1);
            this.GTs.offset(genotype, 1);
            this.genotypes.set(index, genotype);
        }
        return this;
    }

    @Override
    public SparseGenotypes set(int index, Genotype g) {
        int originCode;
        int genotype;
        if (g == null) {
            g = Genotype.MISSING;
        }
        if (!this.phased) {
            g = g.toUnPhased();
        }
        if ((genotype = g.intcode()) != (originCode = this.genotypes.get(index))) {
            this.GTs.ensureIndex(genotype);
            this.GTs.offset(originCode, -1);
            this.GTs.offset(genotype, 1);
            this.genotypes.set(index, genotype);
        }
        return this;
    }

    public SparseGenotypes clear() {
        if (this.genotypes != null) {
            this.genotypes.clear();
            this.GTs.fill(0);
            this.GTs.set(this.genotypes.getDefaultValue(), this.genotypes.size());
        }
        return this;
    }
}

