/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.counter;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import gnu.trove.iterator.TIntIterator;
import java.util.NoSuchElementException;

public final class ArrayCounter
extends ICounter {
    final IntArray counter;
    final int total;

    public ArrayCounter(IntArray counter, int total) {
        if (total < 0) {
            throw new IllegalArgumentException("count of genotypes equals to a negative value " + total + " (< 0)");
        }
        if (counter == null) {
            if (total > 0) {
                this.counter = new IntArray(1);
                this.counter.set(0, total);
            } else {
                this.counter = new IntArray(0);
            }
        } else {
            this.counter = counter;
        }
        this.total = total;
    }

    @Override
    public int count(int code) {
        if (code >= 0 && code < this.counter.length()) {
            return this.counter.get(code);
        }
        return 0;
    }

    @Override
    public int getAC() {
        if (this.total == 0) {
            return 0;
        }
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            AC += Genotype.of(i).getAC() * count;
            if ((total -= count) == 0) break;
        }
        return AC;
    }

    @Override
    public int getAN() {
        if (this.total == 0) {
            return 0;
        }
        int AN = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            AN += Genotype.of(i).getAN() * count;
            if ((total -= count) == 0) break;
        }
        return AN;
    }

    @Override
    public float getAF() {
        if (this.total == 0) {
            return Float.NaN;
        }
        int AN = 0;
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            Genotype genotype = Genotype.of(i);
            AC += genotype.getAC() * count;
            AN += genotype.getAN() * count;
            if ((total -= count) == 0) break;
        }
        if (AN == 0) {
            return Float.NaN;
        }
        return (float)AC / (float)AN;
    }

    @Override
    public int getAC(int alleleIndex) {
        if (this.total == 0) {
            return 0;
        }
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            AC += Genotype.of(i).getAC(alleleIndex) * count;
            if ((total -= count) == 0) break;
        }
        return AC;
    }

    @Override
    public int[] getACs() {
        if (this.total == 0) {
            return EmptyArray.INT;
        }
        int maxAlleleIndex = this.maxAlleleIndex();
        if (maxAlleleIndex == -1) {
            return EmptyArray.INT;
        }
        int[] acs = new int[maxAlleleIndex + 1];
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            Genotype genotype = Genotype.of(i);
            if (genotype.left() != -1) {
                int n = genotype.left();
                acs[n] = acs[n] + count;
            }
            if (genotype.right() != -1) {
                int n = genotype.right();
                acs[n] = acs[n] + count;
            }
            if ((total -= count) == 0) break;
        }
        return acs;
    }

    @Override
    public int maxAlleleIndex() {
        if (this.total == 0) {
            return -1;
        }
        int maxAlleleIndex = -1;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            Genotype genotype = Genotype.of(i);
            if (genotype.left() > maxAlleleIndex) {
                maxAlleleIndex = genotype.left();
            }
            if (genotype.right() > maxAlleleIndex) {
                maxAlleleIndex = genotype.right();
            }
            if ((total -= count) == 0) break;
        }
        return maxAlleleIndex;
    }

    @Override
    public Genotype argmax() {
        if (this.total == 0) {
            return Genotype.MISSING;
        }
        int maxCount = 0;
        Genotype maxGenotype = Genotype.MISSING;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            if (count > maxCount) {
                maxCount = count;
                maxGenotype = Genotype.of(i);
            }
            if ((total -= count) == 0) break;
        }
        return maxGenotype;
    }

    @Override
    public int count(IFilter<Genotype> filter) {
        if (this.total == 0) {
            return 0;
        }
        int sum = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            if (filter == null || filter.filter(Genotype.of(i))) {
                sum += count;
            }
            if ((total -= count) == 0) break;
        }
        return sum;
    }

    @Override
    public int count() {
        return this.total;
    }

    @Override
    public int size() {
        if (this.total == 0) {
            return 0;
        }
        int size = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            if (count <= 0) continue;
            ++size;
            if ((total -= count) == 0) break;
        }
        return size;
    }

    @Override
    public TIntIterator codeIterator() {
        if (this.total == 0) {
            return EmptyCounter.INSTANCE().codeIterator();
        }
        return new TIntIterator(){
            int currentIndex = 0;
            int total;
            {
                this.total = ArrayCounter.this.total;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.total -= ArrayCounter.this.counter.get(this.currentIndex);
                return this.currentIndex++;
            }

            @Override
            public boolean hasNext() {
                while (this.currentIndex < ArrayCounter.this.counter.length() && this.total > 0) {
                    if (ArrayCounter.this.counter.get(this.currentIndex) > 0) {
                        return true;
                    }
                    ++this.currentIndex;
                }
                return false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

