/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.counter;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ArrayCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.LiteCounter;
import gnu.trove.iterator.TIntIterator;
import java.util.Iterator;
import java.util.function.Function;

public abstract class ICounter
implements Iterable<Genotype> {
    protected static final ThreadLocal<ByteStream> TEMPS = ThreadLocal.withInitial(ByteStream::new);

    public static ICounter instanceOf(IGenotypes genotypes) {
        if (genotypes.size() > 0) {
            IntArray GTs = new IntArray(9);
            for (Genotype genotype : genotypes) {
                int index = genotype.intcode();
                GTs.ensureIndex(index);
                GTs.offset(index, 1);
            }
            int l = GTs.length();
            for (int i = 0; i < l; ++i) {
                int count = GTs.get(i);
                if (count == genotypes.size()) {
                    return new LiteCounter(count, Genotype.of(i));
                }
                if (count > 0) break;
            }
            return new ArrayCounter(GTs, genotypes.size());
        }
        return EmptyCounter.INSTANCE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICounter decode(Bytes bytes) {
        if (bytes == null || bytes.length() == 0) {
            return EmptyCounter.INSTANCE();
        }
        try (ByteStream reader = bytes.toByteStream();){
            int genotype = reader.getVarInt32();
            int count = reader.getVarInt32();
            if (reader.rRemaining() == 0) {
                if (count == 0) {
                    EmptyCounter emptyCounter = EmptyCounter.INSTANCE();
                    return emptyCounter;
                }
                LiteCounter liteCounter = new LiteCounter(count, Genotype.of(genotype));
                return liteCounter;
            }
            int total = count;
            IntArray GTs = new IntArray(9);
            GTs.ensureIndex(genotype);
            GTs.set(genotype, count);
            while (reader.rRemaining() > 0) {
                genotype = reader.getVarInt32();
                count = reader.getVarInt32();
                if (count > 0) {
                    total += count;
                    GTs.ensureIndex(genotype);
                    GTs.set(genotype, count);
                    continue;
                }
                if (count >= 0) continue;
                throw new IllegalArgumentException("count of genotype '" + Genotype.of(genotype) + "' equals to a negative value " + count + " (< 0)");
            }
            ArrayCounter arrayCounter = new ArrayCounter(GTs, total);
            return arrayCounter;
        }
    }

    public final Bytes encode() {
        if (this.count() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream container = TEMPS.get().clear();
        TIntIterator iterator2 = this.codeIterator();
        while (iterator2.hasNext()) {
            int genotype = iterator2.next();
            int count = this.count(genotype);
            if (count <= 0) continue;
            container.putVarInt32(genotype);
            container.putVarInt32(count);
        }
        return container.toBytes(true);
    }

    public int encodeTo(ByteStream output) {
        ByteStream container = TEMPS.get().clear();
        TIntIterator iterator2 = this.codeIterator();
        while (iterator2.hasNext()) {
            int gt = iterator2.next();
            container.putVarInt32(gt);
            container.putVarInt32(this.count(gt));
        }
        return output.putVarInt32(container.length()) + output.write(container.bytes(), container.offset(), container.length());
    }

    public abstract int count(int var1);

    public final int count(Genotype genotype) {
        return this.count(genotype == null ? 0 : genotype.intcode());
    }

    public abstract int getAC();

    public abstract int getAN();

    public abstract float getAF();

    public abstract int getAC(int var1);

    public abstract int[] getACs();

    public abstract int maxAlleleIndex();

    public abstract Genotype argmax();

    public abstract int count(IFilter<Genotype> var1);

    public abstract int count();

    public abstract int size();

    public abstract TIntIterator codeIterator();

    @Override
    public final Iterator<Genotype> iterator() {
        if (this.count() == 0) {
            return EmptyIterator.INSTANCE();
        }
        final TIntIterator iterator2 = this.codeIterator();
        return new Iterator<Genotype>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Genotype next() {
                return Genotype.of(iterator2.next());
            }
        };
    }

    public final ICounter map(Function<Genotype, Genotype> mapper) {
        if (this.count() == 0) {
            return EmptyCounter.INSTANCE();
        }
        IntArray counter = new IntArray(9);
        int total = 0;
        for (Genotype genotype : this) {
            int count;
            Genotype g = mapper.apply(genotype);
            if (g == null) {
                g = Genotype.MISSING;
            }
            if ((count = this.count(genotype)) > 0) {
                total += count;
                counter.ensureIndex(g.intcode());
                counter.offset(g.intcode(), count);
                continue;
            }
            if (count >= 0) continue;
            throw new IllegalArgumentException("count of genotype '" + g + "' equals to a negative value " + total + " (< 0)");
        }
        if (total == 0) {
            return EmptyCounter.INSTANCE();
        }
        int l = counter.length();
        for (int i = 0; i < l; ++i) {
            int count = counter.get(i);
            if (count == total) {
                return new LiteCounter(count, Genotype.of(i));
            }
            if (count > 0) break;
        }
        return new ArrayCounter(counter, total);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ICounter)) {
            return false;
        }
        ICounter that = (ICounter)obj;
        if (this.size() != that.size()) {
            return false;
        }
        TIntIterator codes = this.codeIterator();
        while (codes.hasNext()) {
            int gty = codes.next();
            if (this.count(gty) == that.count(gty)) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        ByteStream container = new ByteStream();
        TIntIterator iterator2 = this.codeIterator();
        while (iterator2.hasNext()) {
            if (container.length() != 0) {
                container.write(59);
            }
            int gt = iterator2.next();
            container.write(Genotype.of(gt).toASCII(true));
            container.write(61);
            container.writeChar(this.count(gt));
        }
        return container.getString(container.length());
    }

    public final int[] prune(boolean keepRefAllele) {
        int[] ACs = this.getACs();
        int[] alleleIndexes = new int[ACs.length + 1];
        alleleIndexes[0] = -1;
        if (keepRefAllele) {
            int index = 1;
            for (int i = 1; i < ACs.length; ++i) {
                alleleIndexes[i + 1] = ACs[i] > 0 ? index++ : -1;
            }
        } else {
            int index = 0;
            for (int i = 0; i < ACs.length; ++i) {
                alleleIndexes[i + 1] = ACs[i] > 0 ? index++ : -1;
            }
        }
        return alleleIndexes;
    }
}

