/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.counter;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import gnu.trove.iterator.TIntIterator;
import java.util.NoSuchElementException;

public class LiteCounter
extends ICounter {
    final Genotype genotype;
    final int total;

    public LiteCounter(int count, Genotype genotype) {
        Genotype genotype2 = genotype = genotype == null ? Genotype.MISSING : genotype;
        if (count < 0) {
            throw new IllegalArgumentException("count of genotype '" + genotype + "' equals to a negative value " + count + " (< 0)");
        }
        this.genotype = count == 0 ? Genotype.MISSING : genotype;
        this.total = count;
    }

    @Override
    public int count(int code) {
        return code == this.genotype.intcode() ? this.total : 0;
    }

    @Override
    public int getAC() {
        return this.genotype.getAC() * this.total;
    }

    @Override
    public int getAN() {
        return this.genotype.getAN() * this.total;
    }

    @Override
    public float getAF() {
        if (this.total == 0) {
            return Float.NaN;
        }
        int AN = this.genotype.getAN();
        if (AN == 0) {
            return Float.NaN;
        }
        float AC = this.genotype.getAC();
        return AC / (float)AN;
    }

    @Override
    public int getAC(int alleleIndex) {
        return this.genotype.getAC(alleleIndex) * this.total;
    }

    @Override
    public int[] getACs() {
        if (this.total == 0) {
            return EmptyArray.INT;
        }
        int maxAlleleIndex = Math.max(this.genotype.left(), this.genotype.right());
        if (maxAlleleIndex == -1) {
            return EmptyArray.INT;
        }
        int[] acs = new int[maxAlleleIndex + 1];
        if (this.genotype.left() != -1) {
            int n = this.genotype.left();
            acs[n] = acs[n] + this.total;
        }
        if (this.genotype.right() != -1) {
            int n = this.genotype.right();
            acs[n] = acs[n] + this.total;
        }
        return acs;
    }

    @Override
    public int maxAlleleIndex() {
        if (this.total == 0) {
            return -1;
        }
        return Math.max(this.genotype.left(), this.genotype.right());
    }

    @Override
    public Genotype argmax() {
        if (this.total > 0) {
            return this.genotype;
        }
        return Genotype.MISSING;
    }

    @Override
    public int count(IFilter<Genotype> filter) {
        if (this.total > 0 && (filter == null || filter.filter(this.genotype))) {
            return this.total;
        }
        return 0;
    }

    @Override
    public int count() {
        return this.total;
    }

    @Override
    public int size() {
        if (this.total == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public TIntIterator codeIterator() {
        if (this.total == 0) {
            return EmptyCounter.INSTANCE().codeIterator();
        }
        return new TIntIterator(){
            boolean hasNext = true;

            @Override
            public int next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return LiteCounter.this.genotype.intcode();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public void remove() {
                throw new NoSuchElementException();
            }
        };
    }
}

