/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

enum CBEGEncoder implements IBasicEncoder
{
    INSTANCE;


    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return counter.size() <= 1;
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        container.write(GenotypesType.CBEG.getMagicCode(genotypes.isPhased()));
    }

    public String toString() {
        return "CBEGEncoder";
    }
}

