/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

enum DBEGEncoder implements IBasicEncoder
{
    INSTANCE;


    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return numOfAllele <= 255;
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        container.wRequire((genotypes.size() << 1) + 1);
        byte[] bytes = container.bytes();
        int pointer = container.wTell();
        bytes[pointer++] = GenotypesType.DBEG.getMagicCode(genotypes.isPhased());
        int l = genotypes.size();
        for (int i = 0; i < l; ++i) {
            int genotype = genotypes.get(i).intcode();
            if (genotype <= 255) {
                bytes[pointer++] = (byte)(genotype & 0xFF);
                bytes[pointer++] = 0;
                continue;
            }
            if (genotype <= 65535) {
                bytes[pointer++] = (byte)(genotype & 0xFF);
                bytes[pointer++] = (byte)(genotype >> 8 & 0xFF);
                continue;
            }
            bytes[pointer++] = 0;
            bytes[pointer++] = 0;
        }
        container.wSeek(pointer);
    }

    public String toString() {
        return "DBEGEncoder";
    }
}

