/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

enum EBEGEncoder implements IBasicEncoder
{
    INSTANCE;


    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return genotypes.isSparse();
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        Genotype major = counter.argmax();
        int minorCount = genotypes.size() - counter.count(major);
        container.putByte(GenotypesType.EBEG_2.getMagicCode(genotypes.isPhased()));
        container.putVarInt32(major.intcode());
        int lastIndex = 0;
        if (minorCount > 0) {
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                Genotype genotype = genotypes.get(i);
                if (genotype == major) continue;
                container.putVarInt32(genotype.intcode());
                container.putVarInt32(i - lastIndex);
                lastIndex = i;
                if (--minorCount == 0) break;
            }
        }
    }

    public String toString() {
        return "EBEGEncoder";
    }
}

