/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypeCodingException;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.CBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.CacheEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.DBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.EBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.EmptyEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.HBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.MBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.SBEGEncoder;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.TBEGEncoder;
import edu.sysu.pmglab.objectpool.Producer;

public class Encoder {
    private static Producer<IBasicEncoder[]> GETTER = () -> new IBasicEncoder[]{EmptyEncoder.INSTANCE, CacheEncoder.INSTANCE, CBEGEncoder.INSTANCE, MBEGEncoder.INSTANCE, EBEGEncoder.INSTANCE, HBEGEncoder.INSTANCE, SBEGEncoder.INSTANCE, DBEGEncoder.INSTANCE, TBEGEncoder.INSTANCE};
    final IBasicEncoder[] encoders = GETTER.offer();
    final ByteStream cache = new ByteStream(1024);
    final Bytes container;

    public Encoder() {
        this(true);
    }

    public Encoder(boolean share) {
        this.container = share ? new Bytes() : null;
    }

    public static void setGlobalEncoders(Producer<IBasicEncoder[]> encoders) {
        GETTER = encoders;
    }

    public Bytes encode(IGenotypes genotypes) {
        this.cache.clear();
        ICounter counter = genotypes.counter();
        int numOfAllele = counter.maxAlleleIndex() + 1;
        for (IBasicEncoder rule : this.encoders) {
            if (!rule.applicative(genotypes, counter, numOfAllele)) continue;
            rule.encodeTo(genotypes, counter, numOfAllele, this.cache);
            if (this.container == null) {
                return this.cache.toBytes(true);
            }
            return this.cache.toBytes(this.container);
        }
        throw new GenotypeCodingException("Missing genotypes encoder");
    }

    public void close() {
        this.cache.close();
    }
}

