/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

public enum HBEGEncoder implements IBasicEncoder
{
    INSTANCE;


    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return numOfAllele <= 3;
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        container.wRequire(genotypes.size() + 1);
        byte[] bytes = container.bytes();
        int pointer = container.wTell();
        bytes[pointer++] = GenotypesType.HBEG.getMagicCode(genotypes.isPhased());
        int codeIndex = 0;
        int l = genotypes.size();
        for (int i = 0; i < l; ++i) {
            byte genotype = genotypes.get(i).bytecode();
            if (codeIndex == 0) {
                bytes[pointer] = genotype;
                ++codeIndex;
                continue;
            }
            bytes[pointer] = (byte)(bytes[pointer] | genotype << 4);
            codeIndex = 0;
            ++pointer;
        }
        if (codeIndex == 1) {
            ++pointer;
        }
        container.wSeek(pointer);
    }

    public String toString() {
        return "HBEGEncoder";
    }
}

