/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

final class MBEGEncoder
extends Enum<MBEGEncoder>
implements IBasicEncoder {
    public static final /* enum */ MBEGEncoder INSTANCE = new MBEGEncoder();
    private static final /* synthetic */ MBEGEncoder[] $VALUES;

    public static MBEGEncoder[] values() {
        return (MBEGEncoder[])$VALUES.clone();
    }

    public static MBEGEncoder valueOf(String name) {
        return Enum.valueOf(MBEGEncoder.class, name);
    }

    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return counter.size() <= 2 && genotypes.size() >= 64;
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        int wordRequired = (genotypes.size() - 1 >> 3) + 1;
        Genotype ZERO = counter.argmax();
        container.wRequire(wordRequired + 63);
        container.write(GenotypesType.MBEG.getMagicCode(genotypes.isPhased()));
        container.putVarInt32(ZERO.intcode());
        if (counter.size() <= 1) {
            container.putVarInt32(ZERO.intcode());
        } else {
            int mark = container.wTell();
            container.wSeek(mark + 27);
            byte[] words = container.bytes();
            Genotype ONE = null;
            int bitIndex = 7;
            int byteIndex = container.wTell() - 1;
            int countOne = -1;
            int bitStart = -1;
            int bitEnd = -1;
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                if (++bitIndex == 8) {
                    bitIndex = 0;
                    words[++byteIndex] = 0;
                }
                Genotype genotype = genotypes.get(i);
                if (ONE == null && genotype != ZERO) {
                    ONE = genotype;
                    countOne = counter.count(ONE);
                    bitStart = i;
                }
                if (genotype != ONE) continue;
                int n = byteIndex;
                words[n] = (byte)(words[n] | 1 << bitIndex);
                bitEnd = i;
                if (--countOne == 0) break;
            }
            assert (ONE != null);
            container.wSeek(mark);
            container.putVarInt32(ONE.intcode());
            container.putVarInt32(bitStart);
            container.putVarInt32(bitEnd - bitStart);
            int wordStart = bitStart >> 3;
            int wordEnd = bitEnd >> 3;
            container.write(words, mark + 27 + wordStart, wordEnd - wordStart + 1);
        }
    }

    public String toString() {
        return "MBEGEncoder";
    }

    static {
        $VALUES = new MBEGEncoder[]{INSTANCE};
    }
}

