/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.genome.genotype.encoder;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.Genotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LargeGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LiteGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.genome.genotype.encoder.IBasicEncoder;

enum SBEGEncoder implements IBasicEncoder
{
    INSTANCE;


    @Override
    public boolean applicative(IGenotypes genotypes, ICounter counter, int numOfAllele) {
        return numOfAllele <= 15;
    }

    @Override
    public void encodeTo(IGenotypes genotypes, ICounter counter, int numOfAllele, ByteStream container) {
        counter.encodeTo(container);
        container.wRequire(genotypes.size() + 1);
        byte[] bytes = container.bytes();
        int pointer = container.wTell();
        bytes[pointer++] = GenotypesType.SBEG.getMagicCode(genotypes.isPhased());
        if (genotypes instanceof LiteGenotypes) {
            LiteGenotypes typed = (LiteGenotypes)genotypes;
            System.arraycopy(typed.getCache(), 0, bytes, pointer, typed.size());
            pointer += typed.size();
        } else if (genotypes instanceof Genotypes) {
            Genotypes typed = (Genotypes)genotypes;
            short[] codes = typed.getCache();
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                bytes[pointer++] = codes[i] >= 0 && codes[i] <= 255 ? (byte)codes[i] : (byte)0;
            }
        } else if (genotypes instanceof LargeGenotypes) {
            LargeGenotypes typed = (LargeGenotypes)genotypes;
            int[] codes = typed.getCache();
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                bytes[pointer++] = codes[i] >= 0 && codes[i] <= 255 ? (byte)codes[i] : (byte)0;
            }
        } else {
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                bytes[pointer++] = genotypes.get(i).bytecode();
            }
        }
        container.wSeek(pointer);
    }

    public String toString() {
        return "BEGEncoder";
    }
}

