/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.linkagedisequilibrium;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.ILDModel;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.LDProperty;

public enum EntropyLD implements ILDModel
{
    INSTANCE;

    public static final IFieldCollection SCORE;

    @Override
    public IRecord apply(Variant variant1, Variant variant2) {
        Record record = new Record(SCORE);
        if (!this.apply(variant1, variant2, Float.NaN, record)) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("MI", (Object)Float.valueOf(Float.NaN));
            record.set("NMI", (Object)Float.valueOf(Float.NaN));
        }
        return record;
    }

    @Override
    public boolean apply(Variant variant1, Variant variant2, float minAssoc, IRecord record) {
        if (!Float.isNaN(minAssoc) && minAssoc > 1.0f) {
            return false;
        }
        LDProperty property1 = (LDProperty)variant1.getProperty(LDProperty.class.getName());
        LDProperty property2 = (LDProperty)variant2.getProperty(LDProperty.class.getName());
        if (property1 == null || !property1.isLoadFrom(variant1)) {
            property1 = new LDProperty(variant1);
            variant1.setProperty(LDProperty.class.getName(), property1);
        }
        if (property2 == null || !property2.isLoadFrom(variant2)) {
            property2 = new LDProperty(variant2);
            variant2.setProperty(LDProperty.class.getName(), property2);
        }
        int N = 0;
        int N_11 = 0;
        int N_12 = 0;
        int N_22 = 0;
        int N_21 = 0;
        int start = Math.max(property1.VALID.wordStart(), property2.VALID.wordStart());
        int end = Math.min(property1.VALID.wordEnd(), property2.VALID.wordEnd());
        if (start != -1 && end != -1) {
            for (int i = start; i <= end; ++i) {
                long mask = property1.VALID.getWord(i) & property2.VALID.getWord(i);
                if (mask == 0L) continue;
                N += Long.bitCount(mask) << 1;
                N_11 += Long.bitCount(property1.REF[0].getWord(i) & property2.REF[0].getWord(i) & mask) + Long.bitCount(property1.REF[1].getWord(i) & property2.REF[1].getWord(i) & mask);
                N_12 += Long.bitCount(property1.REF[0].getWord(i) & property2.ALT[0].getWord(i) & mask) + Long.bitCount(property1.REF[1].getWord(i) & property2.ALT[1].getWord(i) & mask);
                N_21 += Long.bitCount(property1.ALT[0].getWord(i) & property2.REF[0].getWord(i) & mask) + Long.bitCount(property1.ALT[1].getWord(i) & property2.REF[1].getWord(i) & mask);
                N_22 += Long.bitCount(property1.ALT[0].getWord(i) & property2.ALT[0].getWord(i) & mask) + Long.bitCount(property1.ALT[1].getWord(i) & property2.ALT[1].getWord(i) & mask);
            }
        }
        if (N == 0) {
            return false;
        }
        float P_11 = (float)N_11 / (float)N;
        float P_12 = (float)N_12 / (float)N;
        float P_21 = (float)N_21 / (float)N;
        float P_22 = (float)N_22 / (float)N;
        float P_1x = P_11 + P_12;
        float P_2x = P_21 + P_22;
        float P_x1 = P_11 + P_21;
        float P_x2 = P_12 + P_22;
        float H_11 = N_11 == 0 ? 0.0f : (float)((double)P_11 * Math.log(P_11 / (P_1x * P_x1)));
        float H_12 = N_12 == 0 ? 0.0f : (float)((double)P_12 * Math.log(P_12 / (P_1x * P_x2)));
        float H_21 = N_21 == 0 ? 0.0f : (float)((double)P_21 * Math.log(P_21 / (P_2x * P_x1)));
        float H_22 = N_22 == 0 ? 0.0f : (float)((double)P_22 * Math.log(P_22 / (P_2x * P_x2)));
        float H_1x = P_1x == 0.0f ? 0.0f : (float)((double)P_1x * Math.log(P_1x));
        float H_2x = P_2x == 0.0f ? 0.0f : (float)((double)P_2x * Math.log(P_2x));
        float H_x1 = P_x1 == 0.0f ? 0.0f : (float)((double)P_x1 * Math.log(P_x1));
        float H_x2 = P_x2 == 0.0f ? 0.0f : (float)((double)P_x2 * Math.log(P_x2));
        float H_V1 = -(H_1x + H_2x);
        float H_V2 = -(H_x1 + H_x2);
        float MI = H_11 + H_12 + H_21 + H_22;
        float NMI = MI / Math.max(H_V1, H_V2);
        if (Float.isNaN(minAssoc) || NMI >= minAssoc) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("MI", (Object)Float.valueOf(MI));
            record.set("NMI", (Object)Float.valueOf(NMI));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Entropy LD (MI)";
    }

    static {
        SCORE = ((FieldGroupMeta)new FieldGroupMeta(null).addFields((Iterable)COORDINATE)).addField("MI", FieldType.float32).addField("NMI", FieldType.float32).asUnmodifiable();
    }
}

