/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.linkagedisequilibrium;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.ILDModel;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.LDProperty;

public enum GenotypeLD implements ILDModel
{
    INSTANCE;

    public static final IFieldCollection SCORE;

    @Override
    public IRecord apply(Variant variant1, Variant variant2) {
        Record record = new Record(SCORE);
        if (!this.apply(variant1, variant2, Float.NaN, record)) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("R", (Object)Float.valueOf(Float.NaN));
            record.set("R^2", (Object)Float.valueOf(Float.NaN));
        }
        return record;
    }

    @Override
    public boolean apply(Variant variant1, Variant variant2, float minAssoc, IRecord record) {
        if (!Float.isNaN(minAssoc) && minAssoc > 1.0f) {
            return false;
        }
        LDProperty property1 = (LDProperty)variant1.getProperty(LDProperty.class.getName());
        LDProperty property2 = (LDProperty)variant2.getProperty(LDProperty.class.getName());
        if (property1 == null || !property1.isLoadFrom(variant1)) {
            property1 = new LDProperty(variant1);
            variant1.setProperty(LDProperty.class.getName(), property1);
        }
        if (property2 == null || !property2.isLoadFrom(variant2)) {
            property2 = new LDProperty(variant2);
            variant2.setProperty(LDProperty.class.getName(), property2);
        }
        int N = 0;
        int countA_N_ALLELE_NUM_EQ_1 = 0;
        int countA_N_ALLELE_NUM_EQ_2 = 0;
        int countB_N_ALLELE_NUM_EQ_1 = 0;
        int countB_N_ALLELE_NUM_EQ_2 = 0;
        int countAB_ALLELE_NUM_EQ_1_1 = 0;
        int countAB_ALLELE_NUM_EQ_1_2 = 0;
        int countAB_ALLELE_NUM_EQ_2_2 = 0;
        int start = Math.max(property1.VALID.wordStart(), property2.VALID.wordStart());
        int end = Math.min(property1.VALID.wordEnd(), property2.VALID.wordEnd());
        if (start != -1 && end != -1) {
            for (int i = start; i <= end; ++i) {
                long mask = property1.VALID.getWord(i) & property2.VALID.getWord(i);
                if (mask == 0L) continue;
                N += Long.bitCount(mask);
                long countA_N_ALLELE_NUM_EQ_1_status = (property1.ALT[0].getWord(i) ^ property1.ALT[1].getWord(i)) & mask;
                long countB_N_ALLELE_NUM_EQ_1_status = (property2.ALT[0].getWord(i) ^ property2.ALT[1].getWord(i)) & mask;
                long countA_N_ALLELE_NUM_EQ_2_status = property1.ALT[0].getWord(i) & property1.ALT[1].getWord(i) & mask;
                long countB_N_ALLELE_NUM_EQ_2_status = property2.ALT[0].getWord(i) & property2.ALT[1].getWord(i) & mask;
                countA_N_ALLELE_NUM_EQ_1 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status);
                countB_N_ALLELE_NUM_EQ_1 += Long.bitCount(countB_N_ALLELE_NUM_EQ_1_status);
                countA_N_ALLELE_NUM_EQ_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_2_status);
                countB_N_ALLELE_NUM_EQ_2 += Long.bitCount(countB_N_ALLELE_NUM_EQ_2_status);
                countAB_ALLELE_NUM_EQ_1_1 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status & countB_N_ALLELE_NUM_EQ_1_status);
                countAB_ALLELE_NUM_EQ_1_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status & countB_N_ALLELE_NUM_EQ_2_status) + Long.bitCount(countB_N_ALLELE_NUM_EQ_1_status & countA_N_ALLELE_NUM_EQ_2_status);
                countAB_ALLELE_NUM_EQ_2_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_2_status & countB_N_ALLELE_NUM_EQ_2_status);
            }
        }
        int sumAB = countAB_ALLELE_NUM_EQ_1_1 + (countAB_ALLELE_NUM_EQ_1_2 << 1) + (countAB_ALLELE_NUM_EQ_2_2 << 2);
        int sumA = countA_N_ALLELE_NUM_EQ_1 + (countA_N_ALLELE_NUM_EQ_2 << 1);
        int sumB = countB_N_ALLELE_NUM_EQ_1 + (countB_N_ALLELE_NUM_EQ_2 << 1);
        int sumA_square = countA_N_ALLELE_NUM_EQ_1 + (countA_N_ALLELE_NUM_EQ_2 << 2);
        int sumB_square = countB_N_ALLELE_NUM_EQ_1 + (countB_N_ALLELE_NUM_EQ_2 << 2);
        if (N == 0) {
            return false;
        }
        double r_numerator = (double)sumAB - (double)sumA * (double)sumB / (double)N;
        double r_denominator_square = ((double)sumA_square - (double)sumA * (double)sumA / (double)N) * ((double)sumB_square - (double)sumB * (double)sumB / (double)N);
        if (r_denominator_square == 0.0) {
            if (r_numerator == 0.0) {
                record.set("CHR1", (Object)variant1.getChromosome());
                record.set("POS1", (Object)variant1.getPosition());
                record.set("CHR2", (Object)variant2.getChromosome());
                record.set("POS2", (Object)variant2.getPosition());
                record.set("R", (Object)Float.valueOf(1.0f));
                record.set("R^2", (Object)Float.valueOf(1.0f));
                return true;
            }
            return false;
        }
        float r = (float)(r_numerator / Math.sqrt(r_denominator_square));
        float r2 = r * r;
        if (Float.isNaN(minAssoc) || r2 >= minAssoc) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("R", (Object)Float.valueOf(r));
            record.set("R^2", (Object)Float.valueOf(r2));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Genotype LD (Pearson genotypic correlation of variants)";
    }

    static {
        SCORE = ((FieldGroupMeta)new FieldGroupMeta(null).addFields((Iterable)COORDINATE)).addField("R", FieldType.float32).addField("R^2", FieldType.float32).asUnmodifiable();
    }
}

