/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.linkagedisequilibrium;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.ILDModel;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.LDProperty;

public enum HaplotypeLD implements ILDModel
{
    INSTANCE;

    public static final IFieldCollection SCORE;

    @Override
    public IRecord apply(Variant variant1, Variant variant2) {
        Record record = new Record(SCORE);
        if (!this.apply(variant1, variant2, Float.NaN, record)) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("D_Prime", (Object)Float.valueOf(Float.NaN));
            record.set("R^2", (Object)Float.valueOf(Float.NaN));
        }
        return record;
    }

    @Override
    public boolean apply(Variant variant1, Variant variant2, float minAssoc, IRecord record) {
        if (!Float.isNaN(minAssoc) && minAssoc > 1.0f) {
            return false;
        }
        LDProperty property1 = (LDProperty)variant1.getProperty(LDProperty.class.getName());
        LDProperty property2 = (LDProperty)variant2.getProperty(LDProperty.class.getName());
        if (property1 == null || !property1.isLoadFrom(variant1)) {
            property1 = new LDProperty(variant1);
            variant1.setProperty(LDProperty.class.getName(), property1);
        }
        if (property2 == null || !property2.isLoadFrom(variant2)) {
            property2 = new LDProperty(variant2);
            variant2.setProperty(LDProperty.class.getName(), property2);
        }
        int N = 0;
        int N_2x = 0;
        int N_x2 = 0;
        int N_22 = 0;
        N = 0;
        N_2x = 0;
        N_x2 = 0;
        N_22 = 0;
        int start = Math.max(property1.VALID.wordStart(), property2.VALID.wordStart());
        int end = Math.min(property1.VALID.wordEnd(), property2.VALID.wordEnd());
        if (start != -1 && end != -1) {
            for (int i = start; i <= end; ++i) {
                long mask = property1.VALID.getWord(i) & property2.VALID.getWord(i);
                if (mask == 0L) continue;
                N += Long.bitCount(mask) << 1;
                N_2x += Long.bitCount(property1.ALT[0].getWord(i) & mask) + Long.bitCount(property1.ALT[1].getWord(i) & mask);
                N_x2 += Long.bitCount(property2.ALT[0].getWord(i) & mask) + Long.bitCount(property2.ALT[1].getWord(i) & mask);
                N_22 += Long.bitCount(property1.ALT[0].getWord(i) & property2.ALT[0].getWord(i) & mask) + Long.bitCount(property1.ALT[1].getWord(i) & property2.ALT[1].getWord(i) & mask);
            }
        }
        if (N == 0 || N_2x == 0 || N_x2 == 0 || N == N_2x || N == N_x2) {
            return false;
        }
        float P_2x = (float)N_2x / (float)N;
        float P_x2 = (float)N_x2 / (float)N;
        float P_1x = 1.0f - P_2x;
        float P_x1 = 1.0f - P_x2;
        float P_22 = (float)N_22 / (float)N;
        float D = P_22 - P_2x * P_x2;
        float DPrime = D > 0.0f ? D / Math.min(P_1x * P_x2, P_2x * P_x1) : D / Math.max(-P_1x * P_x1, -P_2x * P_x2);
        float r2 = D * D / (P_2x * P_x2 * P_1x * P_x1);
        if (Float.isNaN(minAssoc) || r2 >= minAssoc) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("D_Prime", (Object)Float.valueOf(DPrime));
            record.set("R^2", (Object)Float.valueOf(r2));
            return true;
        }
        return false;
    }

    public String toString() {
        return "Haplotype LD";
    }

    static {
        SCORE = ((FieldGroupMeta)new FieldGroupMeta(null).addFields((Iterable)COORDINATE)).addField("D_Prime", FieldType.float32).addField("R^2", FieldType.float32).asUnmodifiable();
    }
}

