/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.linkagedisequilibrium;

import edu.sysu.pmglab.container.bits.LongBits;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.BitwiseGenotypes;

public class LDProperty {
    BitwiseGenotypes bits;
    LongBits VALID;
    LongBits[] REF;
    LongBits[] ALT;
    Variant source;

    public LDProperty(Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException("null variant");
        }
        this.source = variant;
        this.bits = new BitwiseGenotypes(variant.getGenotypes(), 2, BitwiseGenotypes.BIALLELIC);
        this.VALID = this.bits.getBits(0, -1);
        this.REF = new LongBits[]{this.bits.getBits(0, 0), this.bits.getBits(1, 0)};
        this.ALT = new LongBits[]{this.bits.getBits(0, 1), this.bits.getBits(1, 1)};
    }

    public LDProperty(int size) {
        this.bits = new BitwiseGenotypes(size, 2, BitwiseGenotypes.BIALLELIC);
        this.VALID = this.bits.getBits(0, -1);
        this.REF = new LongBits[]{this.bits.getBits(0, 0), this.bits.getBits(1, 0)};
        this.ALT = new LongBits[]{this.bits.getBits(0, 1), this.bits.getBits(1, 1)};
    }

    public boolean isLoadFrom(Variant source2) {
        return this.source == source2;
    }

    public LDProperty reload(Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException("null variant");
        }
        if (this.source == variant) {
            return this;
        }
        this.source = variant;
        this.bits = this.bits.reload(variant.getGenotypes());
        this.VALID = this.bits.getBits(0, -1);
        this.REF = new LongBits[]{this.bits.getBits(0, 0), this.bits.getBits(1, 0)};
        this.ALT = new LongBits[]{this.bits.getBits(0, 1), this.bits.getBits(1, 1)};
        return this;
    }

    public BitwiseGenotypes getBits() {
        return this.bits;
    }

    public int length() {
        return this.VALID.nWords();
    }
}

