/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucketFlusher;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.Indexer;
import edu.sysu.pmglab.ccf.toolkit.listener.IListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class GTBIndexer {
    private static final CCFLoader LOADER = new CCFLoader(List.wrap(new CCFChunk.Type[]{CCFChunk.Type.FIELD_GROUP_META, CCFChunk.Type.FIELD_GROUP_DATA}).toSet(), group -> group.groupName() == null);
    private static final Function<BoxRecord, Chromosome> DEFAULT_CHROMOSOME_GETTER = record -> (Chromosome)record.get("CHROM");
    private static final ToIntFunction<BoxRecord> DEFAULT_POS_GETTER = record -> {
        VarInt32Box box = (VarInt32Box)record.getBox("POS");
        return box.intValue();
    };
    final ReaderOption input;
    final IFieldType tagType = FieldType.chromosome;
    final IFieldType valueType = FieldType.varInt32;
    Function<BoxRecord, Chromosome> chromosomeGetter = DEFAULT_CHROMOSOME_GETTER;
    ToIntFunction<BoxRecord> posGetter = DEFAULT_POS_GETTER;
    IntBucketFlusher flusher;
    IListener<ReaderOption, Void> listener = IListener.EMPTY;

    private GTBIndexer(ReaderOption input) {
        this.input = input;
    }

    public static GTBIndexer setInput(ReaderOption input) {
        return new GTBIndexer(input);
    }

    public static GTBIndexer setInput(String file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBIndexer(new ReaderOption(LOADER.parse(file), "CHROM", "POS"));
        }
        return new GTBIndexer(new ReaderOption(file, fields));
    }

    public static GTBIndexer setInput(File file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBIndexer(new ReaderOption(LOADER.parse(file), "CHROM", "POS"));
        }
        return new GTBIndexer(new ReaderOption(file, fields));
    }

    public static GTBIndexer setInput(LiveFile file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBIndexer(new ReaderOption(LOADER.parse(file), "CHROM", "POS"));
        }
        return new GTBIndexer(new ReaderOption(file, fields));
    }

    public static GTBIndexer setInput(CCFTable table, String ... fields) {
        if (fields.length == 0) {
            return new GTBIndexer(new ReaderOption(table, "CHROM", "POS"));
        }
        return new GTBIndexer(new ReaderOption(table, fields));
    }

    public static GTBIndexer setInput(GTBManager table, String ... fields) {
        if (fields.length == 0) {
            return new GTBIndexer(new ReaderOption(table.getTable(), "CHROM", "POS"));
        }
        return new GTBIndexer(new ReaderOption(table.getTable(), fields));
    }

    public GTBIndexer buildBucketIf(IntBucketFlusher flusher) {
        this.flusher = flusher;
        return this;
    }

    public GTBIndexer setListener(IListener<ReaderOption, Void> listener) {
        this.listener = listener == null ? IListener.EMPTY : listener;
        return this;
    }

    public GTBIndexer getPositionFrom(ToIntFunction<BoxRecord> posGetter) {
        this.posGetter = posGetter == null ? DEFAULT_POS_GETTER : posGetter;
        return this;
    }

    public GTBIndexer getChromosomeFrom(Function<BoxRecord, Chromosome> chromGetter) {
        this.chromosomeGetter = chromGetter == null ? DEFAULT_CHROMOSOME_GETTER : chromGetter;
        return this;
    }

    public CCFIntIndexer<Chromosome> build(int threads) throws IOException {
        return Indexer.setInput(this.input).getTagFrom(this.chromosomeGetter, this.tagType).getIntValueFrom(this.posGetter).buildBucketIf(this.flusher).setListener(this.listener).build(threads);
    }

    public CCFIntIndexer<Chromosome> save(int threads) throws IOException {
        return Indexer.setInput(this.input).getTagFrom(this.chromosomeGetter, this.tagType).getIntValueFrom(this.posGetter).buildBucketIf(this.flusher).setListener(this.listener).save("INDEXER", threads);
    }
}

