/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.gtb.GTBCoordinateReader;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.GTBWriter;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.filter.GTBFilter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LargeGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.progressbar.ProgressBar;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class GTBMerger {
    final GTBManager majorManager;
    final CCFIntIndexer<Chromosome> majorIndexer;
    final IndexableSet<String> majorIndividuals;
    final GTBManager minorManager;
    final CCFIntIndexer<Chromosome> minorIndexer;
    final IndexableSet<String> minorIndividuals;
    final File output;
    final ICCFMeta meta = new CCFMeta();
    final ICCFOptions options = new CCFOptions();
    ILiteConverter<Variant, List<Variant>> converter = List::singleton;

    private GTBMerger(GTBManager majorManager, IndexableSet<String> majorIndividuals, GTBManager minorManager, IndexableSet<String> minorIndividuals, File output) throws IOException {
        this.majorManager = majorManager;
        this.majorIndividuals = majorIndividuals;
        this.minorManager = minorManager;
        this.minorIndividuals = minorIndividuals;
        this.output = output;
        this.majorIndexer = this.majorManager.getIndexer(true, null);
        this.minorIndexer = this.minorManager.getIndexer(true, null);
        if (!this.majorIndexer.isOrdered() || !this.majorIndexer.isCompact()) {
            throw new UnsupportedOperationException("Major GTB file must be coordinate-ordered and compact");
        }
        if (!this.minorIndexer.isOrdered() || !this.minorIndexer.isCompact()) {
            throw new UnsupportedOperationException("Minor GTB file must be coordinate-ordered and compact");
        }
    }

    public static InputSetting setMajorManager(String major, Iterable<String> majorIndividuals) throws IOException {
        return new InputSetting(new GTBManager(major), majorIndividuals);
    }

    public static InputSetting setMajorManager(File major, Iterable<String> majorIndividuals) throws IOException {
        return new InputSetting(new GTBManager(major), majorIndividuals);
    }

    public static InputSetting setMajorManager(LiveFile major, Iterable<String> majorIndividuals) throws IOException {
        return new InputSetting(new GTBManager(major), majorIndividuals);
    }

    public static InputSetting setMajorManager(CCFTable major, Iterable<String> majorIndividuals) {
        return new InputSetting(new GTBManager(major), majorIndividuals);
    }

    public static InputSetting setMajorManager(GTBManager major, Iterable<String> majorIndividuals) {
        return new InputSetting(major, majorIndividuals);
    }

    public static void main(String[] args) throws IOException {
        ProgressBar bar = new ProgressBar.Builder().build();
        GTBMerger.setMajorManager(new GTBManager("/Users/suranyi/Desktop/ukbb/chr1.hg38.gtb"), null).setMinorManager(new GTBManager("/Users/suranyi/project/ccf-v4/out.gtb"), null).setOutput(new File("temp.gtb")).setConverter(input -> {
            bar.step(1L);
            return List.singleton(input);
        }).alignToMajor(8);
        bar.close();
    }

    public GTBMerger addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public GTBMerger addMeta(Iterable<CCFMetaItem> metas) {
        this.meta.adds(metas);
        return this;
    }

    public GTBMerger clearMeta() {
        this.meta.clear();
        return this;
    }

    public GTBMerger addOption(CCFMetaItem option) {
        this.options.add(option);
        return this;
    }

    public GTBMerger addOptions(Iterable<CCFMetaItem> options) {
        this.options.adds(options);
        return this;
    }

    public GTBMerger clearOptions() {
        this.options.clear();
        return this;
    }

    public GTBMerger dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public GTBMerger setConverter(ILiteConverter<Variant, List<Variant>> converter) {
        if (converter != null) {
            this.converter = converter;
        }
        return this;
    }

    public void union(int nThreads) throws IOException {
        HashSet<Chromosome> chromosomes = new HashSet<Chromosome>();
        chromosomes.addAll(this.majorIndexer.getTags());
        chromosomes.addAll(this.minorIndexer.getTags());
        GTBWriter writers = GTBWriter.setOutput(RuntimeProperty.createTempFile()).instance(chromosomes.size());
        try (ThreadQueue queue = new ThreadQueue(nThreads);){
            AtomicInteger indexer = new AtomicInteger(0);
            for (Chromosome chromosome : chromosomes) {
                queue.addTask((status, context) -> {
                    int index = indexer.getAndIncrement();
                    if (!this.majorIndexer.containsTag(chromosome)) {
                        Coordinate coordinate;
                        GTBCoordinateReader minorReader = new GTBCoordinateReader(this.minorManager, true).limit(this.minorIndexer.getTag(chromosome).getRecordIndexRange());
                        while ((coordinate = minorReader.read()) != null) {
                            writers.write(index, coordinate);
                        }
                        minorReader.close();
                    } else if (!this.minorIndexer.containsTag(chromosome)) {
                        Coordinate coordinate;
                        GTBCoordinateReader majorReader = new GTBCoordinateReader(this.majorManager, true).limit(this.majorIndexer.getTag(chromosome).getRecordIndexRange());
                        while ((coordinate = majorReader.read()) != null) {
                            writers.write(index, coordinate);
                        }
                        majorReader.close();
                    } else {
                        GTBCoordinateReader majorReader = new GTBCoordinateReader(this.majorManager, true).limit(this.majorIndexer.getTag(chromosome).getRecordIndexRange());
                        GTBCoordinateReader minorReader = new GTBCoordinateReader(this.minorManager, true).limit(this.minorIndexer.getTag(chromosome).getRecordIndexRange());
                        Coordinate majorCoordinate = majorReader.read();
                        Coordinate minorCoordinate = minorReader.read();
                        while (true) {
                            if (minorCoordinate == null) {
                                if (majorCoordinate == null) break;
                                do {
                                    writers.write(index, majorCoordinate);
                                } while ((majorCoordinate = majorReader.read()) != null);
                                continue;
                            }
                            if (majorCoordinate == null) {
                                do {
                                    writers.write(index, minorCoordinate);
                                } while ((minorCoordinate = minorReader.read()) != null);
                                continue;
                            }
                            if (minorCoordinate.compareTo(majorCoordinate) < 0) {
                                writers.write(index, minorCoordinate);
                                minorCoordinate = minorReader.read();
                                continue;
                            }
                            if (minorCoordinate.compareTo(majorCoordinate) == 0) {
                                writers.write(index, minorCoordinate);
                                minorCoordinate = minorReader.read();
                                majorCoordinate = majorReader.read();
                                continue;
                            }
                            writers.write(index, majorCoordinate);
                            majorCoordinate = majorReader.read();
                        }
                        minorReader.close();
                        majorReader.close();
                    }
                    writers.finish(index);
                });
            }
        }
        writers.close();
        this.doMerge(new GTBManager(writers.getFile()), nThreads);
    }

    public void intersect(int nThreads) throws IOException {
        HashSet<Chromosome> chromosomes = new HashSet<Chromosome>();
        for (Chromosome chromosome : this.majorIndexer.getTags()) {
            RefinedIntBuckets minorBuckets;
            RefinedIntBuckets majorBuckets;
            if (!this.minorIndexer.containsTag(chromosome) || !(majorBuckets = this.majorIndexer.getTag(chromosome)).overlaps((minorBuckets = this.minorIndexer.getTag(chromosome)).getMinValue(), minorBuckets.getMaxValue())) continue;
            chromosomes.add(chromosome);
        }
        GTBWriter writers = GTBWriter.setOutput(RuntimeProperty.createTempFile()).instance(chromosomes.size());
        try (ThreadQueue queue = new ThreadQueue(nThreads);){
            AtomicInteger indexer = new AtomicInteger(0);
            for (Chromosome chromosome : chromosomes) {
                queue.addTask((status, context) -> {
                    int index = indexer.getAndIncrement();
                    GTBCoordinateReader majorReader = new GTBCoordinateReader(this.majorManager, true).limit(this.majorIndexer.getTag(chromosome).getRecordIndexRange());
                    GTBCoordinateReader minorReader = new GTBCoordinateReader(this.minorManager, true).limit(this.minorIndexer.getTag(chromosome).getRecordIndexRange());
                    Coordinate majorCoordinate = majorReader.read();
                    Coordinate minorCoordinate = minorReader.read();
                    while (minorCoordinate != null && majorCoordinate != null) {
                        if (minorCoordinate.compareTo(majorCoordinate) < 0) {
                            minorCoordinate = minorReader.read();
                            continue;
                        }
                        if (minorCoordinate.compareTo(majorCoordinate) == 0) {
                            writers.write(index, minorCoordinate);
                            minorCoordinate = minorReader.read();
                            majorCoordinate = majorReader.read();
                            continue;
                        }
                        majorCoordinate = majorReader.read();
                    }
                    minorReader.close();
                    majorReader.close();
                    writers.finish(index);
                });
            }
        }
        writers.close();
        this.doMerge(new GTBManager(writers.getFile()), nThreads);
    }

    public void alignToMajor(int nThreads) throws IOException {
        this.doMerge(this.majorManager, nThreads);
    }

    public void alignToMinor(int nThreads) throws IOException {
        this.doMerge(this.minorManager, nThreads);
    }

    private void doMerge(GTBManager coordinates, int threads) throws IOException {
        threads = RuntimeProperty.verifyThreads(threads);
        GTBWriter writers = GTBWriter.setOutput(this.output).addIndividuals(this.majorIndividuals).addIndividuals(this.minorIndividuals).instance(threads);
        Masker masker = new Masker(this.majorManager.getIndividuals(), this.majorIndividuals, this.minorManager.getIndividuals(), this.minorIndividuals, writers.getIndividuals());
        List<GTBCoordinateReader> readers = new GTBCoordinateReader(coordinates, true).part(threads);
        try (ThreadQueue queue = new ThreadQueue(threads);){
            AtomicInteger indexer = new AtomicInteger(0);
            for (GTBCoordinateReader reader : readers) {
                int index = indexer.getAndIncrement();
                queue.addTask((status, context) -> {
                    Coordinate coordinate;
                    GTBReader minorReader = new GTBReader(new GTBReaderOption(this.minorManager, true, false));
                    GTBFilter minorFilter = new GTBFilter(this.minorManager);
                    GTBReader majorReader = new GTBReader(new GTBReaderOption(this.majorManager, true, false));
                    GTBFilter majorFilter = new GTBFilter(this.majorManager);
                    List<Object> majorVariants = null;
                    List<Object> minorVariants = null;
                    LargeGenotypes phasedGenotypes = null;
                    LargeGenotypes unphasedGenotypes = null;
                    while ((coordinate = reader.read()) != null) {
                        if (majorFilter.find(coordinate)) {
                            majorReader.seek(majorFilter.tell());
                            majorVariants = majorReader.reads().filter(variant -> {
                                masker.maskMajorVariant((Variant)variant);
                                return variant.getGenotypes().counter().getAN() >= 1 && variant.numOfAlleles() >= 1;
                            });
                            if (majorVariants.size() > 1) {
                                majorVariants = Variant.join(majorVariants);
                            }
                        } else {
                            majorVariants = List.EMPTY();
                        }
                        if (minorFilter.find(coordinate)) {
                            minorReader.seek(minorFilter.tell());
                            minorVariants = minorReader.reads().filter(variant -> {
                                masker.maskMinorVariant((Variant)variant);
                                return variant.getGenotypes().counter().getAN() >= 1 && variant.numOfAlleles() >= 1;
                            });
                            if (minorVariants.size() > 1) {
                                minorVariants = Variant.join(minorVariants);
                            }
                        } else {
                            minorVariants = List.EMPTY();
                        }
                        for (Variant variant2 : majorVariants) {
                            boolean merge = false;
                            for (int i = 0; i < minorVariants.size(); ++i) {
                                Variant minorVariant = (Variant)minorVariants.get(i);
                                if (minorVariant == null || !variant2.alleleOfIndex(0).equals(minorVariant.alleleOfIndex(0))) continue;
                                merge = true;
                                variant2.addAlleles(minorVariant.getAlleles());
                                int[] alleleIndexes = new int[minorVariant.numOfAlleles() + 1];
                                alleleIndexes[0] = -1;
                                for (int j = 0; j < minorVariant.numOfAlleles(); ++j) {
                                    alleleIndexes[j + 1] = variant2.indexOfAllele(minorVariant.alleleOfIndex(j));
                                }
                                minorVariant.setGenotypes(minorVariant.getGenotypes().map(alleleIndexes));
                                if (variant2.getGenotypes().isPhased() && minorVariant.getGenotypes().isPhased()) {
                                    if (phasedGenotypes == null) {
                                        phasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), true);
                                    }
                                    variant2.setGenotypes(masker.fill(variant2.getGenotypes(), minorVariant.getGenotypes(), phasedGenotypes));
                                } else {
                                    if (unphasedGenotypes == null) {
                                        unphasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), false);
                                    }
                                    variant2.setGenotypes(masker.fill(variant2.getGenotypes(), minorVariant.getGenotypes(), unphasedGenotypes));
                                }
                                for (Variant variant22 : this.converter.converter(variant2)) {
                                    writers.write(index, variant2);
                                }
                                minorVariants.set(i, (Object)null);
                                break;
                            }
                            if (merge) continue;
                            if (variant2.getGenotypes().isPhased()) {
                                if (phasedGenotypes == null) {
                                    phasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), true);
                                }
                                variant2.setGenotypes(masker.fill(variant2.getGenotypes(), null, phasedGenotypes));
                            } else {
                                if (unphasedGenotypes == null) {
                                    unphasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), false);
                                }
                                variant2.setGenotypes(masker.fill(variant2.getGenotypes(), null, unphasedGenotypes));
                            }
                            for (Variant variant3 : this.converter.converter(variant2)) {
                                writers.write(index, variant2);
                            }
                        }
                        for (Variant variant3 : minorVariants) {
                            if (variant3 == null) continue;
                            if (variant3.getGenotypes().isPhased()) {
                                if (phasedGenotypes == null) {
                                    phasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), true);
                                }
                                variant3.setGenotypes(masker.fill(null, variant3.getGenotypes(), phasedGenotypes));
                            } else {
                                if (unphasedGenotypes == null) {
                                    unphasedGenotypes = new LargeGenotypes(writers.numOfIndividuals(), false);
                                }
                                variant3.setGenotypes(masker.fill(null, variant3.getGenotypes(), unphasedGenotypes));
                            }
                            for (Variant variant4 : this.converter.converter(variant3)) {
                                writers.write(index, variant3);
                            }
                        }
                    }
                    minorFilter.close();
                    minorReader.close();
                    majorFilter.close();
                    majorReader.close();
                    reader.close();
                });
            }
        }
        writers.addMeta(this.meta);
        writers.addOptions(this.options);
        writers.close();
    }

    public static class OutputSetting {
        final GTBManager majorManager;
        final IndexableSet<String> majorIndividuals;
        final GTBManager minorManager;
        final IndexableSet<String> minorIndividuals;

        public OutputSetting(GTBManager majorManager, IndexableSet<String> majorIndividuals, GTBManager minorManager, IndexableSet<String> minorIndividuals) {
            this.majorManager = majorManager;
            this.majorIndividuals = majorIndividuals;
            this.minorManager = minorManager;
            this.minorIndividuals = minorIndividuals;
        }

        public GTBMerger setOutput(String output) throws IOException {
            return new GTBMerger(this.majorManager, this.majorIndividuals, this.minorManager, this.minorIndividuals, new File(output));
        }

        public GTBMerger setOutput(File output) throws IOException {
            return new GTBMerger(this.majorManager, this.majorIndividuals, this.minorManager, this.minorIndividuals, output);
        }
    }

    public static class InputSetting {
        final GTBManager majorManager;
        final IndexableSet<String> majorIndividuals;

        private InputSetting(GTBManager major, Iterable<String> individuals) {
            this.majorManager = major;
            if (individuals != null) {
                if (individuals == major.getIndividuals()) {
                    this.majorIndividuals = major.getIndividuals();
                } else {
                    LinkedSet collection = new LinkedSet();
                    for (String individual : individuals) {
                        if (!VCFHeader.isValidIndividual(individual)) {
                            throw new InvalidIndividualException("Invalid individual: " + individual);
                        }
                        if (((IndexableSet)collection).contains(individual)) {
                            throw new InvalidIndividualException("Duplicated individual: " + individual);
                        }
                        ((AbstractCollection)collection).add(individual);
                    }
                    this.majorIndividuals = collection.asUnmodifiable();
                }
            } else {
                this.majorIndividuals = this.majorManager.getIndividuals();
            }
        }

        public OutputSetting setMinorManager(String input, Iterable<String> individuals) throws IOException {
            return this.setMinorManager(new GTBManager(input), individuals);
        }

        public OutputSetting setMinorManager(File input, Iterable<String> individuals) throws IOException {
            return this.setMinorManager(new GTBManager(input), individuals);
        }

        public OutputSetting setMinorManager(LiveFile input, Iterable<String> individuals) throws IOException {
            return this.setMinorManager(new GTBManager(input), individuals);
        }

        public OutputSetting setMinorManager(CCFTable input, Iterable<String> individuals) {
            return this.setMinorManager(new GTBManager(input), individuals);
        }

        public OutputSetting setMinorManager(GTBManager minorManager, Iterable<String> individuals) {
            IndexableSet<String> minorIndividuals;
            if (individuals != null) {
                if (individuals == minorManager.getIndividuals() && !minorManager.getIndividuals().hasOverlaps(this.majorIndividuals)) {
                    minorIndividuals = minorManager.getIndividuals();
                } else {
                    LinkedSet collection = new LinkedSet();
                    for (String individual : individuals) {
                        if (!VCFHeader.isValidIndividual(individual)) {
                            throw new InvalidIndividualException("Invalid individual: " + individual);
                        }
                        if (((IndexableSet)collection).contains(individual)) {
                            throw new InvalidIndividualException("Duplicated individual: " + individual);
                        }
                        ((AbstractCollection)collection).add(individual);
                    }
                    minorIndividuals = collection.asUnmodifiable();
                }
            } else {
                minorIndividuals = minorManager.getIndividuals();
            }
            return new OutputSetting(this.majorManager, this.majorIndividuals, minorManager, minorIndividuals);
        }
    }

    private static class Masker {
        final IntList majorMasker;
        final IntList minorMasker;
        final int[] majorFiller;
        final int[] minorFiller;

        Masker(IndexableSet<String> majorIndividuals, IndexableSet<String> majorSubsetIndividuals, IndexableSet<String> minorIndividuals, IndexableSet<String> minorSubsetIndividuals, IndexableSet<String> target) {
            int i;
            this.majorMasker = majorSubsetIndividuals.findIndicesIn(majorIndividuals);
            this.minorMasker = minorSubsetIndividuals.findIndicesIn(minorIndividuals);
            this.majorFiller = new int[majorSubsetIndividuals.size()];
            this.minorFiller = new int[minorSubsetIndividuals.size()];
            for (i = 0; i < this.majorFiller.length; ++i) {
                this.majorFiller[i] = target.indexOf(majorSubsetIndividuals.valueOf(i));
            }
            for (i = 0; i < this.minorFiller.length; ++i) {
                this.minorFiller[i] = target.indexOf(minorSubsetIndividuals.valueOf(i));
            }
        }

        Variant maskMajorVariant(Variant major) {
            major.setGenotypes(major.getGenotypes().subGenotypes(this.majorMasker));
            return major;
        }

        Variant maskMinorVariant(Variant minor) {
            minor.setGenotypes(minor.getGenotypes().subGenotypes(this.minorMasker));
            return minor;
        }

        IGenotypes fill(IGenotypes major, IGenotypes minor, LargeGenotypes target) {
            int i;
            target.clear();
            if (major != null) {
                for (i = 0; i < this.majorFiller.length; ++i) {
                    target.set(this.majorFiller[i], major.get(i));
                }
            }
            if (minor != null) {
                for (i = 0; i < this.minorFiller.length; ++i) {
                    target.set(this.minorFiller[i], minor.get(i));
                }
            }
            return target;
        }
    }
}

