/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.Sorter;
import edu.sysu.pmglab.ccf.toolkit.listener.ISortListener;
import edu.sysu.pmglab.ccf.toolkit.output.CCFOutputOption;
import edu.sysu.pmglab.ccf.toolkit.output.OutputOption;
import edu.sysu.pmglab.ccf.type.basic.VarInt32Box;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.function.TIntFunction;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class GTBSorter {
    private static final Function<BoxRecord, Chromosome> DEFAULT_CHROMOSOME_GETTER = record -> (Chromosome)record.get(null, "CHROM");
    private static final ToIntFunction<BoxRecord> DEFAULT_POS_GETTER = record -> {
        VarInt32Box box = (VarInt32Box)record.getBox(null, "POS");
        return box.intValue();
    };
    final ReaderOption input;
    Function<BoxRecord, Chromosome> chromosomeGetter = DEFAULT_CHROMOSOME_GETTER;
    ToIntFunction<BoxRecord> posGetter = DEFAULT_POS_GETTER;
    int maxRefinedBucketSize = 0x200000;
    int minRefinedBucketSize = 1024;
    int bufferSize = 65536;
    TIntFunction projection = value -> value;
    ISortListener<ReaderOption, OutputOption<IRecord, ?>> listener = ISortListener.EMPTY;

    private GTBSorter(ReaderOption input) {
        this.input = input;
    }

    public static GTBSorter setInput(ReaderOption input) {
        return new GTBSorter(input);
    }

    public static GTBSorter setInput(String file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBSorter(new ReaderOption(file, "CHROM", "POS"));
        }
        return new GTBSorter(new ReaderOption(file, fields));
    }

    public static GTBSorter setInput(File file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBSorter(new ReaderOption(file, "CHROM", "POS"));
        }
        return new GTBSorter(new ReaderOption(file, fields));
    }

    public static GTBSorter setInput(LiveFile file, String ... fields) throws IOException {
        if (fields.length == 0) {
            return new GTBSorter(new ReaderOption(file, "CHROM", "POS"));
        }
        return new GTBSorter(new ReaderOption(file, fields));
    }

    public static GTBSorter setInput(CCFTable table, String ... fields) {
        if (fields.length == 0) {
            return new GTBSorter(new ReaderOption(table, "CHROM", "POS"));
        }
        return new GTBSorter(new ReaderOption(table, fields));
    }

    public static GTBSorter setInput(GTBManager table) {
        return new GTBSorter(new ReaderOption(table.getTable(), "CHROM", "POS"));
    }

    public GTBSorter setMinRefinedBucketSize(int size) {
        this.minRefinedBucketSize = ValueUtils.valueOf(size, 2, 0x10000000);
        return this;
    }

    public GTBSorter setMaxRefinedBucketSize(int size) {
        this.maxRefinedBucketSize = ValueUtils.valueOf(size, 128, 0x10000000);
        return this;
    }

    public GTBSorter setBufferSize(int size) {
        this.bufferSize = ValueUtils.valueOf(size, 64, 0x10000000);
        return this;
    }

    public GTBSorter projectValue(TIntFunction projection) {
        this.projection = projection == null ? value -> value : projection;
        return this;
    }

    public GTBSorter setListener(ISortListener<ReaderOption, OutputOption<IRecord, ?>> listener) {
        this.listener = listener == null ? ISortListener.EMPTY : listener;
        return this;
    }

    public GTBSorter getPositionFrom(ToIntFunction<BoxRecord> posGetter) {
        this.posGetter = posGetter == null ? DEFAULT_POS_GETTER : posGetter;
        return this;
    }

    public GTBSorter getChromosomeFrom(Function<BoxRecord, Chromosome> chromGetter) {
        this.chromosomeGetter = chromGetter == null ? DEFAULT_CHROMOSOME_GETTER : chromGetter;
        return this;
    }

    public boolean isOrdered(int threads) throws IOException {
        return Sorter.setInput(this.input).getTagFrom(this.chromosomeGetter).getIntValueFrom(this.posGetter).projectValue(this.projection).setBufferSize(this.bufferSize).setMinBucketSize(this.minRefinedBucketSize).setMaxBucketSize(this.maxRefinedBucketSize).setListener(this.listener).isOrdered(threads);
    }

    public void sort(String output, int threads, boolean memorySort) throws IOException {
        this.sort(new File(output), threads, memorySort);
    }

    public void sort(File output, int threads, boolean memorySort) throws IOException {
        Sorter.IntSorterSetting<ReaderOption, Chromosome> sorter = Sorter.setInput(this.input).getTagFrom(this.chromosomeGetter).getIntValueFrom(this.posGetter).projectValue(this.projection).setBufferSize(this.bufferSize).setMinBucketSize(this.minRefinedBucketSize).setMaxBucketSize(this.maxRefinedBucketSize).setListener(this.listener);
        if (memorySort) {
            sorter.memorySort(new CCFOutputOption(output).addFields(this.input.getTable().getAllFields()).addMeta(this.input.getTable().getMeta()).addOptions(this.input.getTable().getOptions().filter(item -> !item.getKey().equals("INDEXER"))), threads);
        } else {
            sorter.bucketSort(new CCFOutputOption(output).addFields(this.input.getTable().getAllFields()).addMeta(this.input.getTable().getMeta()).addOptions(this.input.getTable().getOptions().filter(item -> !item.getKey().equals("INDEXER"))), threads);
        }
    }

    public void sort(CCFOutputOption output, int threads, boolean memorySort) throws IOException {
        Sorter.IntSorterSetting<ReaderOption, Chromosome> sorter = Sorter.setInput(this.input).getTagFrom(this.chromosomeGetter).getIntValueFrom(this.posGetter).projectValue(this.projection).setBufferSize(this.bufferSize).setMinBucketSize(this.minRefinedBucketSize).setMaxBucketSize(this.maxRefinedBucketSize).setListener(this.listener);
        if (memorySort) {
            sorter.memorySort(output, threads);
        } else {
            sorter.bucketSort(output, threads);
        }
    }

    public GTBIndexer index() throws IOException {
        return GTBIndexer.setInput(this.input);
    }
}

