/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class CADD
extends GTBDatabase {
    public CADD(String option) throws IOException {
        super(option);
    }

    public CADD(File option) throws IOException {
        super(option);
    }

    public CADD(LiveFile option) throws IOException {
        super(option);
    }

    public CADD(CCFTable option) throws IOException {
        super(option);
    }

    public CADD(GTBManager option) throws IOException {
        super(option);
    }

    public CADD(GTBReaderOption option) {
        super(option);
    }

    public CADD(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        super(option, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    @Override
    public String getDatabaseName() {
        return "CADD";
    }

    public static class OutputSetting {
        final LiveFile input;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E1", FieldType.float16), "cHmm_E1"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E2", FieldType.float16), "cHmm_E2"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E3", FieldType.float16), "cHmm_E3"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E4", FieldType.float16), "cHmm_E4"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E5", FieldType.float16), "cHmm_E5"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E6", FieldType.float16), "cHmm_E6"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E7", FieldType.float16), "cHmm_E7"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E8", FieldType.float16), "cHmm_E8"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E9", FieldType.float16), "cHmm_E9"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E10", FieldType.float16), "cHmm_E10"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E11", FieldType.float16), "cHmm_E11"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E12", FieldType.float16), "cHmm_E12"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E13", FieldType.float16), "cHmm_E13"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E14", FieldType.float16), "cHmm_E14"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E15", FieldType.float16), "cHmm_E15"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E16", FieldType.float16), "cHmm_E16"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E17", FieldType.float16), "cHmm_E17"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E18", FieldType.float16), "cHmm_E18"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E19", FieldType.float16), "cHmm_E19"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E20", FieldType.float16), "cHmm_E20"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E21", FieldType.float16), "cHmm_E21"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E22", FieldType.float16), "cHmm_E22"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E23", FieldType.float16), "cHmm_E23"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E24", FieldType.float16), "cHmm_E24"), new DatabaseField(FieldMeta.of("ChromatinStates", "cHmm_E25", FieldType.float16), "cHmm_E25"), new DatabaseField(FieldMeta.of("Conservation", "priPhCons", FieldType.float16), "priPhCons"), new DatabaseField(FieldMeta.of("Conservation", "mamPhCons", FieldType.float16), "mamPhCons"), new DatabaseField(FieldMeta.of("Conservation", "verPhCons", FieldType.float16), "verPhCons"), new DatabaseField(FieldMeta.of("Conservation", "priPhyloP", FieldType.float16), "priPhyloP"), new DatabaseField(FieldMeta.of("Conservation", "mamPhyloP", FieldType.float16), "mamPhyloP"), new DatabaseField(FieldMeta.of("Conservation", "verPhyloP", FieldType.float16), "verPhyloP"), new DatabaseField(FieldMeta.of("Conservation", "GerpN", FieldType.float16), "GerpN"), new DatabaseField(FieldMeta.of("Conservation", "GerpS", FieldType.float16), "GerpS"), new DatabaseField(FieldMeta.of("Conservation", "GerpRS", FieldType.float16), "GerpRS"), new DatabaseField(FieldMeta.of("Conservation", "GerpRSpval", FieldType.float16), "GerpRSpval"), new DatabaseField(FieldMeta.of("Conservation", "bStatistic", FieldType.varInt32), "bStatistic").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Conservation", "ZooPriPhyloP", FieldType.float16), "ZooPriPhyloP"), new DatabaseField(FieldMeta.of("Conservation", "ZooVerPhyloP", FieldType.float16), "ZooVerPhyloP"), new DatabaseField(FieldMeta.of("Conservation", "ZooRoCC", FieldType.float16), "ZooRoCC"), new DatabaseField(FieldMeta.of("Conservation", "ZooUCE", FieldType.float16), "ZooUCE"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeDNase-max", FieldType.float16), "EncodeDNase-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeDNase-sum", FieldType.float16), "EncodeDNase-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K27ac-max", FieldType.float16), "EncodeH3K27ac-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K27ac-sum", FieldType.float16), "EncodeH3K27ac-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me1-max", FieldType.float16), "EncodeH3K4me1-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me1-sum", FieldType.float16), "EncodeH3K4me1-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me2-max", FieldType.float16), "EncodeH3K4me2-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me2-sum", FieldType.float16), "EncodeH3K4me2-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me3-max", FieldType.float16), "EncodeH3K4me3-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K4me3-sum", FieldType.float16), "EncodeH3K4me3-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K9ac-max", FieldType.float16), "EncodeH3K9ac-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K9ac-sum", FieldType.float16), "EncodeH3K9ac-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH4K20me1-max", FieldType.float16), "EncodeH4K20me1-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH4K20me1-sum", FieldType.float16), "EncodeH4K20me1-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH2AFZ-max", FieldType.float16), "EncodeH2AFZ-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH2AFZ-sum", FieldType.float16), "EncodeH2AFZ-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K9me3-max", FieldType.float16), "EncodeH3K9me3-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K9me3-sum", FieldType.float16), "EncodeH3K9me3-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K27me3-max", FieldType.float16), "EncodeH3K27me3-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K27me3-sum", FieldType.float16), "EncodeH3K27me3-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K36me3-max", FieldType.float16), "EncodeH3K36me3-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K36me3-sum", FieldType.float16), "EncodeH3K36me3-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K79me2-max", FieldType.float16), "EncodeH3K79me2-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodeH3K79me2-sum", FieldType.float16), "EncodeH3K79me2-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodetotalRNA-max", FieldType.float16), "EncodetotalRNA-max"), new DatabaseField(FieldMeta.of("Epigenetics", "EncodetotalRNA-sum", FieldType.float16), "EncodetotalRNA-sum"), new DatabaseField(FieldMeta.of("Epigenetics", "GC", FieldType.float16), "GC"), new DatabaseField(FieldMeta.of("Epigenetics", "CpG", FieldType.float16), "CpG"), new DatabaseField(FieldMeta.of("Mutability", "Freq100bp", FieldType.varInt32), "Freq100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Rare100bp", FieldType.varInt32), "Rare100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Sngl100bp", FieldType.varInt32), "Sngl100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Freq1000bp", FieldType.varInt32), "Freq1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Rare1000bp", FieldType.varInt32), "Rare1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Sngl1000bp", FieldType.varInt32), "Sngl1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Freq10000bp", FieldType.varInt32), "Freq10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Rare10000bp", FieldType.varInt32), "Rare10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Sngl10000bp", FieldType.varInt32), "Sngl10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mutability", "Roulette-MR", FieldType.float16), "Roulette-MR"), new DatabaseField(FieldMeta.of("Mutability", "Roulette-AR", FieldType.float16), "Roulette-AR"), new DatabaseField(FieldMeta.of("ProteinFunction", "SIFTval", FieldType.float16), "SIFTval"), new DatabaseField(FieldMeta.of("ProteinFunction", "PolyPhenVal", FieldType.float16), "PolyPhenVal"), new DatabaseField(FieldMeta.of("ProteinFunction", "dbscSNV-ada_score", FieldType.float16), "dbscSNV-ada_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "dbscSNV-rf_score", FieldType.float16), "dbscSNV-rf_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "Grantham", FieldType.float16), "Grantham"), new DatabaseField(FieldMeta.of("ProteinFunction", "mirSVR-Aln", FieldType.float16), "mirSVR-Aln"), new DatabaseField(FieldMeta.of("ProteinFunction", "mirSVR-E", FieldType.float16), "mirSVR-E"), new DatabaseField(FieldMeta.of("ProteinFunction", "mirSVR-Score", FieldType.float16), "mirSVR-Score"), new DatabaseField(FieldMeta.of("ProteinFunction", "MMSp_acceptor", FieldType.float16), "MMSp_acceptor"), new DatabaseField(FieldMeta.of("ProteinFunction", "MMSp_acceptorIntron", FieldType.float16), "MMSp_acceptorIntron"), new DatabaseField(FieldMeta.of("ProteinFunction", "MMSp_donor", FieldType.float16), "MMSp_donor"), new DatabaseField(FieldMeta.of("ProteinFunction", "MMSp_donorIntron", FieldType.float16), "MMSp_donorIntron"), new DatabaseField(FieldMeta.of("ProteinFunction", "MMSp_exon", FieldType.float16), "MMSp_exon"), new DatabaseField(FieldMeta.of("ProteinFunction", "SpliceAI-acc-gain", FieldType.float16), "SpliceAI-acc-gain"), new DatabaseField(FieldMeta.of("ProteinFunction", "SpliceAI-acc-loss", FieldType.float16), "SpliceAI-acc-loss"), new DatabaseField(FieldMeta.of("ProteinFunction", "SpliceAI-don-gain", FieldType.float16), "SpliceAI-don-gain"), new DatabaseField(FieldMeta.of("ProteinFunction", "SpliceAI-don-loss", FieldType.float16), "SpliceAI-don-loss"), new DatabaseField(FieldMeta.of("ProteinFunction", "CADD_RawScore", FieldType.float16), "RawScore"), new DatabaseField(FieldMeta.of("ProteinFunction", "CADD_PHRED", FieldType.float16), "PHRED"), new DatabaseField(FieldMeta.of("ProteinFunction", "Aparent2", FieldType.float16), "Aparent2"), new DatabaseField(FieldMeta.of("ProteinFunction", "EsmScoreMissense", FieldType.float16), "EsmScoreMissense"), new DatabaseField(FieldMeta.of("ProteinFunction", "EsmScoreInFrame", FieldType.float16), "EsmScoreInFrame"), new DatabaseField(FieldMeta.of("ProteinFunction", "EsmScoreFrameshift", FieldType.float16), "EsmScoreFrameshift"), new DatabaseField(FieldMeta.of("ProximityTable", "minDistTSS", FieldType.varInt32), "minDistTSS").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("ProximityTable", "minDistTSE", FieldType.varInt32), "minDistTSE").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("ProximityTable", "Dist2Mutation", FieldType.varInt32), "Dist2Mutation").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("ProximityTable", "Dst2Splice", FieldType.varInt32), "Dst2Splice").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "RemapOverlapTF", FieldType.varInt32), "RemapOverlapTF").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "RemapOverlapCL", FieldType.varInt32), "RemapOverlapCL").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "motifECount", FieldType.varInt32), "motifECount").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "motifDist", FieldType.float16), "motifDist"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "tOverlapMotifs", FieldType.float16), "tOverlapMotifs"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq0", FieldType.float16), "RegSeq0"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq1", FieldType.float16), "RegSeq1"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq2", FieldType.float16), "RegSeq2"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq3", FieldType.float16), "RegSeq3"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq4", FieldType.float16), "RegSeq4"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq5", FieldType.float16), "RegSeq5"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq6", FieldType.float16), "RegSeq6"), new DatabaseField(FieldMeta.of("RegSeq", "RegSeq7", FieldType.float16), "RegSeq7")}).asUnmodifiable();
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile input, File output) {
            this.input = input;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new TextInputOption(this.input).setHeaderParser(IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN)).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=CADD,Description=\"CADD is a tool that integrates multiple annotations into a single metric (C-score) to assess the deleteriousness of single nucleotide variants (SNVs) and insertion/deletions (InDels) in the human genome.\",Source=\"" + this.input.getPath() + "\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Variant> preVariants = new ThreadLocal();
                final Bytes NA = new Bytes("NA");
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(TextRecord input) throws IOException {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("Chrom").toString()), input.get("Pos").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate).addAllele(input.get("Ref").toString()).addAllele(input.get("Alt").toString()).setProperty(this.properties.get());
                    Variant preVariant = this.preVariants.get();
                    if (preVariant != null && variant.getCoordinate().equals(preVariant.getCoordinate()) && variant.alleleOfIndex(0).equals(preVariant.alleleOfIndex(0)) && variant.alleleOfIndex(1).equals(preVariant.alleleOfIndex(1))) {
                        return null;
                    }
                    this.preVariants.set(variant);
                    boolean anyValue = false;
                    for (DatabaseField field : FIELDS) {
                        int index = input.indexOf(field.getSource());
                        if (index == -1) continue;
                        Bytes value = input.get(index);
                        if (value.valueEquals((byte)46) || value.valueEquals(this.NA)) {
                            variant.setProperty(field.getField().fullName(), null);
                            continue;
                        }
                        anyValue = true;
                        variant.setProperty(field.getField().fullName(), value);
                    }
                    if (anyValue) {
                        return variant;
                    }
                    return null;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

