/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.SpecifiedINFOParser;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ClinVar
extends GTBDatabase {
    public ClinVar(String file) throws IOException {
        super(file);
    }

    public ClinVar(File file) throws IOException {
        super(file);
    }

    public ClinVar(LiveFile file) throws IOException {
        super(file);
    }

    public ClinVar(CCFTable file) throws IOException {
        super(file);
    }

    public ClinVar(GTBManager file) throws IOException {
        super(file);
    }

    public ClinVar(GTBReaderOption file) {
        super(file);
    }

    public ClinVar(GTBReaderOption file, IFieldCollection fields, ICCFMeta meta) {
        super(file, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    public static InputSetting buildFrom(String version, RefGenomeVersion refGenomeVersion) throws IOException {
        if (refGenomeVersion != RefGenomeVersion.hg19 && refGenomeVersion != RefGenomeVersion.hg38) {
            throw new DatabaseException("The clinvar database only provides hg19 and hg38 reference genome versions");
        }
        String webSite = refGenomeVersion == RefGenomeVersion.hg19 ? (version == null ? "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh37/weekly/clinvar.vcf.gz" : "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh37/weekly/clinvar_" + version + ".vcf.gz") : (version == null ? "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh38/weekly/clinvar.vcf.gz" : "https://ftp.ncbi.nlm.nih.gov/pub/clinvar/vcf_GRCh38/weekly/clinvar_" + version + ".vcf.gz");
        LiveFile source2 = LiveFile.of(webSite);
        return ClinVar.buildFrom(source2.copyFileTo(RuntimeProperty.createFile(source2.getName())));
    }

    @Override
    public String getDatabaseName() {
        return "ClinVar";
    }

    public static class OutputSetting {
        final LiveFile inputFile;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("ClinVar", "id", FieldType.string), "ID").addDescription("Description", "\"Clinvar variation ID.\""), new DatabaseField(FieldMeta.of("ClinVar", "clnsig", FieldType.string), "INFO::CLNSIG").addDescription("Description", "\"Clinical significance for this single variant; multiple values are separated by a vertical bar.\"").addDescription("MissingValue", "\".\""), new DatabaseField(FieldMeta.of("ClinVar", "trait", FieldType.string), "INFO::CLNDN").addDescription("Description", "\"The trait/disease the clinvar_clnsig referring to.\"").addDescription("MissingValue", "\".\""), new DatabaseField(FieldMeta.of("ClinVar", "review", FieldType.string), "INFO::CLNREVSTAT").addDescription("Description", "\"ClinVar Review Status summary.\"").addDescription("MissingValue", "\".\""), new DatabaseField(FieldMeta.of("ClinVar", "var_source", FieldType.string), "INFO::CLNDISDB").addDescription("Description", "\"Source of the variant.\"").addDescription("MissingValue", "\".\"")}).asUnmodifiable();
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile inputFile, File output) {
            this.inputFile = inputFile;
            this.output = output;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new VCFInputOption(this.inputFile).setInfoParser(new SpecifiedINFOParser("CLNSIG", "CLNDN", "CLNREVSTAT", "CLNDISDB"))).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=ClinVar,Description=\"ClinVar is a publicly accessible database that aggregates information about genomic variation and its relationship to human health, providing interpretations of clinical significance for variants.\",Source=\"" + this.inputFile + "\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<Variant, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(Variant input) throws IOException {
                    Variant output = new Variant(input.getCoordinate()).addAlleles(input.getAlleles());
                    Map infos = (Map)input.getProperty("INFO");
                    output.setProperty(((DatabaseField)FIELDS.fastGet(0)).getField().fullName(), input.getProperty("ID").toString());
                    Bytes clnsig = (Bytes)infos.get("CLNSIG");
                    output.setProperty(((DatabaseField)FIELDS.fastGet(1)).getField().fullName(), clnsig == null ? "." : clnsig.toString());
                    Bytes trait = (Bytes)infos.get("CLNDN");
                    output.setProperty(((DatabaseField)FIELDS.fastGet(2)).getField().fullName(), trait == null ? "." : trait.toString());
                    Bytes review = (Bytes)infos.get("CLNREVSTAT");
                    output.setProperty(((DatabaseField)FIELDS.fastGet(3)).getField().fullName(), review == null ? "." : review.toString());
                    Bytes var_source = (Bytes)infos.get("CLNDISDB");
                    output.setProperty(((DatabaseField)FIELDS.fastGet(4)).getField().fullName(), var_source == null ? "." : var_source.toString());
                    return output;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

