/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class Conservation
extends GTBDatabase {
    public Conservation(String file) throws IOException {
        super(file);
    }

    public Conservation(File file) throws IOException {
        super(file);
    }

    public Conservation(LiveFile file) throws IOException {
        super(file);
    }

    public Conservation(CCFTable file) throws IOException {
        super(file);
    }

    public Conservation(GTBManager file) throws IOException {
        super(file);
    }

    public Conservation(GTBReaderOption file) {
        super(file);
    }

    public Conservation(GTBReaderOption file, IFieldCollection fields, ICCFMeta meta) {
        super(file, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    @Override
    public boolean contains(Variant variant) {
        return variant.numOfAlleles() >= 1 && variant.alleleOfIndex(0).length() == 1;
    }

    @Override
    public boolean annotate(List<Variant> resources, long pointer, Variant variant) {
        if (resources != null && resources.size() > 0) {
            for (Variant resource : resources) {
                if (!variant.alleleOfIndex(0).equals(resource.alleleOfIndex(0))) continue;
                for (FieldMeta field : this.fields) {
                    variant.setProperty(field.fullName(), resource.getProperty(field.fullName()));
                }
            }
        }
        return true;
    }

    @Override
    public String getDatabaseName() {
        return "conservation";
    }

    public static class OutputSetting {
        final LiveFile inputFile;
        final File output;
        private final List<DatabaseField> fields = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("conservation", "GC", FieldType.float16), "GC"), new DatabaseField(FieldMeta.of("conservation", "CpG", FieldType.float16), "CpG"), new DatabaseField(FieldMeta.of("conservation", "scoreSegDup", FieldType.float16), "scoreSegDup"), new DatabaseField(FieldMeta.of("conservation", "priPhCons", FieldType.float16), "priPhCons"), new DatabaseField(FieldMeta.of("conservation", "mamPhCons", FieldType.float16), "mamPhCons"), new DatabaseField(FieldMeta.of("conservation", "verPhCons", FieldType.float16), "verPhCons"), new DatabaseField(FieldMeta.of("conservation", "priPhyloP", FieldType.float16), "priPhyloP"), new DatabaseField(FieldMeta.of("conservation", "mamPhyloP", FieldType.float16), "mamPhyloP"), new DatabaseField(FieldMeta.of("conservation", "verPhyloP", FieldType.float16), "verPhyloP"), new DatabaseField(FieldMeta.of("conservation", "GerpN", FieldType.float16), "GerpN"), new DatabaseField(FieldMeta.of("conservation", "GerpS", FieldType.float16), "GerpS"), new DatabaseField(FieldMeta.of("conservation", "bStatistic", FieldType.varInt32), "bStatistic").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("conservation", "fitCons_all", FieldType.float16), "fitCons_all"), new DatabaseField(FieldMeta.of("conservation", "SiPhy", FieldType.float16), "SiPhy")}).asUnmodifiable();
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile inputFile, File output) {
            this.inputFile = inputFile;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new TextInputOption(this.inputFile).setHeaderParser(IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN).setMetadataParser(IMetadataParser.NO_METADATA)).setOutput(new GTBOutputOption(this.output).addFields(this.fields.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=conservation,Description=\"Conservation scores, such as GERP++, PhyloP, and phastCons, are metrics that assess the evolutionary conservation of genomic regions across different species, helping to identify functionally important elements in the genome.\",Source=\"" + this.inputFile + "\">")).addMeta(this.fields.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(fields.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(TextRecord input) throws IOException {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("chr").toString()), input.get("end_pos").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate).addAllele(input.get("ref").toString()).setProperty(this.properties.get());
                    boolean anyValue = false;
                    for (DatabaseField field : fields) {
                        int index = input.indexOf(field.getSource());
                        if (index == -1) continue;
                        Bytes value = input.get(index);
                        if (field.getField().type() == FieldType.varInt32 && value.valueEquals((byte)46)) {
                            variant.setProperty(field.getField().fullName(), -1);
                            continue;
                        }
                        anyValue = true;
                        variant.setProperty(field.getField().fullName(), value);
                    }
                    if (anyValue) {
                        return variant;
                    }
                    return null;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

