/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.DatabaseException;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.RefGenomeVersion;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class DBNSFP_RankScore
extends GTBDatabase {
    public DBNSFP_RankScore(String file) throws IOException {
        super(file);
    }

    public DBNSFP_RankScore(File file) throws IOException {
        super(file);
    }

    public DBNSFP_RankScore(LiveFile file) throws IOException {
        super(file);
    }

    public DBNSFP_RankScore(CCFTable file) throws IOException {
        super(file);
    }

    public DBNSFP_RankScore(GTBManager file) throws IOException {
        super(file);
    }

    public DBNSFP_RankScore(GTBReaderOption file) {
        super(file);
    }

    public DBNSFP_RankScore(GTBReaderOption file, IFieldCollection fields, ICCFMeta meta) {
        super(file, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        if (LiveFile.exists(file)) {
            return new InputSetting(List.singleton(LiveFile.of(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(File file) throws IOException {
        if (file != null && file.exists()) {
            return new InputSetting(List.singleton(new LocalFile(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(LiveFile file) {
        if (file != null) {
            return new InputSetting(List.singleton(file));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(List<LiveFile> files) {
        List<LiveFile> inputs = new List<LiveFile>();
        if (files != null) {
            for (LiveFile file : files) {
                inputs.add(file);
            }
        }
        return new InputSetting(inputs);
    }

    @Override
    public boolean contains(Variant target) {
        return target.numOfAlleles() == 2 && target.alleleOfIndex(0).length() == 1 && target.alleleOfIndex(1).length() == 1;
    }

    @Override
    public String getDatabaseName() {
        return "dbNSFP_RankScore";
    }

    public static class OutputSetting {
        final List<LiveFile> inputs;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "SIFT_converted", FieldType.float16), "SIFT_converted_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "SIFT4G_converted", FieldType.float16), "SIFT4G_converted_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "Polyphen2_HDIV", FieldType.float16), "Polyphen2_HDIV_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "Polyphen2_HVAR", FieldType.float16), "Polyphen2_HVAR_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MutationTaster_converted", FieldType.float16), "MutationTaster_converted_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MutationAssessor", FieldType.float16), "MutationAssessor_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "PROVEAN_converted", FieldType.float16), "PROVEAN_converted_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "VEST4", FieldType.float16), "VEST4_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MetaSVM", FieldType.float16), "MetaSVM_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MetaLR", FieldType.float16), "MetaLR_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MetaRNN", FieldType.float16), "MetaRNN_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "M-CAP", FieldType.float16), "M-CAP_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "REVEL", FieldType.float16), "REVEL_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MutPred", FieldType.float16), "MutPred_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MVP", FieldType.float16), "MVP_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "gMVP", FieldType.float16), "gMVP_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MPC", FieldType.float16), "MPC_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "PrimateAI", FieldType.float16), "PrimateAI_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "DEOGEN2", FieldType.float16), "DEOGEN2_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "BayesDel_addAF", FieldType.float16), "BayesDel_addAF_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "BayesDel_noAF", FieldType.float16), "BayesDel_noAF_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "ClinPred", FieldType.float16), "ClinPred_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "LIST-S2", FieldType.float16), "LIST-S2_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "VARITY_R", FieldType.float16), "VARITY_R_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "VARITY_ER", FieldType.float16), "VARITY_ER_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "VARITY_R_LOO", FieldType.float16), "VARITY_R_LOO_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "VARITY_ER_LOO", FieldType.float16), "VARITY_ER_LOO_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "ESM1b", FieldType.float16), "ESM1b_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "AlphaMissense", FieldType.float16), "AlphaMissense_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "PHACTboost", FieldType.float16), "PHACTboost_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MutFormer", FieldType.float16), "MutFormer_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "MutScore", FieldType.float16), "MutScore_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "CADD_raw", FieldType.float16), "CADD_raw_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "DANN", FieldType.float16), "DANN_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "fathmm-XF_coding", FieldType.float16), "fathmm-XF_coding_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "Eigen-raw_coding", FieldType.float16), "Eigen-raw_coding_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "Eigen-PC-raw_coding", FieldType.float16), "Eigen-PC-raw_coding_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "GERP++_RS", FieldType.float16), "GERP++_RS_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "GERP_91_mammals", FieldType.float16), "GERP_91_mammals_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phyloP100way_vertebrate", FieldType.float16), "phyloP100way_vertebrate_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phyloP470way_mammalian", FieldType.float16), "phyloP470way_mammalian_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phyloP17way_primate", FieldType.float16), "phyloP17way_primate_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phastCons100way_vertebrate", FieldType.float16), "phastCons100way_vertebrate_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phastCons470way_mammalian", FieldType.float16), "phastCons470way_mammalian_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "phastCons17way_primate", FieldType.float16), "phastCons17way_primate_rankscore"), new DatabaseField(FieldMeta.of("dbNSFP_rankscore", "bStatistic_converted", FieldType.float16), "bStatistic_converted_rankscore")}).asUnmodifiable();
        RefGenomeVersion refGenomeVersion = RefGenomeVersion.hg38;
        boolean resume = true;
        boolean silent = false;

        public static void main(String[] args) {
        }

        private OutputSetting(List<LiveFile> inputs, File output) {
            this.inputs = inputs;
            this.output = output;
        }

        public OutputSetting setRefGenomeVersion(RefGenomeVersion version) {
            this.refGenomeVersion = version == null ? RefGenomeVersion.hg38 : version;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            String positionField;
            String chromosomeField;
            if (this.resume && this.output.exists()) {
                return;
            }
            if (this.refGenomeVersion.equals((Object)RefGenomeVersion.hg18)) {
                chromosomeField = "hg18_chr";
                positionField = "hg18_pos(1-based)";
            } else if (this.refGenomeVersion.equals((Object)RefGenomeVersion.hg19)) {
                chromosomeField = "hg19_chr";
                positionField = "hg19_pos(1-based)";
            } else if (this.refGenomeVersion.equals((Object)RefGenomeVersion.hg38)) {
                chromosomeField = "chr";
                positionField = "pos(1-based)";
            } else {
                throw new DatabaseException("Unsupported reference genome version: " + (Object)((Object)this.refGenomeVersion));
            }
            Processor.setInputs(this.inputs.filter(Objects::nonNull).apply(TextInputOption::new)).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=dbNSFP,Description=\"dbNSFP is a comprehensive database developed for functional prediction and annotation of all potential nonsynonymous single-nucleotide variants (nsSNVs) and splice-site SNVs (ssSNVs) in the human genome. It compiles prediction scores from multiple algorithms, conservation scores, allele frequencies, and gene information to facilitate variant interpretation.\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(TextRecord input) {
                    Chromosome chr = Chromosome.get(input.get(chromosomeField).toString());
                    int pos = input.get(positionField).toInt();
                    if (chr == Chromosome.UNKNOWN || pos <= 0) {
                        return null;
                    }
                    Variant variant = new Variant(new Coordinate(chr, pos)).addAllele(input.get("ref").toString()).addAllele(input.get("alt").toString()).setProperty(this.properties.get());
                    boolean anyValue = false;
                    int l = FIELDS.size();
                    for (int i = 0; i < l; ++i) {
                        DatabaseField field = (DatabaseField)FIELDS.fastGet(i);
                        int index = input.indexOf(field.getSource());
                        if (index == -1) continue;
                        Bytes value = input.get(index);
                        if (value.valueEquals((byte)46)) {
                            variant.setProperty(field.getField().fullName(), null);
                            continue;
                        }
                        anyValue = true;
                        variant.setProperty(field.getField().fullName(), value);
                    }
                    if (anyValue) {
                        return variant;
                    }
                    return null;
                }
            }).setListener(this.silent ? null : new InputOutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final List<LiveFile> inputs;

        private InputSetting(List<LiveFile> inputs) {
            this.inputs = inputs;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.inputs, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.inputs, output);
        }
    }
}

