/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.input.VCFInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreINFOParser;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import java.io.File;
import java.io.IOException;

public final class DBSNP
extends Database<Variant, Variant> {
    static final FieldMeta FIELD = FieldMeta.of(null, "ID", FieldType.string);
    final GTBReaderOption option;

    public DBSNP(String option) throws IOException {
        this.option = (GTBReaderOption)new GTBReaderOption(option, false, false).addField("ID");
    }

    public DBSNP(File option) throws IOException {
        this.option = (GTBReaderOption)new GTBReaderOption(option, false, false).addField("ID");
    }

    public DBSNP(LiveFile option) throws IOException {
        this.option = (GTBReaderOption)new GTBReaderOption(option, false, false).addField("ID");
    }

    public DBSNP(CCFTable option) throws IOException {
        this.option = (GTBReaderOption)new GTBReaderOption(option, false, false).addField("ID");
    }

    public DBSNP(GTBManager option) {
        this.option = (GTBReaderOption)new GTBReaderOption(option, false, false).addField("ID");
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    @Override
    public IFieldCollection getAllFields() {
        return FIELD;
    }

    @Override
    public boolean contains(Variant variant) {
        return variant.numOfAlleles() >= 2;
    }

    @Override
    public boolean annotate(List<Variant> databaseRecords, long pointer, Variant variant) {
        if (databaseRecords == null || databaseRecords.size() == 0) {
            variant.setProperty("ID", ".");
        } else {
            ByteStream container = ByteStream.getThreadInstance();
            if (variant.numOfAlleles() == 0) {
                for (Variant databaseRecord : databaseRecords) {
                    container.writeChar((String)databaseRecord.getProperty("ID"));
                    container.write(59);
                }
            } else {
                block1: for (Variant databaseRecord : databaseRecords) {
                    if (!databaseRecord.alleleOfIndex(0).equals(variant.alleleOfIndex(0))) continue;
                    for (int alleleIndex = 1; alleleIndex < variant.numOfAlleles(); ++alleleIndex) {
                        if (databaseRecord.indexOfAllele(variant.alleleOfIndex(alleleIndex)) == -1) continue;
                        container.writeChar((String)databaseRecord.getProperty("ID"));
                        container.write(59);
                        continue block1;
                    }
                }
            }
            if (container.length() > 0) {
                container.wSeek(container.wTell() - 1);
                variant.setProperty("ID", container.getString(container.length()));
            } else {
                variant.setProperty("ID", ".");
            }
        }
        return true;
    }

    @Override
    public GTBDatabase.Reader instance() throws IOException {
        return new GTBDatabase.Reader(this, this.option);
    }

    @Override
    public String getDatabaseName() {
        return "dbSNP";
    }

    public static class OutputSetting {
        final LiveFile input;
        final File output;
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile input, File output) {
            this.input = input;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new VCFInputOption(this.input).addInputPreFilter(variant -> this.liftover.convert((Variant)variant)).setInfoParser(IgnoreINFOParser.INSTANCE)).setOutput(new GTBOutputOption(this.output).addField(FieldMeta.of(null, "ID", FieldType.string)).addMeta(CCFMetaItem.of("Database", "<Name=dbSNP,Source=\"" + this.input + "\">")).addMeta(CCFMetaItem.of("ID", "<Type=string,Description=\"RS number from dbSNP.\">"))).bridge(input -> input).setListener(this.silent ? null : new InputOutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

