/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import java.util.LinkedHashMap;

public class DatabaseField {
    private final FieldMeta field;
    private final String source;
    private final LinkedHashMap<String, String> description = new LinkedHashMap(0);

    public DatabaseField(FieldMeta field, String source2) {
        this.field = field;
        this.source = source2;
    }

    public DatabaseField addDescription(String key, String value) {
        this.description.put(key, value);
        return this;
    }

    public CCFMetaItem getMeta() {
        StringBuilder builder = new StringBuilder("<Type=" + this.field.type());
        if (this.source != null) {
            builder.append(",Source=\"" + this.source + "\"");
        }
        for (String key : this.description.keySet()) {
            builder.append("," + key + "=" + this.description.get(key) + "");
        }
        builder.append(">");
        return CCFMetaItem.of(this.field.fullName(), builder.toString());
    }

    public FieldMeta getField() {
        return this.field;
    }

    public String getSource() {
        return this.source;
    }
}

