/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Indexer;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.Sorter;
import edu.sysu.pmglab.ccf.toolkit.annotator.IntervalDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.BoxRecord2BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.input.BigWigInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.CCFOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.CoordinateInterval;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import java.io.File;
import java.io.IOException;

public class EpiMap
extends IntervalDatabase {
    protected static final IFieldCollection INTERVAL_FIELDS = new FieldGroupMeta(null).addField("CHROM", FieldType.chromosome).addField("POS_START", FieldType.varInt32).addField("POS_END", FieldType.varInt32).asUnmodifiable();
    protected final IFieldCollection fields;
    protected final ICCFMeta meta;

    public EpiMap(String file) throws IOException {
        this((IReaderOption<?>)new ReaderOption(file, new String[0]).addAllFields());
    }

    public EpiMap(File file) throws IOException {
        this((IReaderOption<?>)new ReaderOption(file, new String[0]).addAllFields());
    }

    public EpiMap(LiveFile file) throws IOException {
        this((IReaderOption<?>)new ReaderOption(file, new String[0]).addAllFields());
    }

    public EpiMap(CCFTable file) {
        this((IReaderOption<?>)new ReaderOption(file, new String[0]).addAllFields());
    }

    public EpiMap(IReaderOption<?> option) {
        this(option, option.getTable().getAllFields().subsetFieldsExcludes(INTERVAL_FIELDS), option.getTable().getMeta());
    }

    public EpiMap(IReaderOption<?> option, IFieldCollection fields, ICCFMeta meta) {
        super(option, new CCFIntIndexer<Chromosome>((LiteTable)option.getTable().getOption("INDEXER")));
        this.fields = fields == null ? option.getTable().getAllFields().subsetFieldsExcludes(INTERVAL_FIELDS) : fields.asUnmodifiable();
        this.meta = meta == null ? option.getTable().getMeta() : meta.asUnmodifiable();
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    public static InputSetting buildFrom(String subject, String marker) throws IOException {
        String name = "impute_" + subject + "_" + marker;
        return EpiMap.buildFrom(LiveFile.of("https://epigenome.wustl.edu/epimap/data/imputed/" + name + ".bigWig").copyFileTo(RuntimeProperty.createFile(name + ".bigWig")));
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.fields;
    }

    @Override
    public ICCFMeta getMeta() {
        return this.meta;
    }

    @Override
    public String getDatabaseName() {
        return this.option.getFile().getName();
    }

    public static class OutputSetting {
        final LiveFile inputFile;
        final File output;
        String marker;
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile inputFile, File output) {
            this.inputFile = inputFile;
            this.output = output;
            this.marker = FileUtils.changeExtension(inputFile.getName(), "", ".bigWig", ".gz", ".bgz");
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public OutputSetting setMarker(String marker) {
            this.marker = marker == null ? FileUtils.changeExtension(this.inputFile.getName(), "", ".bigWig", ".gz", ".bgz") : marker;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            CCFOutputOption output = new CCFOutputOption(this.output).addFields(INTERVAL_FIELDS).addField(FieldMeta.of("EpiMap", this.marker, FieldType.float32)).addMeta(CCFMetaItem.of("Database", "<Name=EpiMap,Description=\"EpiMap is a resource that integrates epigenomic data across multiple annotation projects to provide insights into the regulatory landscape of the human genome, aiding in the interpretation of non-coding variants.\",Source=\"" + this.inputFile + ".\">"));
            Processor.setInput(new BigWigInputOption(this.inputFile)).setOutput(output).bridge(new BoxRecord2BoxRecord(output.getAllFields()).setValue((input, target) -> {
                Chromosome chromosome = (Chromosome)input.get("CHROM");
                int start = (Integer)input.get("POS_START") + 1;
                int end = (Integer)input.get("POS_END");
                float value = ((Float)input.get("VALUE")).floatValue();
                CoordinateInterval interval = this.liftover.convert(new CoordinateInterval(chromosome, start, end));
                if (interval == null) {
                    return false;
                }
                target.set(0, (Object)interval.getChromosome());
                target.set(1, (Object)interval.getStartPosition().getPosition());
                target.set(2, (Object)interval.getEndPosition().getPosition());
                target.set(3, (Object)Float.valueOf(value));
                return true;
            })).setListener(this.silent ? null : new OutputListener()).submit(threads);
            CCFTable table = new CCFTable(this.output);
            Sorter.SorterSetting<ReaderOption, Chromosome, IntInterval> sorter = Sorter.setInput(table, new String[0]).getTagFrom(record -> (Chromosome)record.get("CHROM")).getValueFrom(record -> new IntInterval((Integer)record.get("POS_START"), (Integer)record.get("POS_END"))).projectValue(IntInterval::start).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.bucketSort(new CCFOutputOption(this.output).addMeta(table.getMeta()).addFields(table.getAllFields()), threads);
            }
            Indexer.setInput(this.output, "CHROM", "POS_START").getTagFrom(record -> (Chromosome)record.get("CHROM"), FieldType.chromosome).getValueFrom(record -> (Comparable)record.get("POS_START"), FieldType.varInt32).setListener(this.silent ? null : new InputListener("Indexed", "records")).save("INDEXER", threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

