/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class FAVOR
extends GTBDatabase {
    public FAVOR(String option) throws IOException {
        super(option);
    }

    public FAVOR(File option) throws IOException {
        super(option);
    }

    public FAVOR(LiveFile option) throws IOException {
        super(option);
    }

    public FAVOR(CCFTable option) throws IOException {
        super(option);
    }

    public FAVOR(GTBManager option) throws IOException {
        super(option);
    }

    public FAVOR(GTBReaderOption option) {
        super(option);
    }

    public FAVOR(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        super(option, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        if (LiveFile.exists(file)) {
            return new InputSetting(List.singleton(LiveFile.of(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(File file) throws IOException {
        if (file != null && file.exists()) {
            return new InputSetting(List.singleton(new LocalFile(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(LiveFile file) {
        if (file != null) {
            return new InputSetting(List.singleton(file));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(List<LiveFile> files) {
        List<LiveFile> inputs = new List<LiveFile>();
        if (files != null) {
            for (LiveFile file : files) {
                inputs.add(file);
            }
        }
        return new InputSetting(inputs);
    }

    @Override
    public boolean contains(Variant variant) {
        return variant.numOfAlleles() == 2;
    }

    @Override
    public String getDatabaseName() {
        return "FAVOR";
    }

    public static class OutputSetting {
        final List<LiveFile> inputs;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("AlleleFrequencies", "TOPMed_Bravo", FieldType.float32), "bravo_af"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_Total", FieldType.float32), "af_total"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_RAW", FieldType.float32), "af_raw"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_AFR", FieldType.float32), "af_afr"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_AMR", FieldType.float32), "af_amr"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_EAS", FieldType.float32), "af_eas"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_NFE", FieldType.float32), "af_nfe"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_FIN", FieldType.float32), "af_fin"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_SAS", FieldType.float32), "af_sas"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_AMI", FieldType.float32), "af_ami"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_ASJ", FieldType.float32), "af_asj"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "FAVOR_OTH", FieldType.float32), "af_oth"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_ALL", FieldType.float32), "tg_all"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_AFR", FieldType.float32), "tg_afr"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_AMR", FieldType.float32), "tg_amr"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_EAS", FieldType.float32), "tg_eas"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_EUR", FieldType.float32), "tg_eur"), new DatabaseField(FieldMeta.of("AlleleFrequencies", "1000GP3_SAS", FieldType.float32), "tg_sas"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_protein_function", FieldType.float32), "apc_protein_function"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_protein_function_v2", FieldType.float32), "apc_protein_function_v2"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_protein_function_v3", FieldType.float32), "apc_protein_function_v3"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_conservation", FieldType.float32), "apc_conservation"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_conservation_v2", FieldType.float32), "apc_conservation_v2"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_epigenetics", FieldType.float32), "apc_epigenetics"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_epigenetics_active", FieldType.float32), "apc_epigenetics_active"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_epigenetics_repressed", FieldType.float32), "apc_epigenetics_repressed"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_epigenetics_transcription", FieldType.float32), "apc_epigenetics_transcription"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_local_nucleotide_diversity", FieldType.float32), "apc_local_nucleotide_diversity"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_local_nucleotide_diversity_v2", FieldType.float32), "apc_local_nucleotide_diversity_v2"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_local_nucleotide_diversity_v3", FieldType.float32), "apc_local_nucleotide_diversity_v3"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_mutation_density", FieldType.float32), "apc_mutation_density"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_transcription_factor", FieldType.float32), "apc_transcription_factor"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_mappability", FieldType.float32), "apc_mappability"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_micro_rna", FieldType.float32), "apc_micro_rna"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_proximity_to_coding", FieldType.float32), "apc_proximity_to_coding"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_proximity_to_coding_v2", FieldType.float32), "apc_proximity_to_coding_v2"), new DatabaseField(FieldMeta.of("IntegrativeScore", "apc_proximity_to_tsstes", FieldType.float32), "apc_proximity_to_tsstes"), new DatabaseField(FieldMeta.of("IntegrativeScore", "cadd_rawscore", FieldType.float32), "cadd_rawscore"), new DatabaseField(FieldMeta.of("IntegrativeScore", "cadd_phred", FieldType.float32), "cadd_phred"), new DatabaseField(FieldMeta.of("IntegrativeScore", "linsight", FieldType.float32), "linsight"), new DatabaseField(FieldMeta.of("IntegrativeScore", "fathmm_xf", FieldType.float32), "fathmm_xf"), new DatabaseField(FieldMeta.of("IntegrativeScore", "funseq_value", FieldType.float32), "funseq_value"), new DatabaseField(FieldMeta.of("IntegrativeScore", "aloft_value", FieldType.float32), "aloft_value"), new DatabaseField(FieldMeta.of("ProteinFunction", "polyphen_val", FieldType.float32), "polyphen_val"), new DatabaseField(FieldMeta.of("ProteinFunction", "polyphen2_hdiv_score", FieldType.float32), "polyphen2_hdiv_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "polyphen2_hvar_score", FieldType.float32), "polyphen2_hvar_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "grantham", FieldType.float32), "grantham"), new DatabaseField(FieldMeta.of("ProteinFunction", "mutation_taster_score", FieldType.float32), "mutation_taster_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "mutation_assessor_score", FieldType.float32), "mutation_assessor_score"), new DatabaseField(FieldMeta.of("ProteinFunction", "sift_val", FieldType.float32), "sift_val"), new DatabaseField(FieldMeta.of("Epigenetics", "encode_dnase_sum", FieldType.float32), "encode_dnase_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k27ac_sum", FieldType.float32), "encodeh3k27ac_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k4me1_sum", FieldType.float32), "encodeh3k4me1_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k4me2_sum", FieldType.float32), "encodeh3k4me2_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k4me3_sum", FieldType.float32), "encodeh3k4me3_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k9ac_sum", FieldType.float32), "encodeh3k9ac_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh4k20me1_sum", FieldType.float32), "encodeh4k20me1_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh2afz_sum", FieldType.float32), "encodeh2afz_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k9me3_sum", FieldType.float32), "encodeh3k9me3_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k27me3_sum", FieldType.float32), "encodeh3k27me3_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k36me3_sum", FieldType.float32), "encodeh3k36me3_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodeh3k79me2_sum", FieldType.float32), "encodeh3k79me2_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "encodetotal_rna_sum", FieldType.float32), "encodetotal_rna_sum"), new DatabaseField(FieldMeta.of("Epigenetics", "gc", FieldType.float32), "gc"), new DatabaseField(FieldMeta.of("Epigenetics", "cpg", FieldType.float32), "cpg"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "remap_overlap_tf", FieldType.varInt32), "remap_overlap_tf").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("TranscriptionFactors", "remap_overlap_cl", FieldType.varInt32), "remap_overlap_cl").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e1", FieldType.float32), "chmm_e1"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e2", FieldType.float32), "chmm_e2"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e3", FieldType.float32), "chmm_e3"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e4", FieldType.float32), "chmm_e4"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e5", FieldType.float32), "chmm_e5"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e6", FieldType.float32), "chmm_e6"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e7", FieldType.float32), "chmm_e7"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e8", FieldType.float32), "chmm_e8"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e9", FieldType.float32), "chmm_e9"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e10", FieldType.float32), "chmm_e10"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e11", FieldType.float32), "chmm_e11"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e12", FieldType.float32), "chmm_e12"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e13", FieldType.float32), "chmm_e13"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e14", FieldType.float32), "chmm_e14"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e15", FieldType.float32), "chmm_e15"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e16", FieldType.float32), "chmm_e16"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e17", FieldType.float32), "chmm_e17"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e18", FieldType.float32), "chmm_e18"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e19", FieldType.float32), "chmm_e19"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e20", FieldType.float32), "chmm_e20"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e21", FieldType.float32), "chmm_e21"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e22", FieldType.float32), "chmm_e22"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e23", FieldType.float32), "chmm_e23"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e24", FieldType.float32), "chmm_e24"), new DatabaseField(FieldMeta.of("ChromatinStates", "chmm_e25", FieldType.float32), "chmm_e25"), new DatabaseField(FieldMeta.of("LocalNucleotideDiversity", "recombination_rate", FieldType.float32), "recombination_rate"), new DatabaseField(FieldMeta.of("LocalNucleotideDiversity", "bstatistic", FieldType.varInt32), "bstatistic").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("LocalNucleotideDiversity", "nucdiv", FieldType.float32), "nucdiv"), new DatabaseField(FieldMeta.of("MutationDensity", "freq100bp", FieldType.varInt32), "freq100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "rare100bp", FieldType.varInt32), "rare100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "sngl100bp", FieldType.varInt32), "sngl100bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "freq1000bp", FieldType.varInt32), "freq1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "rare1000bp", FieldType.varInt32), "rare1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "sngl1000bp", FieldType.varInt32), "sngl1000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "freq10000bp", FieldType.varInt32), "freq10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "rare10000bp", FieldType.varInt32), "rare10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("MutationDensity", "sngl10000bp", FieldType.varInt32), "sngl10000bp").addDescription("MissingValue", "-1"), new DatabaseField(FieldMeta.of("Mappability", "k24_bismap", FieldType.float32), "k24_bismap"), new DatabaseField(FieldMeta.of("Mappability", "k24_umap", FieldType.float32), "k24_umap"), new DatabaseField(FieldMeta.of("Mappability", "k36_bismap", FieldType.float32), "k36_bismap"), new DatabaseField(FieldMeta.of("Mappability", "k36_umap", FieldType.float32), "k36_umap"), new DatabaseField(FieldMeta.of("Mappability", "k50_bismap", FieldType.float32), "k50_bismap"), new DatabaseField(FieldMeta.of("Mappability", "k50_umap", FieldType.float32), "k50_umap"), new DatabaseField(FieldMeta.of("Mappability", "k100_bismap", FieldType.float32), "k100_bismap"), new DatabaseField(FieldMeta.of("Mappability", "k100_umap", FieldType.float32), "k100_umap"), new DatabaseField(FieldMeta.of("ProximityTable", "min_dist_tss", FieldType.float32), "min_dist_tss"), new DatabaseField(FieldMeta.of("ProximityTable", "min_dist_tse", FieldType.float32), "min_dist_tse")}).asUnmodifiable();
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(List<LiveFile> inputs, File output) {
            this.inputs = inputs;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInputs(this.inputs.apply(file -> new TextInputOption((LiveFile)file).setSeparator(Separator.CDD).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.NO_METADATA))).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=FAVOR,Description=\"FAVOR is a comprehensive functional annotation database that provides multi-faceted annotations for all possible single nucleotide variants (SNVs) in the human genome by integrating data from multiple sources, facilitating variant interpretation and prioritization.\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(TextRecord input) {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("chromosome").toString()), input.get("position").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate).addAllele(input.get("ref_vcf").toString()).addAllele(input.get("alt_vcf").toString()).setProperty(this.properties.get());
                    for (DatabaseField field : FIELDS) {
                        Bytes value = input.get(field.getSource());
                        if (field.getField().type() == FieldType.varInt32 && value.length() == 0) {
                            variant.setProperty(field.getField().fullName(), -1);
                            continue;
                        }
                        variant.setProperty(field.getField().fullName(), input.get(field.getSource()));
                    }
                    return variant;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final List<LiveFile> inputs;

        private InputSetting(List<LiveFile> inputs) {
            this.inputs = inputs;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.inputs, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.inputs, output);
        }
    }
}

