/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.InputOutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.INFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.SpecifiedINFOParser;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class GNOMAD
extends GTBDatabase {
    public GNOMAD(String option) throws IOException {
        super(option);
    }

    public GNOMAD(File option) throws IOException {
        super(option);
    }

    public GNOMAD(LiveFile option) throws IOException {
        super(option);
    }

    public GNOMAD(CCFTable option) throws IOException {
        super(option);
    }

    public GNOMAD(GTBManager option) throws IOException {
        super(option);
    }

    public GNOMAD(GTBReaderOption option) {
        super(option);
    }

    public GNOMAD(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        super(option, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        if (LiveFile.exists(file)) {
            return new InputSetting(List.singleton(LiveFile.of(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(File file) throws IOException {
        if (file != null && file.exists()) {
            return new InputSetting(List.singleton(new LocalFile(file)));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(LiveFile file) {
        if (file != null) {
            return new InputSetting(List.singleton(file));
        }
        return new InputSetting(List.EMPTY());
    }

    public static InputSetting buildFrom(List<LiveFile> files) {
        List<LiveFile> inputs = new List<LiveFile>();
        if (files != null) {
            for (LiveFile file : files) {
                inputs.add(file);
            }
        }
        return new InputSetting(inputs);
    }

    @Override
    public String getDatabaseName() {
        return "gnomAD";
    }

    public static class OutputSetting {
        final List<LiveFile> inputs;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("gnomAD_joint", "ALL", FieldType.float16), "AF_joint").addDescription("Description", "\"Alternate allele frequency.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "AFR", FieldType.float16), "AF_joint_afr").addDescription("Description", "\"Alternate allele frequency in samples of African / African - American ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "AMI", FieldType.float16), "AF_joint_ami").addDescription("Description", "\"Alternate allele frequency in samples of Amish ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "AMR", FieldType.float16), "AF_joint_amr").addDescription("Description", "\"Alternate allele frequency in samples of Latino ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "ASJ", FieldType.float16), "AF_joint_asj").addDescription("Description", "\"Alternate allele frequency in samples of Ashkenazi Jewish ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "EAS", FieldType.float16), "AF_joint_eas").addDescription("Description", "\"Alternate allele frequency in samples of East Asian ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "FIN", FieldType.float16), "AF_joint_fin").addDescription("Description", "\"Alternate allele frequency in samples of Finnish ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "MID", FieldType.float16), "AF_joint_mid").addDescription("Description", "\"Alternate allele frequency in samples of Middle Eastern ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "NFE", FieldType.float16), "AF_joint_nfe").addDescription("Description", "\"Alternate allele frequency in samples of Non - Finnish European ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_joint", "SAS", FieldType.float16), "AF_joint_sas").addDescription("Description", "\"Alternate allele frequency in samples of South Asian ancestry in joint dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "ALL", FieldType.float16), "AF_genomes").addDescription("Description", "\"Alternate allele frequency in joint subset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "AFR", FieldType.float16), "AF_genomes_afr").addDescription("Description", "\"Alternate allele frequency in samples of African / African - American ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "AMI", FieldType.float16), "AF_genomes_ami").addDescription("Description", "\"Alternate allele frequency in samples of Amish ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "AMR", FieldType.float16), "AF_genomes_amr").addDescription("Description", "\"Alternate allele frequency in samples of Latino ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "ASJ", FieldType.float16), "AF_genomes_asj").addDescription("Description", "\"Alternate allele frequency in samples of Ashkenazi Jewish ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "EAS", FieldType.float16), "AF_genomes_eas").addDescription("Description", "\"Alternate allele frequency in samples of East Asian ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "FIN", FieldType.float16), "AF_genomes_fin").addDescription("Description", "\"Alternate allele frequency in samples of Finnish ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "MID", FieldType.float16), "AF_genomes_mid").addDescription("Description", "\"Alternate allele frequency in samples of Middle Eastern ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "NFE", FieldType.float16), "AF_genomes_nfe").addDescription("Description", "\"Alternate allele frequency in samples of Non - Finnish European ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_genomes", "SAS", FieldType.float16), "AF_genomes_sas").addDescription("Description", "\"Alternate allele frequency in samples of South Asian ancestry in genomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "ALL", FieldType.float16), "AF_exomes").addDescription("Description", "\"Alternate allele frequency in joint subset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "AFR", FieldType.float16), "AF_exomes_afr").addDescription("Description", "\"Alternate allele frequency in samples of African / African - American ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "AMI", FieldType.float16), "AF_exomes_ami").addDescription("Description", "\"Alternate allele frequency in samples of Amish ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "AMR", FieldType.float16), "AF_exomes_amr").addDescription("Description", "\"Alternate allele frequency in samples of Latino ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "ASJ", FieldType.float16), "AF_exomes_asj").addDescription("Description", "\"Alternate allele frequency in samples of Ashkenazi Jewish ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "EAS", FieldType.float16), "AF_exomes_eas").addDescription("Description", "\"Alternate allele frequency in samples of East Asian ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "FIN", FieldType.float16), "AF_exomes_fin").addDescription("Description", "\"Alternate allele frequency in samples of Finnish ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "MID", FieldType.float16), "AF_exomes_mid").addDescription("Description", "\"Alternate allele frequency in samples of Middle Eastern ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "NFE", FieldType.float16), "AF_exomes_nfe").addDescription("Description", "\"Alternate allele frequency in samples of Non - Finnish European ancestry in exomes dataset.\""), new DatabaseField(FieldMeta.of("gnomAD_exomes", "SAS", FieldType.float16), "AF_exomes_sas").addDescription("Description", "\"Alternate allele frequency in samples of South Asian ancestry in exomes dataset.\"")}).asUnmodifiable();
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(List<LiveFile> inputs, File output) {
            this.inputs = inputs;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInputs(this.inputs.filter(Objects::nonNull).apply(TextInputOption::new)).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=gnomAD,Description=\"gnomAD is a resource that aggregates and harmonizes exome and genome sequencing data from a wide variety of large-scale sequencing projects, providing allele frequency information for genetic variants across diverse populations.\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));
                final INFOParser parse = new SpecifiedINFOParser(OutputSetting.access$200(this).apply(DatabaseField::getSource));
                final Bytes NA = new Bytes("NA");

                @Override
                public Variant converter(TextRecord input) throws IOException {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("CHROM").toString()), input.get("POS").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate).addAllele(input.get("REF").toString()).addAllele(input.get("ALT").toString()).setProperty(this.properties.get());
                    Map<String, Bytes> infos = this.parse.parse(input.get("INFO"));
                    boolean anyValue = false;
                    for (DatabaseField field : FIELDS) {
                        Bytes value = infos.get(field.getSource());
                        if (value == null) {
                            variant.setProperty(field.getField().fullName(), null);
                            continue;
                        }
                        anyValue = true;
                        variant.setProperty(field.getField().fullName(), value);
                    }
                    if (anyValue) {
                        return variant;
                    }
                    return null;
                }
            }).setListener(this.silent ? null : new InputOutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final List<LiveFile> inputs;

        private InputSetting(List<LiveFile> inputs) {
            this.inputs = inputs;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.inputs, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.inputs, output);
        }
    }
}

