/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.IConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class PEXT
extends GTBDatabase {
    public PEXT(String option) throws IOException {
        super(option);
    }

    public PEXT(File option) throws IOException {
        super(option);
    }

    public PEXT(LiveFile option) throws IOException {
        super(option);
    }

    public PEXT(CCFTable option) throws IOException {
        super(option);
    }

    public PEXT(GTBManager option) throws IOException {
        super(option);
    }

    public PEXT(GTBReaderOption option) {
        super(option);
    }

    public PEXT(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        super(option, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    public static List<Map<String, Bytes>> parseTxAnnotation(Bytes sequence2, IndexableSet<String> keys2) {
        List<Bytes> sequences = new List<Bytes>(1);
        int startPointer = -1;
        int l = sequence2.length();
        for (int i = 0; i < l; ++i) {
            if (sequence2.fastByteAt(i) == 123) {
                startPointer = i + 1;
            }
            if (sequence2.fastByteAt(i) != 125) continue;
            sequences.add(sequence2.subBytes(startPointer, i));
            startPointer = -1;
        }
        List<Map<String, Bytes>> parsed = new List<Map<String, Bytes>>(sequences.size());
        for (Bytes annotation : sequences) {
            boolean error;
            ByteStream reader;
            block10: {
                reader = annotation.toByteStream();
                error = false;
                if (reader.rRemaining() > 0) {
                    int b;
                    AbstractMap element = keys2 == null ? new HashMap() : new FixedIndexableMap(keys2);
                    parsed.add(element);
                    while ((b = reader.read()) == 34) {
                        int end = reader.find((byte)34);
                        String key = reader.getString(end);
                        reader.rSkip(1);
                        b = reader.read();
                        if (b == 58) {
                            Bytes value;
                            b = reader.read();
                            if (b == 34) {
                                end = reader.find((byte)34);
                                value = reader.getBytes(end);
                                reader.rSkip(1);
                            } else {
                                reader.rSeek(reader.rTell() - 1);
                                end = reader.find((byte)44);
                                value = end == -1 ? reader.getBytes(reader.rRemaining()) : reader.getBytes(end);
                            }
                            element.put(key, value);
                            b = reader.read();
                            if (b != -1) {
                                if (b == 44) continue;
                                error = true;
                            }
                        } else {
                            error = true;
                        }
                        break block10;
                    }
                    error = true;
                }
            }
            reader.close();
            if (!error) continue;
            throw new IllegalArgumentException("Invalid JSON format for tx_annotation: " + sequence2);
        }
        return parsed;
    }

    @Override
    public boolean contains(Variant variant) {
        return variant.numOfAlleles() == 2 && variant.alleleOfIndex(0).length() == 1 && variant.alleleOfIndex(1).length() == 1;
    }

    @Override
    public String getDatabaseName() {
        return "PEXT";
    }

    public static class OutputSetting {
        final LiveFile inputFile;
        final File output;
        private final List<DatabaseField> fields = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("PEXT", "ensg", FieldType.string), "ensg").addDescription("MissingValue", "null"), new DatabaseField(FieldMeta.of("PEXT", "csq", FieldType.string), "csq").addDescription("MissingValue", "null"), new DatabaseField(FieldMeta.of("PEXT", "symbol", FieldType.string), "symbol").addDescription("MissingValue", "null"), new DatabaseField(FieldMeta.of("PEXT", "lof", FieldType.string), "lof").addDescription("MissingValue", "null"), new DatabaseField(FieldMeta.of("PEXT", "lof_flag", FieldType.string), "lof_flag").addDescription("MissingValue", "null"), new DatabaseField(FieldMeta.of("PEXT", "Adipose_Subcutaneous", FieldType.float32), "Adipose_Subcutaneous"), new DatabaseField(FieldMeta.of("PEXT", "Adipose_Visceral_Omentum_", FieldType.float32), "Adipose_Visceral_Omentum_"), new DatabaseField(FieldMeta.of("PEXT", "AdrenalGland", FieldType.float32), "AdrenalGland"), new DatabaseField(FieldMeta.of("PEXT", "Artery_Aorta", FieldType.float32), "Artery_Aorta"), new DatabaseField(FieldMeta.of("PEXT", "Artery_Coronary", FieldType.float32), "Artery_Coronary"), new DatabaseField(FieldMeta.of("PEXT", "Artery_Tibial", FieldType.float32), "Artery_Tibial"), new DatabaseField(FieldMeta.of("PEXT", "Bladder", FieldType.float32), "Bladder"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Amygdala", FieldType.float32), "Brain_Amygdala"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Anteriorcingulatecortex_BA24_", FieldType.float32), "Brain_Anteriorcingulatecortex_BA24_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Caudate_basalganglia_", FieldType.float32), "Brain_Caudate_basalganglia_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_CerebellarHemisphere", FieldType.float32), "Brain_CerebellarHemisphere"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Cerebellum", FieldType.float32), "Brain_Cerebellum"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Cortex", FieldType.float32), "Brain_Cortex"), new DatabaseField(FieldMeta.of("PEXT", "Brain_FrontalCortex_BA9_", FieldType.float32), "Brain_FrontalCortex_BA9_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Hippocampus", FieldType.float32), "Brain_Hippocampus"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Hypothalamus", FieldType.float32), "Brain_Hypothalamus"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Nucleusaccumbens_basalganglia_", FieldType.float32), "Brain_Nucleusaccumbens_basalganglia_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Putamen_basalganglia_", FieldType.float32), "Brain_Putamen_basalganglia_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Spinalcord_cervicalc_1_", FieldType.float32), "Brain_Spinalcord_cervicalc_1_"), new DatabaseField(FieldMeta.of("PEXT", "Brain_Substantianigra", FieldType.float32), "Brain_Substantianigra"), new DatabaseField(FieldMeta.of("PEXT", "Breast_MammaryTissue", FieldType.float32), "Breast_MammaryTissue"), new DatabaseField(FieldMeta.of("PEXT", "Cells_EBV_transformedlymphocytes", FieldType.float32), "Cells_EBV_transformedlymphocytes"), new DatabaseField(FieldMeta.of("PEXT", "Cells_Transformedfibroblasts", FieldType.float32), "Cells_Transformedfibroblasts"), new DatabaseField(FieldMeta.of("PEXT", "Cervix_Ectocervix", FieldType.float32), "Cervix_Ectocervix"), new DatabaseField(FieldMeta.of("PEXT", "Cervix_Endocervix", FieldType.float32), "Cervix_Endocervix"), new DatabaseField(FieldMeta.of("PEXT", "Colon_Sigmoid", FieldType.float32), "Colon_Sigmoid"), new DatabaseField(FieldMeta.of("PEXT", "Colon_Transverse", FieldType.float32), "Colon_Transverse"), new DatabaseField(FieldMeta.of("PEXT", "Esophagus_GastroesophagealJunction", FieldType.float32), "Esophagus_GastroesophagealJunction"), new DatabaseField(FieldMeta.of("PEXT", "Esophagus_Mucosa", FieldType.float32), "Esophagus_Mucosa"), new DatabaseField(FieldMeta.of("PEXT", "Esophagus_Muscularis", FieldType.float32), "Esophagus_Muscularis"), new DatabaseField(FieldMeta.of("PEXT", "FallopianTube", FieldType.float32), "FallopianTube"), new DatabaseField(FieldMeta.of("PEXT", "Heart_AtrialAppendage", FieldType.float32), "Heart_AtrialAppendage"), new DatabaseField(FieldMeta.of("PEXT", "Heart_LeftVentricle", FieldType.float32), "Heart_LeftVentricle"), new DatabaseField(FieldMeta.of("PEXT", "Kidney_Cortex", FieldType.float32), "Kidney_Cortex"), new DatabaseField(FieldMeta.of("PEXT", "Liver", FieldType.float32), "Liver"), new DatabaseField(FieldMeta.of("PEXT", "Lung", FieldType.float32), "Lung"), new DatabaseField(FieldMeta.of("PEXT", "MinorSalivaryGland", FieldType.float32), "MinorSalivaryGland"), new DatabaseField(FieldMeta.of("PEXT", "Muscle_Skeletal", FieldType.float32), "Muscle_Skeletal"), new DatabaseField(FieldMeta.of("PEXT", "Nerve_Tibial", FieldType.float32), "Nerve_Tibial"), new DatabaseField(FieldMeta.of("PEXT", "Ovary", FieldType.float32), "Ovary"), new DatabaseField(FieldMeta.of("PEXT", "Pancreas", FieldType.float32), "Pancreas"), new DatabaseField(FieldMeta.of("PEXT", "Pituitary", FieldType.float32), "Pituitary"), new DatabaseField(FieldMeta.of("PEXT", "Prostate", FieldType.float32), "Prostate"), new DatabaseField(FieldMeta.of("PEXT", "Skin_NotSunExposed_Suprapubic_", FieldType.float32), "Skin_NotSunExposed_Suprapubic_"), new DatabaseField(FieldMeta.of("PEXT", "Skin_SunExposed_Lowerleg_", FieldType.float32), "Skin_SunExposed_Lowerleg_"), new DatabaseField(FieldMeta.of("PEXT", "SmallIntestine_TerminalIleum", FieldType.float32), "SmallIntestine_TerminalIleum"), new DatabaseField(FieldMeta.of("PEXT", "Spleen", FieldType.float32), "Spleen"), new DatabaseField(FieldMeta.of("PEXT", "Stomach", FieldType.float32), "Stomach"), new DatabaseField(FieldMeta.of("PEXT", "Testis", FieldType.float32), "Testis"), new DatabaseField(FieldMeta.of("PEXT", "Thyroid", FieldType.float32), "Thyroid"), new DatabaseField(FieldMeta.of("PEXT", "Uterus", FieldType.float32), "Uterus"), new DatabaseField(FieldMeta.of("PEXT", "Vagina", FieldType.float32), "Vagina"), new DatabaseField(FieldMeta.of("PEXT", "WholeBlood", FieldType.float32), "WholeBlood"), new DatabaseField(FieldMeta.of("PEXT", "mean_proportion", FieldType.float32), "mean_proportion")});
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile inputFile, File output) {
            this.inputFile = inputFile;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public OutputSetting addField(DatabaseField field) {
            if (field != null) {
                this.fields.add(field);
            }
            return this;
        }

        public OutputSetting addField(String group, String name, IFieldType type, String source2, String missing) {
            return this.addField(new DatabaseField(FieldMeta.of(group, name, type), source2).addDescription("MissingValue", missing));
        }

        public OutputSetting clearFields() {
            this.fields.clear();
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new TextInputOption(this.inputFile).setHeaderParser(IHeaderParser.FIRST_LINE).setMetadataParser(IMetadataParser.NO_METADATA)).setOutput(new GTBOutputOption(this.output).addFields(this.fields.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=PEXT, Description=\"PEXT is a dataset that provides estimates of the proportion of expression across different tissues for each exon, helping to assess the potential impact of splicing variants on gene function.\",Source=\"" + this.inputFile + "\">")).addMeta(this.fields.apply(DatabaseField::getMeta))).bridge(new IConverter<TextRecord, TextInputOption, Variant, GTBOutputOption>(){
                final Bytes NULL = new Bytes("null");
                final IndexableSet<String> inputKeys = OutputSetting.access$200(this).apply(DatabaseField::getSource).toIndexableSet().asUnmodifiable();
                final IndexableSet<String> outputKeys = OutputSetting.access$200(this).apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable();

                @Override
                public Iterable<Variant> converter(TextRecord input, TextInputOption source2, long pointer, GTBOutputOption target) throws IOException {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("chrom").toString()), input.get("pos").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    List<Map<String, Bytes>> parsers = PEXT.parseTxAnnotation(input.get("tx_annotation"), this.inputKeys);
                    String ref = input.get("ref").toString();
                    String alt = input.get("alt").toString();
                    List<Variant> variants = new List<Variant>(parsers.size());
                    for (Map<String, Bytes> parser : parsers) {
                        Variant variant = new Variant(coordinate).addAllele(ref).addAllele(alt).setProperty(new FixedIndexableMap<String, Object>(this.outputKeys));
                        variants.add(variant);
                        for (DatabaseField field : fields) {
                            Bytes value = parser.get(field.getSource());
                            if (value == null) {
                                variant.setProperty(field.getField().fullName(), null);
                                continue;
                            }
                            if (field.getField().type() == FieldType.string && value.valueEquals(this.NULL)) {
                                variant.setProperty(field.getField().fullName(), null);
                                continue;
                            }
                            variant.setProperty(field.getField().fullName(), value);
                        }
                    }
                    return variants;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

